/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class CreatePullRequestPanel
extends JPanel {
    private static final long serialVersionUID = 5695111005863831097L;
    private final DefaultComboBoxModel<Repository> baseRepositoryComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<RepositoryBranch> baseComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<Repository> headRepositoryComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<RepositoryBranch> headComboBoxModel = new DefaultComboBoxModel();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Map<Repository, List<RepositoryBranch>> baseRepositories;
    private final Map<Repository, List<RepositoryBranch>> headRepositories;
    public static final String PROP_COMPARE_PULL_REQUEST = "github.issues.pull.request.compare";
    private final JComboBox<RepositoryBranch> baseComboBox = new JComboBox();
    private JLabel baseLabel;
    private final JComboBox<Repository> baseRepositoryComboBox = new JComboBox();
    private JButton compareButton;
    private JLabel errorLabel;
    private final JComboBox<RepositoryBranch> headComboBox = new JComboBox();
    private JLabel headLabel;
    private final JComboBox<Repository> headRepositoryComboBox = new JComboBox();
    private JLabel messageLabel;

    public CreatePullRequestPanel(Map<Repository, List<RepositoryBranch>> baseRepositories, Map<Repository, List<RepositoryBranch>> headRepositories) {
        this.baseRepositories = baseRepositories;
        this.headRepositories = headRepositories;
        this.initComponents();
        this.baseRepositoryComboBox.setRenderer(new PullRequestListCellRenderer(this.baseRepositoryComboBox.getRenderer()));
        this.headRepositoryComboBox.setRenderer(new PullRequestListCellRenderer(this.headRepositoryComboBox.getRenderer()));
        this.baseComboBox.setRenderer(new PullRequestListCellRenderer(this.baseComboBox.getRenderer()));
        this.headComboBox.setRenderer(new PullRequestListCellRenderer(this.headComboBox.getRenderer()));
        this.addRepositories(this.baseRepositoryComboBoxModel, this.baseComboBoxModel, baseRepositories);
        this.addRepositories(this.headRepositoryComboBoxModel, this.headComboBoxModel, headRepositories);
        this.baseRepositoryComboBox.setModel(this.baseRepositoryComboBoxModel);
        this.headRepositoryComboBox.setModel(this.headRepositoryComboBoxModel);
        this.baseComboBox.setModel(this.baseComboBoxModel);
        this.headComboBox.setModel(this.headComboBoxModel);
        this.init();
    }

    private void addRepositories(DefaultComboBoxModel<Repository> repositoryModel, DefaultComboBoxModel<RepositoryBranch> branchModel, Map<Repository, List<RepositoryBranch>> repositories) {
        boolean first = true;
        for (Repository repository : repositories.keySet()) {
            repositoryModel.addElement(repository);
            if (!first) continue;
            first = false;
            this.addBranches(branchModel, repositories.get(repository));
        }
    }

    private void addBranches(DefaultComboBoxModel<RepositoryBranch> model, List<RepositoryBranch> branches) {
        model.removeAllElements();
        for (RepositoryBranch branch : branches) {
            model.addElement(branch);
        }
    }

    private void init() {
        this.setMessage("");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.setErrorMessage("");
        DefaultItemListener itemListener = new DefaultItemListener();
        this.baseComboBox.addItemListener(itemListener);
        this.headComboBox.addItemListener(itemListener);
        this.baseRepositoryComboBox.addItemListener(itemListener);
        this.headRepositoryComboBox.addItemListener(itemListener);
        this.baseRepositoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Repository repository = CreatePullRequestPanel.this.getSelectedBaseRepository();
                CreatePullRequestPanel.this.addBranches(CreatePullRequestPanel.this.baseComboBoxModel, (List)CreatePullRequestPanel.this.baseRepositories.get(repository));
            }
        });
        this.headRepositoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Repository repository = CreatePullRequestPanel.this.getSelectedHeadRepository();
                CreatePullRequestPanel.this.addBranches(CreatePullRequestPanel.this.baseComboBoxModel, (List)CreatePullRequestPanel.this.headRepositories.get(repository));
            }
        });
    }

    public void setCompareButtonEnabled(boolean isEnabled) {
        this.compareButton.setEnabled(isEnabled);
    }

    public Repository getSelectedBaseRepository() {
        return (Repository)this.baseRepositoryComboBox.getSelectedItem();
    }

    public RepositoryBranch getSelectedBaseBranch() {
        return (RepositoryBranch)this.baseComboBox.getSelectedItem();
    }

    public Repository getSelectedHeadRepository() {
        return (Repository)this.headRepositoryComboBox.getSelectedItem();
    }

    public RepositoryBranch getSelectedHeadBranch() {
        return (RepositoryBranch)this.headComboBox.getSelectedItem();
    }

    public void setMessage(String message) {
        this.messageLabel.setVisible(!StringUtils.isEmpty(message));
        this.messageLabel.setText(message);
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.isEmpty()) {
            this.errorLabel.setIcon(null);
        } else {
            this.errorLabel.setIcon(GitHubIcons.ERROR_ICON_16);
        }
        this.errorLabel.setText(errorMessage);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.baseLabel = new JLabel();
        this.headLabel = new JLabel();
        this.messageLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.compareButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.baseLabel, (String)NbBundle.getMessage(CreatePullRequestPanel.class, (String)"CreatePullRequestPanel.baseLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headLabel, (String)NbBundle.getMessage(CreatePullRequestPanel.class, (String)"CreatePullRequestPanel.headLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CreatePullRequestPanel.class, (String)"CreatePullRequestPanel.messageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(CreatePullRequestPanel.class, (String)"CreatePullRequestPanel.errorLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.compareButton, (String)NbBundle.getMessage(CreatePullRequestPanel.class, (String)"CreatePullRequestPanel.compareButton.text"));
        this.compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePullRequestPanel.this.compareButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.errorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.compareButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.baseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.baseRepositoryComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.baseComboBox, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.headLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headRepositoryComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.baseComboBox, -2, -1, -2).addComponent(this.baseLabel).addComponent(this.headLabel).addComponent(this.headComboBox, -2, -1, -2).addComponent(this.baseRepositoryComboBox, -2, -1, -2).addComponent(this.headRepositoryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.errorLabel).addComponent(this.compareButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void compareButtonActionPerformed(ActionEvent evt) {
        this.firePropertyChange(PROP_COMPARE_PULL_REQUEST, null, null);
    }

    private class DefaultItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            CreatePullRequestPanel.this.fireChange();
        }
    }

    private static class PullRequestListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8351981614538451529L;
        private final ListCellRenderer renderer;

        public PullRequestListCellRenderer(ListCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = null;
            if (value instanceof RepositoryBranch) {
                RepositoryBranch branch = (RepositoryBranch)value;
                text = branch.getName();
            } else if (value instanceof Repository) {
                Repository repository = (Repository)value;
                text = repository.getOwner().getLogin() + "/" + repository.getName();
            }
            if (text == null) {
                text = " ";
            }
            JLabel label = (JLabel)this.renderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
            return label;
        }
    }
}

