/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import com.junichi11.netbeans.modules.github.issues.issue.ui.Bundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FileChangedPanel
extends JPanel {
    private static final long serialVersionUID = 5842222768556582282L;
    private static final Logger LOGGER = Logger.getLogger(FileChangedPanel.class.getName());
    private final String hostname;
    private final CommitFile file;
    private final PullRequestMarker marker;
    private Component diffView;
    private JLabel additionsLabel;
    private JLabel deletionsLabel;
    private JButton diffButton;
    private JPanel diffPanel;
    private JLabel fileNameLabel;
    private JSeparator jSeparator1;

    public FileChangedPanel(CommitFile file, PullRequestMarker marker, String hostname) {
        this.file = file;
        this.marker = marker;
        this.hostname = hostname;
        this.initComponents();
        String filename = file.getFilename();
        this.fileNameLabel.setText(filename);
        this.diffPanel.setVisible(false);
        this.setAdditions(file.getAdditions());
        this.setDeletions(file.getDeletions());
    }

    private void setAdditions(int lines) {
        this.additionsLabel.setText("+" + String.valueOf(lines));
        this.additionsLabel.setForeground(GitHubIssues.GREEN_COLOR);
    }

    private void setDeletions(int lines) {
        this.deletionsLabel.setText("-" + String.valueOf(lines));
        this.deletionsLabel.setForeground(GitHubIssues.RED_COLOR);
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.diffButton = new JButton();
        this.diffPanel = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.deletionsLabel = new JLabel();
        this.additionsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(FileChangedPanel.class, (String)"FileChangedPanel.fileNameLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.diffButton, (String)NbBundle.getMessage(FileChangedPanel.class, (String)"FileChangedPanel.diffButton.text"));
        this.diffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileChangedPanel.this.diffButtonActionPerformed(evt);
            }
        });
        this.diffPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 500));
        this.diffPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.deletionsLabel, (String)NbBundle.getMessage(FileChangedPanel.class, (String)"FileChangedPanel.deletionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.additionsLabel, (String)NbBundle.getMessage(FileChangedPanel.class, (String)"FileChangedPanel.additionsLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 116, Short.MAX_VALUE).addComponent(this.additionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deletionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.diffButton)).addComponent(this.diffPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.diffButton).addComponent(this.fileNameLabel).addComponent(this.deletionsLabel).addComponent(this.additionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.diffPanel, -2, 300, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addGap(0, 0, 0)));
    }

    private void diffButtonActionPerformed(ActionEvent evt) {
        if (this.file == null) {
            return;
        }
        boolean isVisible = this.diffPanel.isVisible();
        this.diffPanel.setVisible(!isVisible);
        if (this.diffView != null) {
            return;
        }
        final String rawUrl = this.file.getRawUrl();
        if (rawUrl != null) {
            RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
            rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    String filename = FileChangedPanel.this.file.getFilename();
                    Repository repo = FileChangedPanel.this.marker.getRepo();
                    User owner = repo.getOwner();
                    String name = repo.getName();
                    String baseSha = FileChangedPanel.this.marker.getSha();
                    JLabel fetchingLabel = new JLabel(Bundle.FileChangedPanel_fetching_files());
                    FileChangedPanel.this.diffPanel.add((Component)fetchingLabel, "North");
                    ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.FileChangedPanel_fetching_files());
                    try {
                        InputStream baseInputStream;
                        InputStream prInputStream;
                        handle.start();
                        URL pullRequestRawUrl = new URL(rawUrl);
                        URL baseRawUrl = new URL(String.format("https://%s/%s/%s/raw/%s/%s", FileChangedPanel.this.hostname, owner.getLogin(), name, baseSha, filename));
                        try {
                            prInputStream = pullRequestRawUrl.openStream();
                        }
                        catch (FileNotFoundException ex) {
                            prInputStream = new ByteArrayInputStream("".getBytes());
                        }
                        try {
                            baseInputStream = baseRawUrl.openStream();
                        }
                        catch (FileNotFoundException ex) {
                            baseInputStream = new ByteArrayInputStream("".getBytes());
                        }
                        BufferedReader prReader = new BufferedReader(new InputStreamReader(prInputStream, StandardCharsets.UTF_8));
                        BufferedReader baseReader = new BufferedReader(new InputStreamReader(baseInputStream, StandardCharsets.UTF_8));
                        String mimeType = FileChangedPanel.getMimeType(filename);
                        String prSha = FileChangedPanel.this.file.getSha();
                        StreamSource prSource = StreamSource.createSource((String)filename, (String)prSha, (String)mimeType, (Reader)prReader);
                        StreamSource baseSource = StreamSource.createSource((String)filename, (String)baseSha, (String)mimeType, (Reader)baseReader);
                        final DiffView view = Diff.getDefault().createDiff(baseSource, prSource);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FileChangedPanel.this.diffView = view.getComponent();
                                FileChangedPanel.this.diffPanel.add(FileChangedPanel.this.diffView, "Center");
                            }
                        });
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        SwingUtilities.invokeLater(new Runnable(fetchingLabel){
                            final /* synthetic */ JLabel val$fetchingLabel;
                            {
                                this.val$fetchingLabel = jLabel;
                            }

                            @Override
                            public void run() {
                                FileChangedPanel.this.diffPanel.remove(this.val$fetchingLabel);
                            }
                        });
                        handle.finish();
                    }
                    catch (IOException ex2) {
                        LOGGER.log(Level.WARNING, null, ex2);
                        {
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                handle.finish();
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        handle.finish();
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    handle.finish();
                }
            });
        }
    }

    private static String getMimeType(String fileName) {
        return "";
    }
}

