/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import com.junichi11.netbeans.modules.github.issues.issue.ui.DiffTopComponent;
import com.junichi11.netbeans.modules.github.issues.issue.ui.FileChangedPanel;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.EditorKit;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

final class FilesChangedPanel
extends JPanel
implements PropertyChangeListener {
    public String diffUrl;
    public String diff;
    private String displayName;
    private TopComponent diffTopComponent;
    private static final String DIFF_MIME_TYPE = "text/x-diff";
    private static final Logger LOGGER = Logger.getLogger(FilesChangedPanel.class.getName());
    private static final long serialVersionUID = 9077936142573482362L;
    private JLabel additionsLabel;
    private JLabel deletionsLabel;
    private JButton diffButton;
    private JEditorPane diffEditorPane;
    private JPanel diffPanel;
    private JScrollPane diffScrollPane;
    private JPanel filesPanel;

    public FilesChangedPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setMimeType();
    }

    private void setMimeType() {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)DIFF_MIME_TYPE);
        this.diffEditorPane.setEditorKit(editorKit);
        this.diffEditorPane.getDocument().putProperty("mimeType", DIFF_MIME_TYPE);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDisplayName() {
        if (this.displayName == null) {
            return "Diff";
        }
        int length = this.displayName.length();
        if (length > 16) {
            return this.displayName.substring(0, 16) + "...";
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDetails(PullRequest pullRequest) {
        assert (EventQueue.isDispatchThread());
        if (pullRequest == null) {
            return;
        }
        this.setAdditions(pullRequest.getAdditions());
        this.setDeletions(pullRequest.getDeletions());
        this.diffUrl = pullRequest.getDiffUrl();
    }

    public void addFile(CommitFile file, PullRequestMarker marker, String hostname) {
        assert (EventQueue.isDispatchThread());
        if (file == null) {
            return;
        }
        FileChangedPanel fileChangedPanel = new FileChangedPanel(file, marker, hostname);
        this.filesPanel.add(fileChangedPanel);
    }

    public void removeAllFiles() {
        assert (EventQueue.isDispatchThread());
        this.filesPanel.removeAll();
    }

    private void setAdditions(int lines) {
        this.additionsLabel.setText("+" + String.valueOf(lines));
        this.additionsLabel.setForeground(GitHubIssues.GREEN_COLOR);
    }

    private void setDeletions(int lines) {
        this.deletionsLabel.setText("-" + String.valueOf(lines));
        this.deletionsLabel.setForeground(GitHubIssues.RED_COLOR);
    }

    private void initComponents() {
        this.diffPanel = new JPanel();
        this.diffScrollPane = new JScrollPane();
        this.diffEditorPane = new JEditorPane();
        this.diffButton = new JButton();
        this.deletionsLabel = new JLabel();
        this.additionsLabel = new JLabel();
        this.filesPanel = new JPanel();
        this.diffEditorPane.setEditable(false);
        this.diffEditorPane.setContentType(DIFF_MIME_TYPE);
        this.diffScrollPane.setViewportView(this.diffEditorPane);
        GroupLayout diffPanelLayout = new GroupLayout(this.diffPanel);
        this.diffPanel.setLayout(diffPanelLayout);
        diffPanelLayout.setHorizontalGroup(diffPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.diffScrollPane, -1, 550, Short.MAX_VALUE));
        diffPanelLayout.setVerticalGroup(diffPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.diffScrollPane, -1, 345, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.diffButton, (String)NbBundle.getMessage(FilesChangedPanel.class, (String)"FilesChangedPanel.diffButton.text"));
        this.diffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilesChangedPanel.this.diffButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.deletionsLabel, (String)NbBundle.getMessage(FilesChangedPanel.class, (String)"FilesChangedPanel.deletionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.additionsLabel, (String)NbBundle.getMessage(FilesChangedPanel.class, (String)"FilesChangedPanel.additionsLabel.text"));
        this.filesPanel.setLayout(new BoxLayout(this.filesPanel, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filesPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.diffButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 108, Short.MAX_VALUE).addComponent(this.additionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deletionsLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.diffButton).addComponent(this.deletionsLabel).addComponent(this.additionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void diffButtonActionPerformed(ActionEvent evt) {
        AtomicBoolean cancel = new AtomicBoolean();
        if (this.diffTopComponent != null) {
            this.diffTopComponent.requestActive();
            return;
        }
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener((PropertyChangeListener)this);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                final String diffText = FilesChangedPanel.this.fetchDiff();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FilesChangedPanel.this.diffEditorPane.setText(diffText);
                        FilesChangedPanel.this.diffTopComponent = new DiffTopComponent();
                        FilesChangedPanel.this.diffTopComponent.setDisplayName(FilesChangedPanel.this.getShortDisplayName());
                        FilesChangedPanel.this.diffTopComponent.setToolTipText(FilesChangedPanel.this.getDisplayName());
                        FilesChangedPanel.this.diffTopComponent.setLayout((LayoutManager)new BorderLayout());
                        FilesChangedPanel.this.diffTopComponent.add((Component)FilesChangedPanel.this.diffPanel, (Object)"Center");
                        FilesChangedPanel.this.diffTopComponent.open();
                        FilesChangedPanel.this.diffTopComponent.requestActive();
                    }
                });
            }
        };
        BaseProgressUtils.runOffEventDispatchThread((Runnable)task, (String)"Fetching diff...", (AtomicBoolean)cancel, (boolean)false);
    }

    private String fetchDiff() {
        if (this.diff != null) {
            return this.diff;
        }
        if (StringUtils.isEmpty(this.diffUrl)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(this.diffUrl);
            try (BufferedInputStream inputStream = new BufferedInputStream(url.openStream());
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        this.diff = sb.toString();
        return this.diff;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.diffTopComponent == null) {
            return;
        }
        if (evt.getPropertyName().equals("tcClosed") && evt.getNewValue() == this.diffTopComponent) {
            TopComponent.Registry registry = TopComponent.getRegistry();
            registry.removePropertyChangeListener((PropertyChangeListener)this);
            this.diffTopComponent.removeAll();
            this.diffTopComponent = null;
        }
    }
}

