/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.GitHubIssueState;
import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import com.junichi11.netbeans.modules.github.issues.GitHubIssuesConfig;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssueController;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssueSupport;
import com.junichi11.netbeans.modules.github.issues.issue.ui.AttributesViewPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.Bundle;
import com.junichi11.netbeans.modules.github.issues.issue.ui.CommentTabbedPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.CommentsPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.CommitsPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.FilesChangedPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.InsertTemplatePanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.LabelPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.ManageTemplatesPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.MergePanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.MilestonePanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.TemplatePanel;
import com.junichi11.netbeans.modules.github.issues.options.GitHubIssuesOptions;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.ui.AttributesListCellRenderer;
import com.junichi11.netbeans.modules.github.issues.utils.GitHubIssuesUtils;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.User;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.bugtracking.commons.CollapsibleSectionPanel;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GitHubIssuePanel
extends JPanel {
    private static final long serialVersionUID = -4871443269659315479L;
    private PullRequest newPullRequest;
    private GitHubIssue gitHubIssue;
    private CommentsPanel commentsPanel;
    private FilesChangedPanel filesChangedPanel;
    private CommitsPanel commitsPanel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final DefaultComboBoxModel<Milestone> milestoneComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<User> assigneeComboBoxModel = new DefaultComboBoxModel();
    private final DefaultListModel<Label> labelsListModel = new DefaultListModel();
    private static final Logger LOGGER = Logger.getLogger(GitHubIssuePanel.class.getName());
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final String repositoryId;
    private static final String TEMPLATES_ADD_OPTION = Bundle.GitHubIssuePanel_manage_templates_add_option();
    private static final String TEMPLATES_EDIT_OPTION = Bundle.GitHubIssuePanel_manage_templates_edit_option();
    private static final String TEMPLATES_DUPLICATE_OPTION = Bundle.GitHubIssuePanel_manage_templates_duplicate_option();
    private static final String TEMPLATES_REMOVE_OPTION = Bundle.GitHubIssuePanel_manage_templates_remove_option();
    private static final String TEMPLATES_CLOSE_OPTION = Bundle.GitHubIssuePanel_manage_templates_close_option();
    private LinkButton assignYourselfLinkButton;
    private JComboBox<User> assigneeComboBox;
    private JLabel assigneeLabel;
    private AttributesViewPanel attributesViewPanel;
    private JButton changeToPullRequestButton;
    private CollapsibleSectionPanel commentsCollapsibleSectionPanel;
    private final CollapsibleSectionPanel commitsCollapsibleSectionPanel = new CollapsibleSectionPanel();
    private JLabel descriptionLabel;
    private CommentTabbedPanel descriptionTabbedPanel;
    private JPanel dummyCommentsPanel;
    private JPanel dummyCommitsPanel;
    private JPanel dummyFilesChangedPanel;
    private CollapsibleSectionPanel filesChangedcollapsibleSectionPanel;
    private JLabel headerCreatedByLabel;
    private JLabel headerCreatedByUserLabel;
    private JLabel headerCreatedDateLabel;
    private JLabel headerCreatedLabel;
    private JLabel headerErrorLabel;
    private JLabel headerNameLabel;
    private JPanel headerPanel;
    private JLabel headerPrBaseHeadLabel;
    private LinkButton headerShowInBrowserLinkButton;
    private JLabel headerStatusLabel;
    private JButton headerSubmitButton;
    private JLabel headerUpdatedDateLabel;
    private JLabel headerUpdatedLabel;
    private JButton insertTemplateButton;
    private JSeparator jSeparator1;
    private JLabel labelsLabel;
    private JList<Label> labelsList;
    private JScrollPane labelsScrollPane;
    private JPanel mainCommentsPanel;
    private JPanel mainCommitsPanel;
    private JPanel mainFilesChangedPanel;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JButton manageTemplatesButton;
    private final MergePanel mergePanel = new MergePanel();
    private JComboBox<Milestone> milestoneComboBox;
    private JLabel milestoneLabel;
    private JButton newCommentButton;
    private JButton newCommentCloseReopenIssueButton;
    private JLabel newCommentLabel;
    private CommentTabbedPanel newCommentTabbedPanel;
    private JButton newLabelButton;
    private JButton newMilestoneButton;
    private JToggleButton newPullRequestToggleButton;
    private LinkButton refreshLinkButton;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public GitHubIssuePanel(String repositoryId) {
        this.repositoryId = repositoryId;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.milestoneComboBox.setRenderer(new AttributesListCellRenderer(this.milestoneComboBox.getRenderer()));
        this.assigneeComboBox.setRenderer(new AttributesListCellRenderer(this.assigneeComboBox.getRenderer(), this.repositoryId));
        this.labelsList.setCellRenderer(new AttributesListCellRenderer(this.labelsList.getCellRenderer()));
        this.milestoneComboBox.setModel(this.milestoneComboBoxModel);
        this.assigneeComboBox.setModel(this.assigneeComboBoxModel);
        this.labelsList.setModel(this.labelsListModel);
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.titleTextField.getDocument().addDocumentListener(documentListener);
        MergePropertyChangeListener mergeChangeListener = new MergePropertyChangeListener();
        this.mergePanel.addPropertyChangeListener(mergeChangeListener);
        this.headerErrorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.setErrorMessage("");
        Font font = this.headerErrorLabel.getFont();
        this.headerNameLabel.setFont(font.deriveFont((float)((double)font.getSize() * 1.5)));
        this.headerNameLabel.setIcon(GitHubIcons.GITHUB_ICON_32);
        this.headerStatusLabel.setBorder(new EmptyBorder(3, 5, 3, 5));
        Font bold = new Font(font.getName(), 1, font.getSize());
        this.headerCreatedByUserLabel.setFont(bold);
        this.headerStatusLabel.setFont(bold);
        this.commentsPanel = new CommentsPanel();
        ((GroupLayout)this.mainCommentsPanel.getLayout()).replace(this.dummyCommentsPanel, this.commentsPanel);
        this.filesChangedPanel = new FilesChangedPanel();
        ((GroupLayout)this.mainFilesChangedPanel.getLayout()).replace(this.dummyFilesChangedPanel, this.filesChangedPanel);
        this.commitsPanel = new CommitsPanel();
        ((GroupLayout)this.mainCommitsPanel.getLayout()).replace(this.dummyCommitsPanel, this.commitsPanel);
    }

    public boolean isNew() {
        assert (this.gitHubIssue != null);
        return this.gitHubIssue.isNew();
    }

    public void setIssue(GitHubIssue gitHubIssue) {
        this.gitHubIssue = gitHubIssue;
        if (this.isNew() && GitHubIssuesOptions.getInstance().insertDefaultTemplate()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String template = GitHubIssuesConfig.getInstance().getTemplate("default");
                    GitHubIssuePanel.this.descriptionTabbedPanel.setText(template);
                }
            });
        }
    }

    public GitHubIssue getIssue() {
        return this.gitHubIssue;
    }

    private GitHubRepository getRepository() {
        if (this.gitHubIssue == null) {
            return null;
        }
        return this.gitHubIssue.getRepository();
    }

    @CheckForNull
    private PullRequest getPullRequest() {
        if (this.isPullRequest()) {
            GitHubIssue issue = this.getIssue();
            GitHubRepository repository = this.getRepository();
            if (repository != null) {
                return repository.getPullRequest(issue.getIssue().getNumber(), false);
            }
        }
        return null;
    }

    private boolean isPullRequest() {
        GitHubIssue issue = this.getIssue();
        return GitHubIssuesUtils.isPullRequest(issue.getIssue());
    }

    private boolean isMerged() {
        PullRequest pullRequest;
        if (this.isPullRequest() && (pullRequest = this.getPullRequest()) != null) {
            return pullRequest.isMerged();
        }
        return false;
    }

    private boolean isMergeable() {
        PullRequest pullRequest;
        if (this.isPullRequest() && (pullRequest = this.getPullRequest()) != null) {
            return pullRequest.isMergeable() && !pullRequest.isMerged() && pullRequest.getState().equals("open");
        }
        return false;
    }

    public boolean isNewPullRequestSelected() {
        return this.newPullRequestToggleButton.isSelected();
    }

    public void setNewPullRequestSelected(boolean isSelected) {
        this.newPullRequestToggleButton.setSelected(isSelected);
    }

    public void setNewPullRequest(PullRequest pullRequest) {
        assert (EventQueue.isDispatchThread());
        this.newPullRequest = pullRequest;
        this.setPullRequestHeader();
        if (pullRequest != null) {
            this.headerNameLabel.setText(Bundle.GitHubIssuePanel_label_header_name_new_pull_request());
            this.headerSubmitButton.setText(Bundle.GitHubIssuePanel_label_header_submit_button_new_pull_request());
        } else {
            this.headerNameLabel.setText(Bundle.GitHubIssuePanel_label_header_name_new());
            this.headerSubmitButton.setText(Bundle.GitHubIssuePanel_label_header_submit_button_new());
        }
    }

    @CheckForNull
    public PullRequest getNewPullRequest() {
        return this.newPullRequest;
    }

    public void update() {
        Issue issue;
        assert (EventQueue.isDispatchThread());
        this.setHeader();
        if (this.gitHubIssue == null) {
            return;
        }
        GitHubRepository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        boolean isCollaborator = repository.isCollaborator();
        if (isCollaborator) {
            GitHubCache cache = GitHubCache.create(repository);
            this.updateMilestones(cache, false);
            List<User> collaborators = cache.getCollaborators();
            this.assigneeComboBoxModel.removeAllElements();
            this.assigneeComboBoxModel.addElement(null);
            for (User collaborator : collaborators) {
                this.assigneeComboBoxModel.addElement(collaborator);
            }
            this.updateLables(cache, false);
        }
        boolean isExistingIssue = !this.isNew();
        boolean isPullRequest = this.isPullRequest();
        if (isExistingIssue && (issue = this.gitHubIssue.getIssue()) != null) {
            List labels;
            Milestone milestone;
            User user = issue.getUser();
            GitHubCache cache = GitHubCache.create(repository);
            Icon userIcon = cache.getUserIcon(user);
            this.headerCreatedDateLabel.setText(DATE_FORMAT.format(issue.getCreatedAt()));
            this.headerUpdatedDateLabel.setText(DATE_FORMAT.format(issue.getUpdatedAt()));
            this.headerCreatedByUserLabel.setText(user.getLogin());
            this.headerCreatedByUserLabel.setIcon(userIcon);
            this.titleTextField.setText(issue.getTitle());
            Dimension dim = this.titleTextField.getPreferredSize();
            this.titleTextField.setMinimumSize(new Dimension(0, dim.height));
            this.titleTextField.setPreferredSize(new Dimension(0, dim.height));
            this.descriptionTabbedPanel.setText(issue.getBody());
            User assignee = issue.getAssignee();
            if (assignee != null) {
                this.setAssigneeSelected(assignee);
            }
            if ((milestone = issue.getMilestone()) != null) {
                this.setMilestoneSelected(milestone);
            }
            if (!(labels = issue.getLabels()).isEmpty()) {
                this.setLabelsSelected(labels);
            }
            this.attributesViewPanel.setAttributes(issue, repository);
            GitHubIssueState state = GitHubIssueState.toEnum(issue.getState());
            this.setNewCommentButtonCloseOrReopen(state == GitHubIssueState.CLOSED);
            boolean isEditable = this.gitHubIssue.isEditableUser();
            this.titleTextField.setEditable(isEditable);
            this.descriptionTabbedPanel.setEditable(isEditable);
            this.commentsPanel.removeAllComments();
            List<Comment> comments = this.gitHubIssue.getComments();
            this.commentsCollapsibleSectionPanel.setLabel(Bundle.GitHubIssuePanel_comment_count(comments.size()));
            for (Comment comment : comments) {
                String body = comment.getBody();
                String bodyHtml = StringUtils.markdownToHtml(body);
                comment.setBodyHtml(String.format("<html>%s</html>", bodyHtml));
            }
            this.commentsPanel.addComments(comments, repository);
            if (isPullRequest) {
                PullRequest pullRequest = this.getPullRequest();
                PullRequestMarker base = pullRequest.getBase();
                int id = this.getIssue().getIssue().getNumber();
                String summary = this.getIssue().getSummary();
                List<RepositoryCommit> commits = repository.getCommits(id);
                this.commitsPanel.removeAllCommits();
                this.commitsCollapsibleSectionPanel.setLabel(Bundle.GitHubIssuePanel_commit_count(commits.size()));
                for (RepositoryCommit commit : commits) {
                    Icon commiterIcon = cache.getUserIcon(commit.getCommitter());
                    this.commitsPanel.addCommit(commit.getCommit(), commiterIcon);
                }
                List<CommitFile> pullRequestsFiles = repository.getPullRequestsFiles(issue.getNumber());
                this.filesChangedPanel.setDisplayName(String.format("[Diff] #%s - %s", id, summary));
                this.filesChangedPanel.removeAllFiles();
                this.filesChangedPanel.setDetails(pullRequest);
                this.filesChangedcollapsibleSectionPanel.setLabel(Bundle.GitHubIssuePanel_files_changed_count(pullRequestsFiles.size()));
                boolean isMergeable = this.isMergeable();
                this.mergePanel.setMergeButtonEnabled(isMergeable);
                if (isMergeable) {
                    this.mergePanel.setCommitMessage(summary);
                }
            }
        }
        this.setCommentsSectionVisible(isExistingIssue);
        this.setNewCommentVisible(isExistingIssue);
        this.setCollaboratorsComponentsVisible(isCollaborator);
        this.attributesViewPanel.setVisible(isExistingIssue);
        this.commitsCollapsibleSectionPanel.setVisible(isPullRequest);
        this.filesChangedcollapsibleSectionPanel.setVisible(isPullRequest);
        this.mergePanel.setVisible(isPullRequest && isCollaborator);
        this.fireChange();
    }

    private void updateMilestones(GitHubCache cache, boolean force) {
        List<Milestone> milestones = cache.getMilestones("open", force);
        this.milestoneComboBoxModel.removeAllElements();
        this.milestoneComboBoxModel.addElement(null);
        for (Milestone milestone : milestones) {
            this.milestoneComboBoxModel.addElement(milestone);
        }
    }

    private void updateLables(GitHubCache cache, boolean force) {
        List<Label> labels = cache.getLabels(force);
        this.labelsListModel.removeAllElements();
        this.labelsListModel.addElement(null);
        for (Label label : labels) {
            this.labelsListModel.addElement(label);
        }
    }

    public void loadComments() {
        this.commentsPanel.loadComments(this.getRepository());
        this.fireChange();
    }

    private void setAssigneeSelected(User assignee) {
        int size = this.assigneeComboBoxModel.getSize();
        for (int i = 0; i < size; ++i) {
            User user = this.assigneeComboBoxModel.getElementAt(i);
            if (user == null || !user.getLogin().equals(assignee.getLogin())) continue;
            this.assigneeComboBox.setSelectedItem(user);
            break;
        }
    }

    private void setMilestoneSelected(Milestone milestone) {
        if (milestone == null) {
            return;
        }
        int size = this.milestoneComboBoxModel.getSize();
        for (int i = 0; i < size; ++i) {
            Milestone m = this.milestoneComboBoxModel.getElementAt(i);
            if (m == null || m.getNumber() != milestone.getNumber()) continue;
            this.milestoneComboBox.setSelectedItem(m);
            return;
        }
        this.milestoneComboBoxModel.addElement(milestone);
        this.milestoneComboBox.setSelectedItem(milestone);
    }

    private void setLabelsSelected(List<Label> labels) {
        int size = labels.size();
        int[] indices = new int[size];
        int labelIndex = 0;
        for (Label label : labels) {
            for (int i = 0; i < this.labelsListModel.getSize(); ++i) {
                Label l = this.labelsListModel.getElementAt(i);
                if (l == null || !l.getName().equals(label.getName())) continue;
                indices[labelIndex] = i;
                break;
            }
            ++labelIndex;
        }
        this.labelsList.setSelectedIndices(indices);
    }

    private void setCollaboratorsComponentsVisible(boolean isVisible) {
        this.labelsLabel.setVisible(isVisible);
        this.labelsScrollPane.setVisible(isVisible);
        this.milestoneLabel.setVisible(isVisible);
        this.milestoneComboBox.setVisible(isVisible);
        this.assigneeLabel.setVisible(isVisible);
        this.assigneeComboBox.setVisible(isVisible);
        this.assignYourselfLinkButton.setVisible(isVisible);
        this.newLabelButton.setVisible(isVisible);
        this.newMilestoneButton.setVisible(isVisible);
    }

    private void setHeader() {
        this.setErrorMessage("");
        if (this.gitHubIssue == null) {
            this.headerSubmitButton.setVisible(false);
            return;
        }
        boolean isNew = this.isNew();
        GitHubIssueState state = GitHubIssueState.NEW;
        this.newPullRequestToggleButton.setVisible(isNew);
        if (isNew) {
            this.headerNameLabel.setText(Bundle.GitHubIssuePanel_label_header_name_new());
            this.headerSubmitButton.setText(Bundle.GitHubIssuePanel_label_header_submit_button_new());
        } else {
            String summary = this.gitHubIssue.getSummary();
            this.headerNameLabel.setText(String.format("%s #%s", summary, this.gitHubIssue.getID()));
            Dimension dim = this.headerNameLabel.getPreferredSize();
            this.headerNameLabel.setMinimumSize(new Dimension(0, dim.height));
            this.headerNameLabel.setPreferredSize(new Dimension(0, dim.height));
            this.headerSubmitButton.setText(Bundle.GitHubIssuePanel_label_header_submit_button());
            this.headerSubmitButton.setVisible(this.gitHubIssue.isEditableUser());
            Issue issue = this.gitHubIssue.getIssue();
            if (issue != null) {
                state = GitHubIssueState.toEnum(issue.getState());
            }
        }
        this.setHeaderStatus(state);
        this.setPullRequestHeader();
    }

    private void setPullRequestHeader() {
        boolean isPullRequest = this.isPullRequest();
        boolean isNewPullRequestSelected = this.isNewPullRequestSelected();
        if (this.isNew()) {
            this.changeToPullRequestButton.setVisible(false);
            if (isNewPullRequestSelected) {
                this.setPullRequestBaseHeadLabel(this.getNewPullRequest());
            } else {
                this.setPullRequestBaseHeadLabel(null);
            }
        } else {
            this.headerPrBaseHeadLabel.setVisible(isPullRequest);
            if (isPullRequest) {
                this.setPullRequestBaseHeadLabel(this.getPullRequest());
                this.changeToPullRequestButton.setVisible(false);
            } else {
                this.headerPrBaseHeadLabel.setText(" ");
                this.changeToPullRequestButton.setVisible(this.getIssue().isCreatedUser());
            }
        }
    }

    private void setPullRequestBaseHeadLabel(PullRequest pullRequest) {
        if (pullRequest != null) {
            PullRequestMarker base = pullRequest.getBase();
            PullRequestMarker head = pullRequest.getHead();
            this.setPullRequestBaseHeadLabel(base.getLabel(), head.getLabel());
        } else {
            this.setPullRequestBaseHeadLabel("", "");
        }
        this.headerPrBaseHeadLabel.setVisible(pullRequest != null);
    }

    private void setPullRequestBaseHeadLabel(String base, String head) {
        this.headerPrBaseHeadLabel.setText(String.format("<html>Base: <b>%s</b> Head: <b>%s</b>", base, head));
    }

    private void setHeaderStatus(GitHubIssueState status) {
        String text = "";
        Icon icon = null;
        boolean opaque = false;
        boolean visible = false;
        Color background = this.getBackground();
        Color foreground = this.getForeground();
        switch (status) {
            case NEW: {
                break;
            }
            case OPEN: {
                GitHubIssue issue = this.getIssue();
                boolean isPR = GitHubIssuesUtils.isPullRequest(issue.getIssue());
                text = "Open";
                icon = isPR ? GitHubIcons.GIT_PULL_REQUEST_ICON_16 : GitHubIcons.ISSUE_OPENED_ICON_16;
                opaque = true;
                visible = true;
                background = GitHubIssues.OPEN_STATE_COLOR;
                foreground = Color.WHITE;
                break;
            }
            case CLOSED: {
                GitHubIssue issue = this.getIssue();
                boolean isPR = GitHubIssuesUtils.isPullRequest(issue.getIssue());
                PullRequest pullRequest = this.getPullRequest();
                text = this.isMerged() ? "Merged" : "Closed";
                icon = isPR ? GitHubIcons.GIT_PULL_REQUEST_ICON_16 : GitHubIcons.ISSUE_CLOSED_ICON_16;
                opaque = true;
                visible = true;
                background = isPR && pullRequest != null && pullRequest.isMerged() ? GitHubIssues.MERGED_STATE_COLOR : GitHubIssues.CLOSED_STATE_COLOR;
                foreground = Color.WHITE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.headerStatusLabel.setText(text);
        this.headerStatusLabel.setIcon(icon);
        this.headerStatusLabel.setBackground(background);
        this.headerStatusLabel.setForeground(foreground);
        this.headerStatusLabel.setOpaque(opaque);
        this.headerStatusLabel.setVisible(visible);
    }

    private void setNewCommentButtonCloseOrReopen(boolean isClosed) {
        if (isClosed) {
            if (this.isPullRequest()) {
                this.newCommentCloseReopenIssueButton.setText(Bundle.GitHubIssuePanel_label_reopen_pull_request());
            } else {
                this.newCommentCloseReopenIssueButton.setText(Bundle.GitHubIssuePanel_label_reopen_issue());
            }
            return;
        }
        if (this.isPullRequest()) {
            this.newCommentCloseReopenIssueButton.setText(Bundle.GitHubIssuePanel_label_close_pull_request());
        } else {
            this.newCommentCloseReopenIssueButton.setText(Bundle.GitHubIssuePanel_label_close_issue());
        }
    }

    public String getTitle() {
        return this.titleTextField.getText().trim();
    }

    public String getDescription() {
        return this.descriptionTabbedPanel.getText();
    }

    public User getAssignee() {
        return (User)this.assigneeComboBox.getSelectedItem();
    }

    public Milestone getMilestone() {
        return (Milestone)this.milestoneComboBox.getSelectedItem();
    }

    public List<Label> getLabels() {
        List<Label> selectedValuesList = this.labelsList.getSelectedValuesList();
        ArrayList<Label> labels = new ArrayList<Label>();
        for (Label l : selectedValuesList) {
            if (l == null) continue;
            labels.add(l);
        }
        return labels;
    }

    public String getNewComment() {
        return this.newCommentTabbedPanel.getText();
    }

    public void setNewComment(String comment) {
        this.newCommentTabbedPanel.setText(comment);
    }

    public void appendNewComment(String comment) {
        if (comment == null) {
            return;
        }
        this.newCommentTabbedPanel.appendText(comment);
    }

    public String getQuoteComment() {
        return this.commentsPanel.getQuoteComment();
    }

    public Comment getEditedComment() {
        return this.commentsPanel.getEditedComment();
    }

    public Comment getDeletedComment() {
        return this.commentsPanel.getDeletedComment();
    }

    public void removeDeletedComment() {
        this.commentsPanel.removeDeletedCommlent();
    }

    public void addCommentsChangeListener(PropertyChangeListener listener) {
        this.commentsPanel.addPropertyChangeListener(listener);
    }

    public void removeCommentsChangeListener(PropertyChangeListener listener) {
        this.commentsPanel.removePropertyChangeListener(listener);
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().isEmpty()) {
            errorMessage = "";
            this.headerErrorLabel.setIcon(null);
            this.headerSubmitButton.setEnabled(true);
        } else {
            this.headerErrorLabel.setIcon(GitHubIcons.ERROR_ICON_16);
            this.headerSubmitButton.setEnabled(false);
        }
        this.headerErrorLabel.setText(errorMessage);
    }

    private void setNewCommentVisible(boolean isVisible) {
        this.newCommentLabel.setVisible(isVisible);
        this.newCommentTabbedPanel.setVisible(isVisible);
        this.newCommentButton.setVisible(isVisible);
        if (isVisible) {
            this.newCommentCloseReopenIssueButton.setVisible(this.gitHubIssue.isEditableUser() && !this.isMerged());
        } else {
            this.newCommentCloseReopenIssueButton.setVisible(false);
        }
    }

    private void setCommentsSectionVisible(boolean isVisible) {
        this.commentsCollapsibleSectionPanel.setVisible(isVisible);
    }

    public void setNewCommentEnabled(boolean isEnabled) {
        this.newCommentTabbedPanel.setEnabled(isEnabled);
        this.newCommentButton.setEnabled(isEnabled);
        this.newCommentCloseReopenIssueButton.setEnabled(isEnabled);
    }

    public void setSubmitButtonEnabled(boolean isEnabled) {
        this.headerSubmitButton.setEnabled(isEnabled);
    }

    public void setCreatePullRequestButtonEnabled(boolean isEnabled) {
        this.changeToPullRequestButton.setEnabled(isEnabled);
    }

    public void addAction(GitHubIssueController.SubmitIssueAction listener) {
        this.headerSubmitButton.addActionListener(listener);
    }

    public void addAction(GitHubIssueController.CommentAction listener) {
        this.newCommentButton.addActionListener(listener);
    }

    public void addAction(GitHubIssueController.CloseReopenAction listener) {
        this.newCommentCloseReopenIssueButton.addActionListener(listener);
    }

    public void addAction(GitHubIssueController.CreatePullRequestAction listener) {
        this.changeToPullRequestButton.addActionListener(listener);
        this.newPullRequestToggleButton.addActionListener(listener);
    }

    public void removeAction(GitHubIssueController.SubmitIssueAction listener) {
        this.headerSubmitButton.removeActionListener(listener);
    }

    public void removeAction(GitHubIssueController.CommentAction listener) {
        this.newCommentButton.removeActionListener(listener);
    }

    public void removeAction(GitHubIssueController.CloseReopenAction listener) {
        this.newCommentCloseReopenIssueButton.removeActionListener(listener);
    }

    public void removeAction(GitHubIssueController.CreatePullRequestAction listener) {
        this.changeToPullRequestButton.removeActionListener(listener);
        this.newPullRequestToggleButton.removeActionListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.mainCommentsPanel = new JPanel();
        this.dummyCommentsPanel = new JPanel();
        this.mainFilesChangedPanel = new JPanel();
        this.dummyFilesChangedPanel = new JPanel();
        this.mainCommitsPanel = new JPanel();
        this.dummyCommitsPanel = new JPanel();
        this.headerPanel = new JPanel();
        this.headerSubmitButton = new JButton();
        this.headerNameLabel = new JLabel();
        this.headerErrorLabel = new JLabel();
        this.headerCreatedLabel = new JLabel();
        this.headerCreatedDateLabel = new JLabel();
        this.headerUpdatedLabel = new JLabel();
        this.headerUpdatedDateLabel = new JLabel();
        this.headerCreatedByLabel = new JLabel();
        this.headerCreatedByUserLabel = new JLabel();
        this.headerStatusLabel = new JLabel();
        this.headerShowInBrowserLinkButton = new LinkButton();
        this.jSeparator1 = new JSeparator();
        this.refreshLinkButton = new LinkButton();
        this.newLabelButton = new JButton();
        this.newMilestoneButton = new JButton();
        this.headerPrBaseHeadLabel = new JLabel();
        this.changeToPullRequestButton = new JButton();
        this.newPullRequestToggleButton = new JToggleButton();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.assigneeLabel = new JLabel();
        this.assigneeComboBox = new JComboBox();
        this.titleTextField = new JTextField();
        this.milestoneLabel = new JLabel();
        this.milestoneComboBox = new JComboBox();
        this.descriptionLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.labelsLabel = new JLabel();
        this.labelsScrollPane = new JScrollPane();
        this.labelsList = new JList();
        this.descriptionTabbedPanel = new CommentTabbedPanel();
        this.newCommentLabel = new JLabel();
        this.newCommentTabbedPanel = new CommentTabbedPanel();
        this.newCommentButton = new JButton();
        this.newCommentCloseReopenIssueButton = new JButton();
        this.attributesViewPanel = new AttributesViewPanel();
        this.assignYourselfLinkButton = new LinkButton();
        this.commentsCollapsibleSectionPanel = new CollapsibleSectionPanel();
        this.insertTemplateButton = new JButton();
        this.manageTemplatesButton = new JButton();
        this.filesChangedcollapsibleSectionPanel = new CollapsibleSectionPanel();
        this.dummyCommentsPanel.setLayout(new BorderLayout());
        GroupLayout mainCommentsPanelLayout = new GroupLayout(this.mainCommentsPanel);
        this.mainCommentsPanel.setLayout(mainCommentsPanelLayout);
        mainCommentsPanelLayout.setHorizontalGroup(mainCommentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyCommentsPanel, -1, 791, Short.MAX_VALUE));
        mainCommentsPanelLayout.setVerticalGroup(mainCommentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyCommentsPanel, -1, 13, Short.MAX_VALUE));
        this.dummyFilesChangedPanel.setLayout(new BorderLayout());
        GroupLayout mainFilesChangedPanelLayout = new GroupLayout(this.mainFilesChangedPanel);
        this.mainFilesChangedPanel.setLayout(mainFilesChangedPanelLayout);
        mainFilesChangedPanelLayout.setHorizontalGroup(mainFilesChangedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 791, Short.MAX_VALUE).addGroup(mainFilesChangedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyFilesChangedPanel, -1, 791, Short.MAX_VALUE)));
        mainFilesChangedPanelLayout.setVerticalGroup(mainFilesChangedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 14, Short.MAX_VALUE).addGroup(mainFilesChangedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyFilesChangedPanel, -1, -1, Short.MAX_VALUE)));
        GroupLayout dummyCommitsPanelLayout = new GroupLayout(this.dummyCommitsPanel);
        this.dummyCommitsPanel.setLayout(dummyCommitsPanelLayout);
        dummyCommitsPanelLayout.setHorizontalGroup(dummyCommitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        dummyCommitsPanelLayout.setVerticalGroup(dummyCommitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
        GroupLayout mainCommitsPanelLayout = new GroupLayout(this.mainCommitsPanel);
        this.mainCommitsPanel.setLayout(mainCommitsPanelLayout);
        mainCommitsPanelLayout.setHorizontalGroup(mainCommitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyCommitsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        mainCommitsPanelLayout.setVerticalGroup(mainCommitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dummyCommitsPanel, -1, -1, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.headerSubmitButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerSubmitButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerNameLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerErrorLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerErrorLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerCreatedLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerCreatedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerCreatedDateLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerCreatedDateLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerUpdatedLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerUpdatedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerUpdatedDateLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerUpdatedDateLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerCreatedByLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerCreatedByLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerCreatedByUserLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerCreatedByUserLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerStatusLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerStatusLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.headerShowInBrowserLinkButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerShowInBrowserLinkButton.text"));
        this.headerShowInBrowserLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.headerShowInBrowserLinkButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        Mnemonics.setLocalizedText((AbstractButton)this.refreshLinkButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.refreshLinkButton.text"));
        this.refreshLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.refreshLinkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.newLabelButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.newLabelButton.text"));
        this.newLabelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.newLabelButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.newMilestoneButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.newMilestoneButton.text"));
        this.newMilestoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.newMilestoneButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.headerPrBaseHeadLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.headerPrBaseHeadLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeToPullRequestButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.changeToPullRequestButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newPullRequestToggleButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.newPullRequestToggleButton.text"));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addComponent(this.headerErrorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.newPullRequestToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeToPullRequestButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newMilestoneButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newLabelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerSubmitButton)).addGroup(headerPanelLayout.createSequentialGroup().addComponent(this.headerNameLabel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent((Component)this.refreshLinkButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 6, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.headerShowInBrowserLinkButton, -2, -1, -2)).addGroup(headerPanelLayout.createSequentialGroup().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addComponent(this.headerStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerCreatedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerCreatedDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.headerUpdatedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerUpdatedDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.headerCreatedByLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerCreatedByUserLabel)).addComponent(this.headerPrBaseHeadLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -2, 19, -2).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.headerShowInBrowserLinkButton, -2, -1, -2).addComponent((Component)this.refreshLinkButton, -2, -1, -2)).addComponent(this.headerNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerCreatedLabel).addComponent(this.headerCreatedDateLabel).addComponent(this.headerUpdatedLabel).addComponent(this.headerUpdatedDateLabel).addComponent(this.headerCreatedByLabel).addComponent(this.headerCreatedByUserLabel).addComponent(this.headerStatusLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerPrBaseHeadLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerSubmitButton).addComponent(this.headerErrorLabel).addComponent(this.newLabelButton).addComponent(this.newMilestoneButton).addComponent(this.changeToPullRequestButton).addComponent(this.newPullRequestToggleButton))));
        this.mainPanel.setAutoscrolls(true);
        Mnemonics.setLocalizedText((JLabel)this.assigneeLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.assigneeLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.titleTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.milestoneLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.milestoneLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.descriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.titleLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelsLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.labelsLabel.text"));
        this.labelsScrollPane.setViewportView(this.labelsList);
        Mnemonics.setLocalizedText((JLabel)this.newCommentLabel, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.newCommentLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newCommentButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.newCommentButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newCommentCloseReopenIssueButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.newCommentCloseReopenIssueButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.assignYourselfLinkButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.assignYourselfLinkButton.text"));
        this.assignYourselfLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.assignYourselfLinkButtonActionPerformed(evt);
            }
        });
        this.commentsCollapsibleSectionPanel.setContent((JComponent)this.mainCommentsPanel);
        this.commentsCollapsibleSectionPanel.setLabel(NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.commentsCollapsibleSectionPanel.label"));
        this.insertTemplateButton.setIcon(new ImageIcon("/home/junichi11/NetBeansProjects/netbeans-github-issues/src/main/resources/com/junichi11/netbeans/modules/github/issues/resources/template_16.png"));
        Mnemonics.setLocalizedText((AbstractButton)this.insertTemplateButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.insertTemplateButton.text"));
        this.insertTemplateButton.setToolTipText(NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.insertTemplateButton.toolTipText"));
        this.insertTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.insertTemplateButtonActionPerformed(evt);
            }
        });
        this.manageTemplatesButton.setIcon(new ImageIcon("/home/junichi11/NetBeansProjects/netbeans-github-issues/src/main/resources/com/junichi11/netbeans/modules/github/issues/resources/template_settings_16.png"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageTemplatesButton, (String)NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.manageTemplatesButton.text"));
        this.manageTemplatesButton.setToolTipText(NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.manageTemplatesButton.toolTipText"));
        this.manageTemplatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubIssuePanel.this.manageTemplatesButtonActionPerformed(evt);
            }
        });
        this.filesChangedcollapsibleSectionPanel.setContent((JComponent)this.mainFilesChangedPanel);
        this.filesChangedcollapsibleSectionPanel.setExpanded(false);
        this.filesChangedcollapsibleSectionPanel.setLabel(NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.filesChangedcollapsibleSectionPanel.label"));
        this.filesChangedcollapsibleSectionPanel.setMaximumSize(new Dimension(800, 31));
        this.commitsCollapsibleSectionPanel.setContent((JComponent)this.mainCommitsPanel);
        this.commitsCollapsibleSectionPanel.setExpanded(false);
        this.commitsCollapsibleSectionPanel.setLabel(NbBundle.getMessage(GitHubIssuePanel.class, (String)"GitHubIssuePanel.commitsCollapsibleSectionPanel.label"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attributesViewPanel, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel).addComponent(this.titleLabel).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.insertTemplateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageTemplatesButton))).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTabbedPanel, -1, -1, Short.MAX_VALUE).addComponent(this.titleTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelsLabel).addComponent(this.labelsScrollPane).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.assigneeLabel).addGap(19, 19, 19).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.assignYourselfLinkButton, -2, -1, -2).addComponent(this.assigneeComboBox, -2, 173, -2))).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.milestoneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.milestoneComboBox, -2, 173, -2)))).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.newCommentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newCommentTabbedPanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.newCommentCloseReopenIssueButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newCommentButton)).addComponent((Component)this.commentsCollapsibleSectionPanel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.filesChangedcollapsibleSectionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mergePanel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.commitsCollapsibleSectionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleTextField, -2, -1, -2).addComponent(this.assigneeComboBox, -2, -1, -2).addComponent(this.assigneeLabel).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addComponent((Component)this.assignYourselfLinkButton, -2, -1, -2).addGap(10, 10, 10).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.milestoneLabel).addComponent(this.milestoneComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelsScrollPane)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.insertTemplateButton).addComponent(this.manageTemplatesButton)).addGap(237, 237, 237)).addComponent(this.descriptionTabbedPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributesViewPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.commitsCollapsibleSectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.filesChangedcollapsibleSectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.commentsCollapsibleSectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mergePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newCommentLabel).addComponent(this.newCommentTabbedPanel, -2, 232, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newCommentButton).addComponent(this.newCommentCloseReopenIssueButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.mainScrollPane.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mainScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainScrollPane)));
    }

    private void headerShowInBrowserLinkButtonActionPerformed(ActionEvent evt) {
        RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                GitHubIssueSupport.showInBrowser(GitHubIssuePanel.this.gitHubIssue);
            }
        });
    }

    private void refreshLinkButtonActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void newLabelButtonActionPerformed(ActionEvent evt) {
        assert (this.gitHubIssue != null);
        Enumeration<Label> elements = this.labelsListModel.elements();
        Label label = LabelPanel.showDialog(Collections.list(elements));
        if (label != null) {
            GitHubRepository repository = this.getRepository();
            if (repository == null) {
                return;
            }
            Label newLable = repository.addLabel(label);
            if (newLable == null) {
                UiUtils.showErrorDialog(Bundle.GitHubIssuePanel_message_addLabel_error());
                return;
            }
            GitHubCache cache = GitHubCache.create(repository);
            this.updateLables(cache, true);
            Issue issue = this.getIssue().getIssue();
            if (issue != null) {
                this.setLabelsSelected(issue.getLabels());
            }
        }
    }

    private void newMilestoneButtonActionPerformed(ActionEvent evt) {
        assert (this.gitHubIssue != null);
        GitHubRepository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        Milestone milestone = MilestonePanel.showDialog(repository.getMilestones("all", false));
        if (milestone != null) {
            Milestone newMilestone = repository.addMilestone(milestone);
            if (newMilestone == null) {
                UiUtils.showErrorDialog(Bundle.GitHubIssuePanel_message_addMilestone_error());
                return;
            }
            GitHubCache cache = GitHubCache.create(repository);
            this.updateMilestones(cache, true);
            Issue issue = this.getIssue().getIssue();
            if (issue != null) {
                this.setMilestoneSelected(issue.getMilestone());
            }
        }
    }

    private void assignYourselfLinkButtonActionPerformed(ActionEvent evt) {
        GitHubRepository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        GitHubCache cache = GitHubCache.create(repository);
        User myself = cache.getMySelf();
        if (myself == null) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get myself.", repository.getFullName());
            return;
        }
        this.setAssigneeSelected(myself);
    }

    private void insertTemplateButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        String[] templateNames = GitHubIssuesConfig.getInstance().getTemplateNames();
        InsertTemplatePanel insertTemplatePanel = new InsertTemplatePanel();
        insertTemplatePanel.setTemplates(templateNames);
        NotifyDescriptor.Confirmation message = new NotifyDescriptor.Confirmation((Object)insertTemplatePanel, Bundle.GitHubIssuePanel_insert_template_title(), 2, -1);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == NotifyDescriptor.OK_OPTION) {
            String selectedTemplateName = insertTemplatePanel.getSelectedTemplateName();
            String template = GitHubIssuesConfig.getInstance().getTemplate(selectedTemplateName);
            if (template == null || template.isEmpty()) {
                return;
            }
            this.descriptionTabbedPanel.setText(this.descriptionTabbedPanel.getText() + template);
        }
    }

    private void manageTemplatesButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        ManageTemplatesPanel manageTemplatesPanel = new ManageTemplatesPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)manageTemplatesPanel, Bundle.GitHubIssuePanel_manage_templates_title(), true, null, null, 1, null, null);
        descriptor.setOptions((Object[])new String[]{TEMPLATES_ADD_OPTION, TEMPLATES_EDIT_OPTION, TEMPLATES_DUPLICATE_OPTION, TEMPLATES_REMOVE_OPTION, TEMPLATES_CLOSE_OPTION});
        descriptor.setClosingOptions((Object[])new String[]{TEMPLATES_CLOSE_OPTION});
        descriptor.setButtonListener((ActionListener)new ManageTemplateButtonListener(descriptor, manageTemplatesPanel));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
    }

    public void refresh() {
        RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (GitHubIssuePanel.this.isNew()) {
                    return;
                }
                GitHubIssuePanel.this.gitHubIssue.refreshIssue();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GitHubIssuePanel.this.update();
                    }
                });
            }
        });
    }

    private static class TemplatePanelChangeListener
    implements ChangeListener {
        private final TemplatePanel templatePanel;
        private final NotifyDescriptor.Confirmation notify;
        private final List<String> existingNames;

        public TemplatePanelChangeListener(TemplatePanel templatePanel, NotifyDescriptor.Confirmation notify, List<String> existingNames) {
            this.templatePanel = templatePanel;
            this.notify = notify;
            this.existingNames = existingNames;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            String templateName = this.templatePanel.getTemplateName();
            if (templateName == null || templateName.isEmpty()) {
                this.notify.setValid(false);
                this.templatePanel.setErrorMessage(Bundle.TemplatePanelChangeListener_invalid_empty());
                return;
            }
            if (this.existingNames.contains(templateName)) {
                this.notify.setValid(false);
                this.templatePanel.setErrorMessage(Bundle.TemplatePanelChangeListener_invalid_existing());
                return;
            }
            this.notify.setValid(true);
            this.templatePanel.setErrorMessage(" ");
        }
    }

    private static class ManageTemplateButtonListener
    implements ActionListener {
        private final DialogDescriptor descriptor;
        private final ManageTemplatesPanel manageTemplatesPanel;

        public ManageTemplateButtonListener(DialogDescriptor descriptor, ManageTemplatesPanel manageTemplatesPanel) {
            this.descriptor = descriptor;
            this.manageTemplatesPanel = manageTemplatesPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = this.descriptor.getValue();
            if (value == TEMPLATES_ADD_OPTION) {
                this.add();
            } else if (value == TEMPLATES_EDIT_OPTION) {
                this.edit();
            } else if (value == TEMPLATES_DUPLICATE_OPTION) {
                this.duplicate();
            } else if (value == TEMPLATES_REMOVE_OPTION) {
                this.remove();
            }
        }

        private void add() {
            this.showDialog(TEMPLATES_ADD_OPTION, Bundle.ManageTemplateButtonListener_add_title());
        }

        private void edit() {
            this.showDialog(TEMPLATES_EDIT_OPTION, Bundle.ManageTemplateButtonListener_edit_title());
        }

        private void duplicate() {
            this.showDialog(TEMPLATES_DUPLICATE_OPTION, Bundle.ManageTemplateButtonListener_duplicate_title());
        }

        private void remove() {
            String selectedTemplateName = this.manageTemplatesPanel.getSelectedTemplateName();
            if (selectedTemplateName == null || selectedTemplateName.isEmpty()) {
                return;
            }
            if (UiUtils.showQuestionDialog(Bundle.ManageTemplateButtonListener_remove_message(selectedTemplateName))) {
                GitHubIssuesConfig.getInstance().removeTemplate(selectedTemplateName);
                this.manageTemplatesPanel.resetTemplateNameList();
            }
        }

        private void showDialog(String option, String title) {
            String templateName;
            if (!(option.equals(TEMPLATES_ADD_OPTION) || option.equals(TEMPLATES_EDIT_OPTION) || option.equals(TEMPLATES_DUPLICATE_OPTION))) {
                return;
            }
            TemplatePanel templatePanel = new TemplatePanel();
            String selectedTemplateName = this.manageTemplatesPanel.getSelectedTemplateName();
            if (!option.equals(TEMPLATES_ADD_OPTION)) {
                if (selectedTemplateName == null || selectedTemplateName.isEmpty()) {
                    return;
                }
                templatePanel.setTemplateNameEditable(!option.equals(TEMPLATES_EDIT_OPTION));
                templatePanel.setTemplateName(selectedTemplateName);
                templatePanel.setTemplate(GitHubIssuesConfig.getInstance().getTemplate(selectedTemplateName));
            }
            NotifyDescriptor.Confirmation notify = new NotifyDescriptor.Confirmation((Object)templatePanel, title, 2, -1);
            TemplatePanelChangeListener listener = null;
            if (option.equals(TEMPLATES_ADD_OPTION) || option.equals(TEMPLATES_DUPLICATE_OPTION)) {
                ArrayList<String> existingNames = new ArrayList<String>(Arrays.asList(GitHubIssuesConfig.getInstance().getTemplateNames()));
                listener = new TemplatePanelChangeListener(templatePanel, notify, existingNames);
                templatePanel.addChangeListener(listener);
                templatePanel.fireChange();
            }
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)notify) == NotifyDescriptor.OK_OPTION && (templateName = templatePanel.getTemplateName()) != null && !templateName.isEmpty()) {
                String template = templatePanel.getTemplate();
                GitHubIssuesConfig.getInstance().setTemplate(templateName, template);
                if (option.equals(TEMPLATES_EDIT_OPTION)) {
                    this.manageTemplatesPanel.setSelectedTemplateName(selectedTemplateName);
                } else {
                    this.manageTemplatesPanel.resetTemplateNameList();
                }
            }
            if (listener != null) {
                templatePanel.removeChangeListener(listener);
            }
        }
    }

    private class MergePropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("github.issues.confirm.merge")) {
                RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        final MergeStatus mergeStatus = GitHubIssuePanel.this.getRepository().merge(GitHubIssuePanel.this.getIssue().getIssue().getNumber(), GitHubIssuePanel.this.mergePanel.getCommitMessage());
                        if (mergeStatus != null && mergeStatus.isMerged()) {
                            GitHubIssuePanel.this.refresh();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UiUtils.showPlainDialog(mergeStatus.getMessage());
                            }
                        });
                    }
                });
            }
        }
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            GitHubIssuePanel.this.fireChange();
        }
    }
}

