/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.issue.ui.Bundle;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.egit.github.core.Label;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class LabelPanel
extends JPanel {
    private static final long serialVersionUID = -9122329677222779787L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String errorMessage;
    private final List<Label> filter;
    private JLabel colorLabel;
    private JTextField colorTextField;
    private JLabel errorLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton selectColorButton;

    public LabelPanel(List<Label> filter) {
        this.filter = filter == null ? Collections.emptyList() : filter;
        this.initComponents();
        DocumentListenerImpl documentListener = new DocumentListenerImpl();
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        this.colorTextField.getDocument().addDocumentListener(documentListener);
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.setError("");
    }

    @CheckForNull
    public static Label showDialog(List<Label> filter) {
        final LabelPanel panel = new LabelPanel(filter);
        final DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LabelPanel_title(), true, 2, null, null);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                descriptor.setValid(panel.getErrorMessage() == null);
                panel.setError(panel.getErrorMessage());
            }
        };
        panel.addChangeListener(changeListener);
        panel.fireChange();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        panel.removeChangeListener(changeListener);
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return new Label().setName(panel.getLabelName()).setColor(panel.getLabelColor());
        }
        return null;
    }

    public String getLabelName() {
        return this.nameTextField.getText().trim();
    }

    public String getLabelColor() {
        return this.colorTextField.getText();
    }

    public final void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.isEmpty()) {
            this.errorLabel.setText("");
            this.errorLabel.setIcon(null);
            return;
        }
        this.errorLabel.setText(errorMessage);
        this.errorLabel.setIcon(GitHubIcons.ERROR_ICON_16);
    }

    void fireChange() {
        this.validateInputValues();
        this.changeSupport.fireChange();
    }

    void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void validateInputValues() {
        String labelName = this.getLabelName();
        if (labelName.isEmpty()) {
            this.errorMessage = Bundle.LabelPanel_validate_name_empty();
            return;
        }
        for (Label label : this.filter) {
            if (label == null || !label.getName().equals(labelName)) continue;
            this.errorMessage = Bundle.LabelPanel_validate_name_alreadyExists(labelName);
            return;
        }
        String labelColor = this.getLabelColor();
        if (labelColor.isEmpty()) {
            this.errorMessage = Bundle.LabelPanel_validate_color_empty();
            return;
        }
        this.errorMessage = null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void initComponents() {
        this.selectColorButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.colorLabel = new JLabel();
        this.colorTextField = new JTextField();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.selectColorButton, (String)NbBundle.getMessage(LabelPanel.class, (String)"LabelPanel.selectColorButton.text"));
        this.selectColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelPanel.this.selectColorButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(LabelPanel.class, (String)"LabelPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(LabelPanel.class, (String)"LabelPanel.nameTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.colorLabel, (String)NbBundle.getMessage(LabelPanel.class, (String)"LabelPanel.colorLabel.text"));
        this.colorTextField.setEditable(false);
        this.colorTextField.setText(NbBundle.getMessage(LabelPanel.class, (String)"LabelPanel.colorTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(LabelPanel.class, (String)"LabelPanel.errorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.colorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.colorTextField, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectColorButton)).addComponent(this.nameTextField))).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectColorButton).addComponent(this.colorTextField, -2, -1, -2).addComponent(this.colorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void selectColorButtonActionPerformed(ActionEvent evt) {
        Color color = JColorChooser.showDialog(null, Bundle.LabelPanel_colorChooser_title(), null);
        if (color != null) {
            this.colorTextField.setText(Integer.toHexString(color.getRGB()).substring(2));
        }
    }

    private class DocumentListenerImpl
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            LabelPanel.this.fireChange();
        }
    }
}

