/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIssuesConfig;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManageTemplatesPanel
extends JPanel {
    private static final long serialVersionUID = 7015367673609592404L;
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private JEditorPane templateEditorPane;
    private JList<String> templateNameList;
    private JScrollPane templateNameScrollPane;
    private JScrollPane templateScrollPane;

    public ManageTemplatesPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.resetTemplateNameList();
        this.templateNameList.setModel(this.listModel);
        this.templateNameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectedValue = (String)ManageTemplatesPanel.this.templateNameList.getSelectedValue();
                if (selectedValue != null) {
                    ManageTemplatesPanel.this.setTemplate(selectedValue);
                }
            }
        });
    }

    public void resetTemplateNameList() {
        String[] templateNames;
        this.listModel.clear();
        this.templateEditorPane.setText("");
        GitHubIssuesConfig config = GitHubIssuesConfig.getInstance();
        for (String templateName : templateNames = config.getTemplateNames()) {
            this.listModel.addElement(templateName);
        }
    }

    public String getSelectedTemplateName() {
        return this.templateNameList.getSelectedValue();
    }

    public void setSelectedTemplateName(String name) {
        this.templateNameList.setSelectedValue(name, true);
        this.setTemplate(name);
    }

    private void setTemplate(String templateName) {
        String template = GitHubIssuesConfig.getInstance().getTemplate(templateName);
        this.templateEditorPane.setText(template);
    }

    private void initComponents() {
        this.templateScrollPane = new JScrollPane();
        this.templateEditorPane = new JEditorPane();
        this.templateNameScrollPane = new JScrollPane();
        this.templateNameList = new JList();
        this.templateEditorPane.setEditable(false);
        this.templateScrollPane.setViewportView(this.templateEditorPane);
        this.templateNameScrollPane.setViewportView(this.templateNameList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.templateNameScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.templateScrollPane, -1, 400, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateScrollPane).addComponent(this.templateNameScrollPane, -1, 276, Short.MAX_VALUE)).addContainerGap()));
    }
}

