/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class MergePanel
extends JPanel {
    public static final String PROP_MERGE_CHANGED = "github.issues.confirm.merge";
    private static final long serialVersionUID = 4232217025134323257L;
    private JButton cancelButton;
    private JScrollPane commitMessageScrollPane;
    private JTextArea commitMessageTextArea;
    private JButton confirmMergeButton;
    private JButton mergePullRequestButton;

    public MergePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.mergePullRequestButton.setIcon(GitHubIcons.GIT_MERGE_ICON_16);
        this.mergePullRequestButton.setContentAreaFilled(false);
        this.mergePullRequestButton.setForeground(Color.WHITE);
        this.mergePullRequestButton.setBackground(GitHubIssues.GREEN_COLOR);
        this.mergePullRequestButton.setOpaque(true);
        this.confirmMergeButton.setIcon(GitHubIcons.GIT_MERGE_ICON_16);
        this.confirmMergeButton.setContentAreaFilled(false);
        this.confirmMergeButton.setBackground(GitHubIssues.GREEN_COLOR);
        this.confirmMergeButton.setForeground(Color.white);
        this.confirmMergeButton.setOpaque(true);
        this.commitMessageScrollPane.setVisible(false);
        this.commitMessageTextArea.setVisible(false);
        this.confirmMergeButton.setVisible(false);
        this.cancelButton.setVisible(false);
    }

    public void setMergeButtonEnabled(boolean isEnabled) {
        this.mergePullRequestButton.setEnabled(isEnabled);
    }

    public void toggleCommentVisible() {
        boolean toggle = this.mergePullRequestButton.isVisible();
        this.mergePullRequestButton.setVisible(!toggle);
        this.commitMessageScrollPane.setVisible(toggle);
        this.commitMessageTextArea.setVisible(toggle);
        this.confirmMergeButton.setVisible(toggle);
        this.cancelButton.setVisible(toggle);
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessageTextArea.setText(commitMessage);
    }

    public String getCommitMessage() {
        return this.commitMessageTextArea.getText();
    }

    private void initComponents() {
        this.mergePullRequestButton = new JButton();
        this.commitMessageScrollPane = new JScrollPane();
        this.commitMessageTextArea = new JTextArea();
        this.confirmMergeButton = new JButton();
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.mergePullRequestButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.mergePullRequestButton.text"));
        this.mergePullRequestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.mergePullRequestButtonActionPerformed(evt);
            }
        });
        this.commitMessageTextArea.setColumns(20);
        this.commitMessageTextArea.setRows(5);
        this.commitMessageScrollPane.setViewportView(this.commitMessageTextArea);
        Mnemonics.setLocalizedText((AbstractButton)this.confirmMergeButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.confirmMergeButton.text"));
        this.confirmMergeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.confirmMergeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(MergePanel.class, (String)"MergePanel.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commitMessageScrollPane, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mergePullRequestButton, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.confirmMergeButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mergePullRequestButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commitMessageScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confirmMergeButton, -2, -1, -2).addComponent(this.cancelButton, -2, -1, -2))));
    }

    private void confirmMergeButtonActionPerformed(ActionEvent evt) {
        this.firePropertyChange(PROP_MERGE_CHANGED, null, null);
        this.toggleCommentVisible();
    }

    private void mergePullRequestButtonActionPerformed(ActionEvent evt) {
        this.toggleCommentVisible();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.toggleCommentVisible();
    }

    private static class RoundedBorder
    implements Border {
        private final int radius;

        RoundedBorder(int radius) {
            this.radius = radius;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.radius + 1, this.radius + 1, this.radius + 2, this.radius);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        }
    }
}

