/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.issue.ui.Bundle;
import java.awt.Component;
import java.awt.Dialog;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.egit.github.core.Milestone;
import org.jdesktop.swingx.JXDatePicker;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class MilestonePanel
extends JPanel {
    private static final long serialVersionUID = -4759519190789532723L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String errorMessage;
    private final List<Milestone> filter;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JXDatePicker dueDateDatePicker;
    private JLabel dueDateLabel;
    private JLabel errorLabel;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public MilestonePanel(List<Milestone> filter) {
        this.filter = filter == null ? Collections.emptyList() : filter;
        this.initComponents();
        DocumentListenerImpl documentListener = new DocumentListenerImpl();
        this.titleTextField.getDocument().addDocumentListener(documentListener);
        this.dueDateDatePicker.setFormats(new DateFormat[]{new SimpleDateFormat("yyyy/MM/dd")});
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.setError("");
    }

    @CheckForNull
    public static Milestone showDialog(List<Milestone> filter) {
        final MilestonePanel panel = new MilestonePanel(filter);
        final DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.MilestonePanel_title(), true, 2, null, null);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                descriptor.setValid(panel.getErrorMessage() == null);
                panel.setError(panel.getErrorMessage());
            }
        };
        panel.addChangeListener(changeListener);
        panel.fireChange();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        panel.removeChangeListener(changeListener);
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Date dueDate;
            Milestone milestone = new Milestone().setTitle(panel.getTitle()).setState("open");
            String description = panel.getDescription();
            if (!description.isEmpty()) {
                milestone = milestone.setDescription(description);
            }
            if ((dueDate = panel.getDueDate()) != null) {
                milestone = milestone.setDueOn(dueDate);
            }
            return milestone;
        }
        return null;
    }

    public String getTitle() {
        return this.titleTextField.getText().trim();
    }

    public String getDescription() {
        return this.descriptionTextArea.getText();
    }

    public Date getDueDate() {
        return this.dueDateDatePicker.getDate();
    }

    public final void setError(String errorMessage) {
        if (errorMessage == null || errorMessage.isEmpty()) {
            this.errorLabel.setText("");
            this.errorLabel.setIcon(null);
            return;
        }
        this.errorLabel.setText(errorMessage);
        this.errorLabel.setIcon(GitHubIcons.ERROR_ICON_16);
    }

    void fireChange() {
        this.validateInputValues();
        this.changeSupport.fireChange();
    }

    void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void validateInputValues() {
        String title = this.getTitle();
        if (title.isEmpty()) {
            this.errorMessage = Bundle.MilestonePanel_validate_title_empty();
            return;
        }
        for (Milestone milestone : this.filter) {
            if (milestone == null || !milestone.getTitle().equals(title)) continue;
            this.errorMessage = Bundle.MilestonePanel_validate_name_alreadyExists(title);
            return;
        }
        this.errorMessage = null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.dueDateDatePicker = new JXDatePicker();
        this.dueDateLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(MilestonePanel.class, (String)"MilestonePanel.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(MilestonePanel.class, (String)"MilestonePanel.titleTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(MilestonePanel.class, (String)"MilestonePanel.descriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.dueDateLabel, (String)NbBundle.getMessage(MilestonePanel.class, (String)"MilestonePanel.dueDateLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(MilestonePanel.class, (String)"MilestonePanel.errorLabel.text"));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setRows(5);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionScrollPane, -1, 400, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel).addComponent(this.titleLabel)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dueDateLabel).addComponent((Component)this.dueDateDatePicker, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.dueDateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleTextField, -2, -1, -2).addComponent((Component)this.dueDateDatePicker, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addContainerGap()));
    }

    private class DocumentListenerImpl
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            MilestonePanel.this.fireChange();
        }
    }
}

