/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class TemplatePanel
extends JPanel {
    private static final long serialVersionUID = 799388642653499961L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JEditorPane templateEditorPane;
    private JScrollPane templateScrollPane;

    public TemplatePanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.nameTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.setErrorMessage("");
    }

    public void setTemplateNameEditable(boolean isEditable) {
        this.nameTextField.setEditable(isEditable);
    }

    public void setTemplateName(String name) {
        this.nameTextField.setText(name);
    }

    public String getTemplateName() {
        return this.nameTextField.getText().trim();
    }

    public void setTemplate(String template) {
        this.templateEditorPane.setText(template);
    }

    public String getTemplate() {
        return this.templateEditorPane.getText();
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().isEmpty()) {
            errorMessage = "";
            this.errorLabel.setIcon(null);
        } else {
            this.errorLabel.setIcon(GitHubIcons.ERROR_ICON_16);
        }
        this.errorLabel.setText(errorMessage);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.templateScrollPane = new JScrollPane();
        this.templateEditorPane = new JEditorPane();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(TemplatePanel.class, (String)"TemplatePanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(TemplatePanel.class, (String)"TemplatePanel.nameTextField.text"));
        this.templateScrollPane.setViewportView(this.templateEditorPane);
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(TemplatePanel.class, (String)"TemplatePanel.errorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.templateScrollPane, -1, 376, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameTextField)).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.templateScrollPane, -1, 220, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel).addContainerGap()));
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            TemplatePanel.this.fireChange();
        }
    }
}

