/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.options;

import com.junichi11.netbeans.modules.github.issues.query.GitHubDefaultQueries;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class GitHubIssuesOptions {
    public static final String SUB_PATH = "Team/GitHubIssues";
    private static final String PREFERENCES_PATH = "github.issues";
    private static final String SHOW_PARENT_REPO = "show.parent.repo";
    private static final String INSERT_DEFAULT_TEMPLATE = "insert.default.template";
    private static final GitHubIssuesOptions INSTANCE = new GitHubIssuesOptions();

    private GitHubIssuesOptions() {
    }

    public static GitHubIssuesOptions getInstance() {
        return INSTANCE;
    }

    public void setOpenQuery(boolean isEnabled) {
        this.getPreferences().putBoolean(GitHubDefaultQueries.Type.OPEN.getOptionKey(), isEnabled);
    }

    public boolean isOpenQuery() {
        return this.isDefaultQuery(GitHubDefaultQueries.Type.OPEN);
    }

    public void setAssignedToMeQuery(boolean isEnabled) {
        this.getPreferences().putBoolean(GitHubDefaultQueries.Type.ASSIGNED_TO_ME.getOptionKey(), isEnabled);
    }

    public boolean isAssignedToMeQuery() {
        return this.isDefaultQuery(GitHubDefaultQueries.Type.ASSIGNED_TO_ME);
    }

    public void setCreatedByMeQuery(boolean isEnabled) {
        this.getPreferences().putBoolean(GitHubDefaultQueries.Type.CREATED_BY_ME.getOptionKey(), isEnabled);
    }

    public boolean isCreatedByMeQuery() {
        return this.isDefaultQuery(GitHubDefaultQueries.Type.CREATED_BY_ME);
    }

    private boolean isDefaultQuery(GitHubDefaultQueries.Type type) {
        boolean defaultValue = false;
        if (type == GitHubDefaultQueries.Type.OPEN) {
            defaultValue = true;
        }
        return this.getPreferences().getBoolean(type.getOptionKey(), defaultValue);
    }

    public Map<GitHubDefaultQueries.Type, Boolean> getDefaultQueryOptions() {
        HashMap<GitHubDefaultQueries.Type, Boolean> map = new HashMap<GitHubDefaultQueries.Type, Boolean>();
        for (GitHubDefaultQueries.Type type : GitHubDefaultQueries.Type.values()) {
            map.put(type, this.isDefaultQuery(type));
        }
        return map;
    }

    public boolean showParentRepository() {
        return this.getPreferences().getBoolean(SHOW_PARENT_REPO, false);
    }

    public void setShowParentRepository(boolean showParent) {
        this.getPreferences().putBoolean(SHOW_PARENT_REPO, showParent);
    }

    public boolean insertDefaultTemplate() {
        return this.getPreferences().getBoolean(INSERT_DEFAULT_TEMPLATE, false);
    }

    public void setInsertDefaultTemplate(boolean insert) {
        this.getPreferences().putBoolean(INSERT_DEFAULT_TEMPLATE, insert);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(GitHubIssuesOptions.class).node(PREFERENCES_PATH);
    }
}

