/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.query;

import com.junichi11.netbeans.modules.github.issues.query.GitHubAssignedToMeQuery;
import com.junichi11.netbeans.modules.github.issues.query.GitHubCreatedByMeQuery;
import com.junichi11.netbeans.modules.github.issues.query.GitHubDefaultQuery;
import com.junichi11.netbeans.modules.github.issues.query.GitHubOpenQuery;
import com.junichi11.netbeans.modules.github.issues.query.GitHubQuery;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;

public final class GitHubDefaultQueries {
    private static final Map<GitHubRepository, GitHubDefaultQueries> DEFAULT_QUERIES = Collections.synchronizedMap(new HashMap());
    private static final Logger LOGGER = Logger.getLogger(GitHubDefaultQueries.class.getName());
    private final Map<Type, GitHubQuery> defaultQueries = new HashMap<Type, GitHubQuery>();

    private GitHubDefaultQueries() {
    }

    private static GitHubDefaultQueries create(GitHubRepository repository) {
        GitHubDefaultQueries gitHubDefaultQueries = DEFAULT_QUERIES.get(repository);
        if (gitHubDefaultQueries == null) {
            gitHubDefaultQueries = new GitHubDefaultQueries();
            DEFAULT_QUERIES.put(repository, gitHubDefaultQueries);
        }
        return gitHubDefaultQueries;
    }

    public static GitHubQuery create(GitHubRepository repository, Type type) {
        GitHubDefaultQueries gitHubDefaultQueries = GitHubDefaultQueries.create(repository);
        return gitHubDefaultQueries.getQuery(repository, type);
    }

    public static boolean isDefaultQuery(GitHubQuery query) {
        return query instanceof GitHubDefaultQuery;
    }

    public static void remove(GitHubRepository repository) {
        GitHubDefaultQueries gitHubDefaultQueries = GitHubDefaultQueries.create(repository);
        if (gitHubDefaultQueries == null) {
            return;
        }
        gitHubDefaultQueries.clear();
        DEFAULT_QUERIES.remove(repository);
    }

    private GitHubQuery getQuery(@NonNull GitHubRepository repository, @NonNull Type type) {
        GitHubQuery query = this.defaultQueries.get((Object)type);
        if (query == null) {
            switch (type) {
                case OPEN: {
                    query = new GitHubOpenQuery(repository);
                    break;
                }
                case ASSIGNED_TO_ME: {
                    query = new GitHubAssignedToMeQuery(repository);
                    break;
                }
                case CREATED_BY_ME: {
                    query = new GitHubCreatedByMeQuery(repository);
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "The query type({0}) is not supported!", type.name());
                    return new GitHubDefaultQuery(repository){};
                }
            }
            this.defaultQueries.put(type, query);
        }
        return query;
    }

    private void clear() {
        this.defaultQueries.clear();
    }

    public static enum Type {
        OPEN("query.open"),
        ASSIGNED_TO_ME("query.assigned.to.me"),
        CREATED_BY_ME("query.created.by.me");

        private final String optionKey;

        private Type(String optionKey) {
            this.optionKey = optionKey;
        }

        public String getOptionKey() {
            return this.optionKey;
        }
    }
}

