/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.query;

import com.junichi11.netbeans.modules.github.issues.egit.SearchIssuesParams;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.query.GitHubQueryController;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.spi.QueryProvider;

public class GitHubQuery {
    private String name;
    private String queryParam;
    private GitHubRepository repository;
    private GitHubQueryController controller;
    private ColumnDescriptor[] columnDescriptors;
    private boolean isSaved;
    private QueryProvider.IssueContainer<GitHubIssue> issueContainer;
    private String keyword;
    private final Map<String, String> qParamsMap = new HashMap<String, String>();
    private final Map<String, String> paramsMap = new HashMap<String, String>();
    private SearchIssuesParams.State state;

    public GitHubQuery(GitHubRepository repository) {
        this(repository, null, null);
    }

    public GitHubQuery(GitHubRepository repository, String name, String queryParam) {
        this.name = name;
        this.repository = repository;
        this.queryParam = queryParam;
        if (queryParam != null) {
            this.isSaved = true;
        }
        this.parseParam();
    }

    public GitHubRepository getRepository() {
        return this.repository;
    }

    public void setDisplayName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.getDisplayName();
    }

    public String getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(SearchIssuesParams params) {
        if (params == null) {
            this.queryParam = null;
            return;
        }
        this.queryParam = params.getParameters(false);
        this.parseParam();
    }

    public Map<String, String> getParamsMap() {
        return new HashMap<String, String>(this.paramsMap);
    }

    public Map<String, String> getQParamsMap() {
        return new HashMap<String, String>(this.qParamsMap);
    }

    public void save() {
        this.repository.saveQuery(this);
    }

    public void setSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public GitHubQueryController getController() {
        if (this.controller == null) {
            this.controller = this.createController();
        }
        return this.controller;
    }

    private GitHubQueryController createController() {
        return new GitHubQueryController(this);
    }

    public boolean canRemove() {
        return true;
    }

    public void remove() {
        this.repository.removeQuery(this);
    }

    public boolean canRename() {
        return true;
    }

    public void rename(String string) {
    }

    public void setIssueContainer(QueryProvider.IssueContainer<GitHubIssue> issueContainer) {
        this.issueContainer = issueContainer;
    }

    public void refresh() {
        try {
            if (this.issueContainer != null) {
                this.issueContainer.refreshingStarted();
                this.issueContainer.clear();
                for (GitHubIssue issue : this.getIssues(true)) {
                    this.issueContainer.add((Object[])new GitHubIssue[]{issue});
                }
            }
        }
        finally {
            this.fireFinished();
        }
    }

    void fireFinished() {
        if (this.issueContainer != null) {
            this.issueContainer.refreshingFinished();
        }
    }

    public List<GitHubIssue> getIssues(boolean isRefresh) {
        Map<String, String> filter = this.getFilter();
        if (filter.isEmpty()) {
            if (StringUtils.isEmpty(this.queryParam)) {
                return Collections.emptyList();
            }
            return this.searchIssues(this.createSearchIssuesParams(), isRefresh);
        }
        return this.repository.getIssues(filter, isRefresh);
    }

    protected Map<String, String> getFilter() {
        return Collections.emptyMap();
    }

    public List<GitHubIssue> searchIssues(SearchIssuesParams params, boolean isRefresh) {
        return this.repository.searchIssues(params, isRefresh);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public SearchIssuesParams.State getState() {
        return this.state;
    }

    public String getParameter(QParam param) {
        if (param == null) {
            return null;
        }
        String value = this.qParamsMap.get(param.getKey());
        return value == null ? "" : value;
    }

    public String getParameter(Param param) {
        if (param == null) {
            return null;
        }
        String value = this.paramsMap.get(param.getValue());
        return value == null ? "" : value;
    }

    private SearchIssuesParams createSearchIssuesParams() {
        return new SearchIssuesParams().keyword(this.getParameter(QParam.KEYWORD)).milestone(this.getParameter(QParam.MILESTONE)).assignee(this.getParameter(QParam.ASSIGNEE)).author(this.getParameter(QParam.AUTHOR)).commenter(this.getParameter(QParam.COMMENTER)).mentions(this.getParameter(QParam.MENTIONS)).created(this.getParameter(QParam.CREATED)).updated(this.getParameter(QParam.UPDATED)).merged(this.getParameter(QParam.MERGED)).closed(this.getParameter(QParam.CLOSED)).involves(this.getParameter(QParam.INVOLVES)).language(this.getParameter(QParam.LANGUAGE)).state(SearchIssuesParams.State.valueOfString(this.getParameter(QParam.STATE))).type(SearchIssuesParams.Type.valueOfString(this.getParameter(QParam.TYPE))).in(this.getParameter(QParam.IN)).no(SearchIssuesParams.No.valueOfString(this.getParameter(QParam.NO))).is(SearchIssuesParams.Is.valueOfString(this.getParameter(QParam.IS_OPEN))).is(SearchIssuesParams.Is.valueOfString(this.getParameter(QParam.IS_MERGED))).is(SearchIssuesParams.Is.valueOfString(this.getParameter(QParam.IS_ISSUE))).comments(this.getParameter(QParam.COMMENTS)).labels(this.getParameter(QParam.LABELS)).sort(SearchIssuesParams.Sort.valueOfString(this.getParameter(Param.SORT))).order(SearchIssuesParams.Order.valueOfString(this.getParameter(Param.ORDER)));
    }

    private void clearParams() {
        this.qParamsMap.clear();
        this.paramsMap.clear();
    }

    private void parseParam() {
        this.clearParams();
        if (StringUtils.isEmpty(this.queryParam)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.queryParam, "&");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] split = token.split("=");
            if (split.length != 2) continue;
            String key = split[0];
            String value = split[1];
            this.paramsMap.put(key, value);
            switch (key) {
                case "q": {
                    this.parseQ(value);
                    break;
                }
                case "sort": {
                    break;
                }
                case "order": {
                    break;
                }
            }
        }
    }

    private void parseQ(String q) {
        if (StringUtils.isEmpty(q)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(q, "+");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] split = token.split(":");
            if (split.length == 1) {
                this.qParamsMap.put(QParam.KEYWORD.getKey(), token);
                continue;
            }
            if (split.length != 2) continue;
            String key = split[0];
            String value = split[1];
            if (key.equals("is")) {
                switch (value) {
                    case "merged": 
                    case "unmerged": {
                        this.qParamsMap.put(QParam.IS_MERGED.getKey(), value);
                        break;
                    }
                    case "issue": 
                    case "pr": {
                        this.qParamsMap.put(QParam.IS_ISSUE.getKey(), value);
                        break;
                    }
                    case "open": 
                    case "closed": {
                        this.qParamsMap.put(QParam.IS_OPEN.getKey(), value);
                        break;
                    }
                }
                continue;
            }
            if (key.equals("label")) {
                String labels = this.qParamsMap.get(QParam.LABELS.getKey());
                labels = !StringUtils.isEmpty(labels) ? String.format("%s,%s", labels, value) : value;
                this.qParamsMap.put(QParam.LABELS.getKey(), labels);
                continue;
            }
            this.qParamsMap.put(key, value);
        }
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        if (this.columnDescriptors == null) {
            this.columnDescriptors = GitHubIssue.getColumnDescriptors();
        }
        return this.columnDescriptors;
    }

    public static enum Param {
        SORT("sort"),
        ORDER("order");

        private final String value;

        private Param(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum QParam {
        KEYWORD("keyword", "keyword"),
        MILESTONE("milestone", "milestone"),
        TYPE("type", "type"),
        IN("in", "in"),
        AUTHOR("author", "author"),
        ASSIGNEE("assignee", "assignee"),
        MENTIONS("mentions", "mentions"),
        COMMENTER("commenter", "commenter"),
        INVOLVES("involves", "involves"),
        STATE("state", "state"),
        LABELS("labels", "labels"),
        NO("no", "no"),
        LANGUAGE("language", "language"),
        IS("is", "is"),
        IS_OPEN("isOpen", "is"),
        IS_MERGED("isMerged", "is"),
        IS_ISSUE("isIssue", "is"),
        CREATED("created", "created"),
        UPDATED("updated", "updated"),
        MERGED("merged", "merged"),
        CLOSED("closed", "closed"),
        COMMENTS("comments", "comments");

        private final String key;
        private final String value;

        private QParam(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

