/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.query;

import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import com.junichi11.netbeans.modules.github.issues.egit.SearchIssuesParams;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.query.Bundle;
import com.junichi11.netbeans.modules.github.issues.query.GitHubDefaultQuery;
import com.junichi11.netbeans.modules.github.issues.query.GitHubQuery;
import com.junichi11.netbeans.modules.github.issues.query.ui.GitHubQueryPanel;
import com.junichi11.netbeans.modules.github.issues.ui.IssueTableCellRenderer;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.ValidateUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.bugtracking.commons.SaveQueryPanel;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class GitHubQueryController
implements QueryController,
ActionListener,
ChangeListener {
    private GitHubQueryPanel panel;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final GitHubQuery query;
    private IssueTable issueTable;
    private String errorMessage;

    public GitHubQueryController(GitHubQuery query) {
        this.query = query;
    }

    public boolean providesMode(QueryController.QueryMode queryMode) {
        return !(this.query instanceof GitHubDefaultQuery);
    }

    public JComponent getComponent(QueryController.QueryMode queryMode) {
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void opened() {
    }

    public void closed() {
    }

    public boolean saveChanges(String string) {
        return false;
    }

    public boolean discardUnsavedChanges() {
        return false;
    }

    public boolean isChanged() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof IssueTable) {
            return;
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof IssueTable) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    void firePropertyChange() {
        this.propertyChangeSupport.firePropertyChange("bugtracking.query.changed", null, null);
    }

    private GitHubQueryPanel getPanel() {
        if (this.panel == null) {
            this.issueTable = new IssueTable(this.query.getRepository().getID(), this.query.getDisplayName(), (QueryController)this, this.query.getColumnDescriptors(), false);
            this.issueTable.setRenderer((TableCellRenderer)new IssueTableCellRenderer((QueryTableCellRenderer)this.issueTable.getRenderer()));
            this.issueTable.initColumns();
            this.panel = new GitHubQueryPanel(this.query, this.issueTable.getComponent());
            this.panel.addSaveAction(this);
            this.panel.addSearchAction(this);
            this.panel.addChangeListener(this);
        }
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final Object source = event.getSource();
        final GitHubQueryPanel p = this.getPanel();
        p.setButtonsEnabled(false);
        RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (p.isSave(source)) {
                                GitHubQueryController.this.save();
                            } else if (p.isSearch(source)) {
                                GitHubQueryController.this.search();
                            }
                        }
                        finally {
                            p.setButtonsEnabled(true);
                        }
                    }
                });
            }
        });
    }

    private void save() {
        SearchIssuesParams issuesParams = this.createSearchIssuesParams();
        if (issuesParams == null) {
            return;
        }
        if (!this.query.isSaved()) {
            SaveQueryPanel.QueryNameValidator validator = new SaveQueryPanel.QueryNameValidator(){

                public String isValid(String name) {
                    if (StringUtils.isEmpty(name)) {
                        return Bundle.GitHubQueryController_message_error_empty_name();
                    }
                    Collection<GitHubQuery> queries = GitHubQueryController.this.query.getRepository().getQueries();
                    for (GitHubQuery query : queries) {
                        if (!query.getDisplayName().equals(name)) continue;
                        return Bundle.GitHubQueryController_message_error_already_exists();
                    }
                    return null;
                }
            };
            String queryName = SaveQueryPanel.show((SaveQueryPanel.QueryNameValidator)validator, (HelpCtx)HelpCtx.DEFAULT_HELP);
            if (StringUtils.isEmpty(queryName)) {
                return;
            }
            this.query.setDisplayName(queryName);
        }
        this.query.setQueryParam(issuesParams);
        this.query.save();
        this.query.setSaved(true);
        this.getPanel().update();
        StatusDisplayer.getDefault().setStatusText(Bundle.GitHubQueryController_message_saved());
        this.query.refresh();
        this.firePropertyChange();
    }

    private void search() {
        this.issueTable.started();
        SearchIssuesParams params = this.createSearchIssuesParams();
        List<GitHubIssue> searchIssues = this.query.searchIssues(params, false);
        this.getPanel().setResultCounts(searchIssues.size());
        for (GitHubIssue searchIssue : searchIssues) {
            IssueNode issueNode = searchIssue.getIssueNode();
            this.issueTable.addNode(issueNode);
        }
    }

    private SearchIssuesParams createSearchIssuesParams() {
        GitHubQueryPanel p = this.getPanel();
        return new SearchIssuesParams().keyword(p.getKeyword()).milestone(p.getMilestone()).state(p.getState()).type(p.getType()).comments(p.getComments()).assignee(p.getAssignee()).author(p.getAuthor()).involves(p.getInvolves()).mentions(p.getMentions()).created(p.getCreated()).updated(p.getUpdated()).merged(p.getMerged()).closed(p.getClosed()).language(p.getLanguage()).labels(p.getLabels()).is(p.getIsOpen()).is(p.getIsMerged()).is(p.getIsIssue()).no(p.getNo()).in(p.getIn()).sort(p.getSort()).order(p.getOrder());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.validate();
    }

    private void validate() {
        this.getPanel().setButtonsEnabled(this.isValid());
        this.getPanel().setErrorMessage(this.errorMessage);
    }

    private boolean isValid() {
        GitHubQueryPanel p = this.getPanel();
        if (!ValidateUtils.isQueryDateFormat(p.getCreated())) {
            this.errorMessage = Bundle.GitHubQueryController_message_date_format_error(Bundle.GitHubQueryController_label_created());
            return false;
        }
        if (!ValidateUtils.isQueryDateFormat(p.getUpdated())) {
            this.errorMessage = Bundle.GitHubQueryController_message_date_format_error(Bundle.GitHubQueryController_label_updated());
            return false;
        }
        if (!ValidateUtils.isQueryDateFormat(p.getMerged())) {
            this.errorMessage = Bundle.GitHubQueryController_message_date_format_error(Bundle.GitHubQueryController_label_merged());
            return false;
        }
        if (!ValidateUtils.isQueryDateFormat(p.getClosed())) {
            this.errorMessage = Bundle.GitHubQueryController_message_date_format_error(Bundle.GitHubQueryController_label_closed());
            return false;
        }
        if (!ValidateUtils.isQueryCommentsFormat(p.getComments())) {
            this.errorMessage = Bundle.GitHubQueryController_message_comments_format_error();
            return false;
        }
        if (!ValidateUtils.isQueryInFormat(p.getIn())) {
            this.errorMessage = Bundle.GitHubQueryController_message_in_format_error();
            return false;
        }
        this.errorMessage = null;
        return true;
    }
}

