/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.query.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.egit.SearchIssuesParams;
import com.junichi11.netbeans.modules.github.issues.query.GitHubQuery;
import com.junichi11.netbeans.modules.github.issues.query.ui.Bundle;
import com.junichi11.netbeans.modules.github.issues.query.ui.GitHubQueryListCellRenderer;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.egit.github.core.Milestone;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class GitHubQueryPanel
extends JPanel {
    private static final long serialVersionUID = -5303088106606244893L;
    private final GitHubQuery query;
    private final DefaultComboBoxModel<SearchIssuesParams.State> stateComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.Type> typeComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.Is> isOpenComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.Is> isMergedComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.Is> isIssueComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.No> noComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.Sort> sortComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<SearchIssuesParams.Order> orderComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<Milestone> milestoneComboBoxModel = new DefaultComboBoxModel();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel assigneeLabel;
    private JTextField assigneeTextField;
    private JLabel authorLabel;
    private JTextField authorTextField;
    private JLabel closedLabel;
    private JTextField closedTextField;
    private JLabel commentsLabel;
    private JTextField commentsTextField;
    private JLabel createdLabel;
    private JTextField createdTextField;
    private JLabel headerErrorLabel;
    private JLabel headerNameLabel;
    private JPanel headerPanel;
    private JLabel inLabel;
    private JTextField inTextField;
    private JLabel involvesLabel;
    private JTextField involvesTextField;
    private JComboBox<SearchIssuesParams.Is> isIssueComboBox;
    private JLabel isLabel;
    private JComboBox<SearchIssuesParams.Is> isMergedComboBox;
    private JComboBox<SearchIssuesParams.Is> isOpenComboBox;
    private JLabel keywordLabel;
    private JTextField keywordTextField;
    private JLabel labelsLabel;
    private JTextField labelsTextField;
    private JLabel languageLabel;
    private JTextField languageTextField;
    private JPanel mainIssueTablePanel;
    private JLabel mentionsLabel;
    private JTextField mentionsTextField;
    private JLabel mergedLabel;
    private JTextField mergedTextField;
    private JComboBox<Milestone> milestoneComboBox;
    private JLabel milestoneLabel;
    private JComboBox<SearchIssuesParams.No> noComboBox;
    private JLabel noLabel;
    private JComboBox<SearchIssuesParams.Order> orderComboBox;
    private JLabel orderLabel;
    private JButton resetButton;
    private JLabel resultsLabel;
    private JButton saveButton;
    private JButton searchButton;
    private JComboBox<SearchIssuesParams.Sort> sortComboBox;
    private JLabel sortLabel;
    private JComboBox<SearchIssuesParams.State> stateComboBox;
    private JLabel stateLabel;
    private JComboBox<SearchIssuesParams.Type> typeComboBox;
    private JLabel typeLabel;
    private JLabel updatedLabel;
    private JTextField updatedTextField;

    public GitHubQueryPanel(GitHubQuery query, JComponent table) {
        assert (query != null);
        this.query = query;
        this.initComponents();
        this.headerErrorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.setErrorMessage("");
        Font font = this.headerErrorLabel.getFont();
        this.headerNameLabel.setFont(font.deriveFont((float)((double)font.getSize() * 1.5)));
        this.headerNameLabel.setIcon(GitHubIcons.GITHUB_ICON_32);
        this.initComboBox();
        this.addDocumentListener();
        this.mainIssueTablePanel.add(table);
        this.resultsLabel.setText("");
        this.update();
    }

    private void initComboBox() {
        this.setComboBox(this.stateComboBox, this.stateComboBoxModel, (Object[])SearchIssuesParams.State.values());
        this.setComboBox(this.typeComboBox, this.typeComboBoxModel, (Object[])SearchIssuesParams.Type.values());
        this.setComboBox(this.isOpenComboBox, this.isOpenComboBoxModel, new Object[]{SearchIssuesParams.Is.OPEN, SearchIssuesParams.Is.CLOSED});
        this.setComboBox(this.isMergedComboBox, this.isMergedComboBoxModel, new Object[]{SearchIssuesParams.Is.MERGED, SearchIssuesParams.Is.UNMERGED});
        this.setComboBox(this.isIssueComboBox, this.isIssueComboBoxModel, new Object[]{SearchIssuesParams.Is.ISSUE, SearchIssuesParams.Is.PR});
        this.setComboBox(this.noComboBox, this.noComboBoxModel, (Object[])SearchIssuesParams.No.values());
        this.setComboBox(this.sortComboBox, this.sortComboBoxModel, (Object[])SearchIssuesParams.Sort.values());
        this.setComboBox(this.orderComboBox, this.orderComboBoxModel, (Object[])SearchIssuesParams.Order.values());
        GitHubRepository repository = this.query.getRepository();
        List<Milestone> milestones = repository.getMilestones("all", false);
        this.setComboBox(this.milestoneComboBox, this.milestoneComboBoxModel, milestones.toArray());
    }

    private void setComboBox(JComboBox comboBox, DefaultComboBoxModel model, Object[] values) {
        model.addElement(null);
        for (Object value : values) {
            model.addElement(value);
        }
        comboBox.setModel(model);
        comboBox.setRenderer(new GitHubQueryListCellRenderer(comboBox.getRenderer()));
    }

    private void addDocumentListener() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.createdTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.updatedTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.mergedTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.closedTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.commentsTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.inTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public final void update() {
        this.setHeaderName();
        if (this.query == null || !this.query.isSaved()) {
            return;
        }
        this.keywordTextField.setText(this.query.getParameter(GitHubQuery.QParam.KEYWORD));
        this.stateComboBox.setSelectedItem((Object)SearchIssuesParams.State.valueOfString(this.query.getParameter(GitHubQuery.QParam.STATE)));
        this.commentsTextField.setText(this.query.getParameter(GitHubQuery.QParam.COMMENTS));
        this.labelsTextField.setText(this.query.getParameter(GitHubQuery.QParam.LABELS));
        this.authorTextField.setText(this.query.getParameter(GitHubQuery.QParam.AUTHOR));
        this.mentionsTextField.setText(this.query.getParameter(GitHubQuery.QParam.MENTIONS));
        this.assigneeTextField.setText(this.query.getParameter(GitHubQuery.QParam.ASSIGNEE));
        this.involvesTextField.setText(this.query.getParameter(GitHubQuery.QParam.INVOLVES));
        this.languageTextField.setText(this.query.getParameter(GitHubQuery.QParam.LANGUAGE));
        this.createdTextField.setText(this.query.getParameter(GitHubQuery.QParam.CREATED));
        this.updatedTextField.setText(this.query.getParameter(GitHubQuery.QParam.UPDATED));
        this.closedTextField.setText(this.query.getParameter(GitHubQuery.QParam.CLOSED));
        this.mergedTextField.setText(this.query.getParameter(GitHubQuery.QParam.MERGED));
        this.inTextField.setText(this.query.getParameter(GitHubQuery.QParam.IN));
        this.noComboBox.setSelectedItem((Object)SearchIssuesParams.No.valueOfString(this.query.getParameter(GitHubQuery.QParam.NO)));
        this.isOpenComboBox.setSelectedItem((Object)SearchIssuesParams.Is.valueOfString(this.query.getParameter(GitHubQuery.QParam.IS_OPEN)));
        this.isMergedComboBox.setSelectedItem((Object)SearchIssuesParams.Is.valueOfString(this.query.getParameter(GitHubQuery.QParam.IS_MERGED)));
        this.isIssueComboBox.setSelectedItem((Object)SearchIssuesParams.Is.valueOfString(this.query.getParameter(GitHubQuery.QParam.IS_ISSUE)));
        this.sortComboBox.setSelectedItem((Object)SearchIssuesParams.Sort.valueOfString(this.query.getParameter(GitHubQuery.Param.SORT)));
        this.orderComboBox.setSelectedItem((Object)SearchIssuesParams.Order.valueOfString(this.query.getParameter(GitHubQuery.Param.ORDER)));
        String milestoneTitle = this.query.getParameter(GitHubQuery.QParam.MILESTONE);
        for (int i = 0; i < this.milestoneComboBox.getItemCount(); ++i) {
            Milestone milestone = this.milestoneComboBox.getItemAt(i);
            if (milestone == null || !milestone.getTitle().equals(milestoneTitle)) continue;
            this.milestoneComboBox.setSelectedIndex(i);
            break;
        }
    }

    public final void setErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.trim().isEmpty()) {
            errorMessage = "";
            this.headerErrorLabel.setIcon(null);
        } else {
            this.headerErrorLabel.setIcon(GitHubIcons.ERROR_ICON_16);
        }
        this.headerErrorLabel.setText(errorMessage);
    }

    public final void setResultCounts(int count) {
        if (count < 0) {
            this.resultsLabel.setText("");
            return;
        }
        switch (count) {
            case 0: {
                this.resultsLabel.setText(Bundle.GitHubQueryPanel_message_result_empty());
                break;
            }
            case 1: {
                this.resultsLabel.setText(Bundle.GitHubQueryPanel_message_result_issue());
                break;
            }
            default: {
                this.resultsLabel.setText(Bundle.GitHubQueryPanel_message_result_issues(count));
            }
        }
    }

    private void setHeaderName() {
        if (!this.query.isSaved()) {
            this.headerNameLabel.setText(Bundle.GitHubQueryPanel_new_query_displayName());
            return;
        }
        this.headerNameLabel.setText(this.query.getDisplayName());
    }

    public String getKeyword() {
        return this.keywordTextField.getText().trim();
    }

    public Milestone getMilestone() {
        return (Milestone)this.milestoneComboBox.getSelectedItem();
    }

    public SearchIssuesParams.State getState() {
        return (SearchIssuesParams.State)((Object)this.stateComboBox.getSelectedItem());
    }

    public String getComments() {
        return this.commentsTextField.getText().trim();
    }

    public String getLabels() {
        return this.labelsTextField.getText().trim();
    }

    public String getAuthor() {
        return this.authorTextField.getText().trim();
    }

    public String getMentions() {
        return this.mentionsTextField.getText().trim();
    }

    public String getAssignee() {
        return this.assigneeTextField.getText().trim();
    }

    public String getInvolves() {
        return this.involvesTextField.getText().trim();
    }

    public String getLanguage() {
        return this.languageTextField.getText().trim();
    }

    public String getCreated() {
        return this.createdTextField.getText().trim();
    }

    public String getUpdated() {
        return this.updatedTextField.getText().trim();
    }

    public String getMerged() {
        return this.mergedTextField.getText().trim();
    }

    public String getClosed() {
        return this.closedTextField.getText().trim();
    }

    public String getIn() {
        return this.inTextField.getText().replaceAll("\\s", "").trim();
    }

    public SearchIssuesParams.Type getType() {
        return (SearchIssuesParams.Type)((Object)this.typeComboBox.getSelectedItem());
    }

    public SearchIssuesParams.No getNo() {
        return (SearchIssuesParams.No)((Object)this.noComboBox.getSelectedItem());
    }

    public SearchIssuesParams.Is getIsOpen() {
        return (SearchIssuesParams.Is)((Object)this.isOpenComboBox.getSelectedItem());
    }

    public SearchIssuesParams.Is getIsMerged() {
        return (SearchIssuesParams.Is)((Object)this.isMergedComboBox.getSelectedItem());
    }

    public SearchIssuesParams.Is getIsIssue() {
        return (SearchIssuesParams.Is)((Object)this.isIssueComboBox.getSelectedItem());
    }

    public SearchIssuesParams.Sort getSort() {
        return (SearchIssuesParams.Sort)((Object)this.sortComboBox.getSelectedItem());
    }

    public SearchIssuesParams.Order getOrder() {
        return (SearchIssuesParams.Order)((Object)this.orderComboBox.getSelectedItem());
    }

    public boolean isSearch(Object source) {
        return source == this.searchButton;
    }

    public boolean isSave(Object source) {
        return source == this.saveButton;
    }

    public void addSaveAction(ActionListener listener) {
        this.saveButton.addActionListener(listener);
    }

    public void removeSaveAction(ActionListener listener) {
        this.saveButton.removeActionListener(listener);
    }

    public void addSearchAction(ActionListener listener) {
        this.searchButton.addActionListener(listener);
    }

    public void removeSearchAction(ActionListener listener) {
        this.searchButton.removeActionListener(listener);
    }

    public void setButtonsEnabled(boolean isEnabled) {
        this.searchButton.setEnabled(isEnabled);
        this.saveButton.setEnabled(isEnabled);
        this.resetButton.setEnabled(isEnabled);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateComboBox = new JComboBox();
        this.keywordLabel = new JLabel();
        this.keywordTextField = new JTextField();
        this.searchButton = new JButton();
        this.saveButton = new JButton();
        this.commentsLabel = new JLabel();
        this.commentsTextField = new JTextField();
        this.labelsLabel = new JLabel();
        this.labelsTextField = new JTextField();
        this.authorLabel = new JLabel();
        this.authorTextField = new JTextField();
        this.mentionsLabel = new JLabel();
        this.mentionsTextField = new JTextField();
        this.assigneeLabel = new JLabel();
        this.assigneeTextField = new JTextField();
        this.involvesLabel = new JLabel();
        this.involvesTextField = new JTextField();
        this.inLabel = new JLabel();
        this.inTextField = new JTextField();
        this.noLabel = new JLabel();
        this.isLabel = new JLabel();
        this.languageLabel = new JLabel();
        this.languageTextField = new JTextField();
        this.createdLabel = new JLabel();
        this.updatedLabel = new JLabel();
        this.mergedLabel = new JLabel();
        this.closedLabel = new JLabel();
        this.createdTextField = new JTextField();
        this.updatedTextField = new JTextField();
        this.mergedTextField = new JTextField();
        this.closedTextField = new JTextField();
        this.sortLabel = new JLabel();
        this.sortComboBox = new JComboBox();
        this.orderLabel = new JLabel();
        this.orderComboBox = new JComboBox();
        this.headerPanel = new JPanel();
        this.headerNameLabel = new JLabel();
        this.headerErrorLabel = new JLabel();
        this.resetButton = new JButton();
        this.mainIssueTablePanel = new JPanel();
        this.resultsLabel = new JLabel();
        this.isOpenComboBox = new JComboBox();
        this.isMergedComboBox = new JComboBox();
        this.isIssueComboBox = new JComboBox();
        this.noComboBox = new JComboBox();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.milestoneLabel = new JLabel();
        this.milestoneComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.stateLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.stateLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.keywordLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.keywordLabel.text"));
        this.keywordTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.keywordTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubQueryPanel.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.saveButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.commentsLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.commentsLabel.text"));
        this.commentsTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.commentsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelsLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.labelsLabel.text"));
        this.labelsTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.labelsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.authorLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.authorLabel.text"));
        this.authorTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.authorTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.mentionsLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.mentionsLabel.text"));
        this.mentionsTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.mentionsTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.assigneeLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.assigneeLabel.text"));
        this.assigneeTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.assigneeTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.involvesLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.involvesLabel.text"));
        this.involvesTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.involvesTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.inLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.inLabel.text"));
        this.inTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.inTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.noLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.noLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.isLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.isLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.languageLabel.text"));
        this.languageTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.languageTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.createdLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.createdLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.updatedLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.updatedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.mergedLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.mergedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.closedLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.closedLabel.text"));
        this.createdTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.createdTextField.text"));
        this.updatedTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.updatedTextField.text"));
        this.mergedTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.mergedTextField.text"));
        this.closedTextField.setText(NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.closedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.sortLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.sortLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.orderLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.orderLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerNameLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.headerNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.headerErrorLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.headerErrorLabel.text"));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerNameLabel).addComponent(this.headerErrorLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addComponent(this.headerErrorLabel).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubQueryPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.mainIssueTablePanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.resultsLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.resultsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.typeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.milestoneLabel, (String)NbBundle.getMessage(GitHubQueryPanel.class, (String)"GitHubQueryPanel.milestoneLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mentionsLabel).addComponent(this.assigneeLabel).addComponent(this.authorLabel).addComponent(this.involvesLabel).addComponent(this.labelsLabel).addComponent(this.languageLabel).addComponent(this.keywordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.authorTextField).addComponent(this.mentionsTextField).addComponent(this.assigneeTextField).addComponent(this.involvesTextField).addComponent(this.labelsTextField).addComponent(this.languageTextField)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createdLabel).addComponent(this.updatedLabel).addComponent(this.mergedLabel).addComponent(this.closedLabel).addComponent(this.inLabel).addComponent(this.commentsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createdTextField).addComponent(this.updatedTextField).addComponent(this.mergedTextField).addComponent(this.closedTextField).addComponent(this.inTextField).addComponent(this.commentsTextField))).addGroup(layout.createSequentialGroup().addComponent(this.keywordTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.milestoneLabel).addGap(6, 6, 6).addComponent(this.milestoneComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stateComboBox, -2, -1, -2))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.mainIssueTablePanel, -1, -1, Short.MAX_VALUE).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.isLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isOpenComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isMergedComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isIssueComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultsLabel)).addGroup(layout.createSequentialGroup().addComponent(this.sortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sortComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderComboBox, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keywordLabel).addComponent(this.keywordTextField, -2, -1, -2).addComponent(this.stateLabel).addComponent(this.stateComboBox, -2, -1, -2).addComponent(this.milestoneLabel).addComponent(this.milestoneComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorLabel).addComponent(this.authorTextField, -2, -1, -2).addComponent(this.createdLabel).addComponent(this.createdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mentionsLabel).addComponent(this.mentionsTextField, -2, -1, -2).addComponent(this.updatedLabel).addComponent(this.updatedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.assigneeTextField, -2, -1, -2).addComponent(this.assigneeLabel).addComponent(this.mergedLabel).addComponent(this.mergedTextField, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.involvesTextField, -2, -1, -2).addComponent(this.involvesLabel).addComponent(this.closedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelsTextField, -2, -1, -2).addComponent(this.inLabel).addComponent(this.labelsLabel))).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.closedTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inTextField, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageTextField, -2, -1, -2).addComponent(this.languageLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commentsTextField, -2, -1, -2).addComponent(this.commentsLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.isLabel).addComponent(this.isOpenComboBox, -2, -1, -2).addComponent(this.isMergedComboBox, -2, -1, -2).addComponent(this.isIssueComboBox, -2, -1, -2).addComponent(this.noLabel).addComponent(this.noComboBox, -2, -1, -2).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sortLabel).addComponent(this.sortComboBox, -2, -1, -2).addComponent(this.orderLabel).addComponent(this.orderComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchButton).addComponent(this.saveButton).addComponent(this.resetButton).addComponent(this.resultsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainIssueTablePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.update();
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            GitHubQueryPanel.this.fireChange();
        }
    }
}

