/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.repository;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.GitHubIssuesConfig;
import com.junichi11.netbeans.modules.github.issues.egit.SearchIssuesParams;
import com.junichi11.netbeans.modules.github.issues.egit.SearchService;
import com.junichi11.netbeans.modules.github.issues.issue.CreateIssueParams;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.options.GitHubIssuesOptions;
import com.junichi11.netbeans.modules.github.issues.query.GitHubDefaultQueries;
import com.junichi11.netbeans.modules.github.issues.query.GitHubQuery;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepositoryController;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepositoryInfo;
import com.junichi11.netbeans.modules.github.issues.utils.GitHubIssuesUtils;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryCommitCompare;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.CollaboratorService;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;

public class GitHubRepository {
    private RepositoryInfo repositoryInfo;
    private GitHubRepositoryController controller;
    private Repository ghRepository;
    private final Map<String, GitHubIssue> issueCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, PullRequest> pullRequestCache = Collections.synchronizedMap(new HashMap());
    private Boolean isCollaborator = null;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Set<GitHubQuery> queries = null;
    private static final String PROPERTY_HOSTNAME = "github.issues.hostname";
    private static final String PROPERTY_OAUTH_TOKEN = "github.issues.oauth.token";
    private static final String PROPERTY_REPOSITORY_AUTHOR = "github.issues.repository.author";
    private static final String PROPERTY_REPOSITORY_NAME = "github.issues.repository.name";
    private static final String PROPERTY_BOOLEAN_PROPERTY_FILE = "github.issues.boolean.property.file";
    private static final Logger LOGGER = Logger.getLogger(GitHubRepository.class.getName());

    public GitHubRepository() {
    }

    public GitHubRepository(RepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
    }

    public String getFullName() {
        return String.format("%s/%s", this.getRepositoryAuthor(), this.getRepositoryName());
    }

    public GitHubIssue createIssue() {
        return new GitHubIssue(this);
    }

    public GitHubRepositoryController getController() {
        if (this.controller == null) {
            this.controller = new GitHubRepositoryController(this);
        }
        return this.controller;
    }

    public Image getIcon() {
        return GitHubIcons.GITHUB_IMAGE_16;
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @CheckForNull
    public GitHubClient createGitHubClient() {
        try {
            String oauthToken;
            if (this.isPropertyFile()) {
                Properties properties = GitHubIssuesUtils.getProperties();
                oauthToken = properties.getProperty("oauth");
            } else {
                oauthToken = this.getOAuthToken();
            }
            GitHubClient client = new GitHubClient(this.getHostname()).setOAuth2Token(oauthToken);
            return client;
        }
        catch (IOException ex) {
            org.netbeans.modules.bugtracking.api.Repository repository = RepositoryManager.getInstance().getRepository("com.junichi11.netbeans.modules.github.issues", this.getID());
            Util.edit((org.netbeans.modules.bugtracking.api.Repository)repository);
            return null;
        }
    }

    public String getID() {
        if (this.repositoryInfo == null) {
            return null;
        }
        return this.repositoryInfo.getID();
    }

    public String getUserName() {
        if (this.repositoryInfo == null) {
            return "";
        }
        return this.repositoryInfo.getUsername();
    }

    public String getHostname() {
        return this.getPropertyValue(PROPERTY_HOSTNAME);
    }

    public String getOAuthToken() {
        return this.getPropertyValue(PROPERTY_OAUTH_TOKEN);
    }

    public String getRepositoryAuthor() {
        return this.getPropertyValue(PROPERTY_REPOSITORY_AUTHOR);
    }

    public String getRepositoryName() {
        return this.getPropertyValue(PROPERTY_REPOSITORY_NAME);
    }

    public boolean isPropertyFile() {
        String propertyValue = this.getPropertyValue(PROPERTY_BOOLEAN_PROPERTY_FILE);
        if (StringUtils.isEmpty(propertyValue)) {
            return false;
        }
        return Boolean.getBoolean(propertyValue);
    }

    private String getPropertyValue(String propertyName) {
        if (this.repositoryInfo != null) {
            return this.repositoryInfo.getValue(propertyName);
        }
        return "";
    }

    public List<Milestone> getMilestones(String state, boolean force) {
        GitHubCache cache = GitHubCache.create(this);
        return cache.getMilestones(state, force);
    }

    public boolean isCollaborator() {
        if (this.isCollaborator == null) {
            GitHubClient client = this.createGitHubClient();
            Repository repository = this.getRepository();
            if (repository == null) {
                return false;
            }
            CollaboratorService collaboratorService = new CollaboratorService(client);
            try {
                this.isCollaborator = collaboratorService.isCollaborator((IRepositoryIdProvider)repository, this.getUserName());
            }
            catch (IOException ex) {
                this.isCollaborator = false;
                LOGGER.log(Level.WARNING, "{0} : Can''t check whether user is a collaborator. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            }
        }
        return this.isCollaborator;
    }

    public List<User> getCollaborators() {
        GitHubCache cache = GitHubCache.create(this);
        return cache.getCollaborators();
    }

    public List<Label> getIssueLabels() {
        GitHubCache cache = GitHubCache.create(this);
        return cache.getLabels();
    }

    @CheckForNull
    public Issue submitNewIssue(CreateIssueParams params) {
        Issue issue = null;
        if (params == null) {
            return issue;
        }
        String title = params.getTitle();
        if (StringUtils.isEmpty(title)) {
            return issue;
        }
        issue = new Issue().setTitle(params.getTitle()).setBody(params.getBody()).setAssignee(params.getAssignee()).setMilestone(params.getMilestone()).setLabels(params.getLabels());
        Repository repository = this.getRepository();
        IssueService issueService = new IssueService(this.createGitHubClient());
        Issue createdIssue = null;
        try {
            createdIssue = issueService.createIssue((IRepositoryIdProvider)repository, issue);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t create an issue. {1}", new Object[]{this.getFullName(), ex.getMessage()});
        }
        return createdIssue;
    }

    @CheckForNull
    public Issue editIssue(GitHubIssue gitHubIssue, CreateIssueParams params) {
        Issue issue = gitHubIssue.getIssue();
        if (params == null) {
            return issue;
        }
        String title = params.getTitle();
        if (StringUtils.isEmpty(title)) {
            return issue;
        }
        User user = new User();
        issue.setTitle(title).setBody(params.getBody()).setAssignee(params.getAssignee()).setMilestone(params.getMilestone()).setLabels(params.getLabels());
        Repository repository = this.getRepository();
        IssueService issueService = new IssueService(this.createGitHubClient());
        Issue updatedIssue = null;
        try {
            updatedIssue = issueService.editIssue((IRepositoryIdProvider)repository, issue);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t edit an issue. {1}", new Object[]{this.getFullName(), ex.getMessage()});
        }
        return updatedIssue;
    }

    public synchronized GitHubIssue createIssue(Issue issue, boolean isRefresh) {
        String id = String.valueOf(issue.getNumber());
        GitHubIssue gitHubIssue = this.issueCache.get(id);
        if (gitHubIssue != null) {
            if (isRefresh) {
                gitHubIssue.setIssue(issue);
            }
            return gitHubIssue;
        }
        gitHubIssue = new GitHubIssue(this, issue);
        this.issueCache.put(id, gitHubIssue);
        return gitHubIssue;
    }

    public synchronized void addIssue(GitHubIssue issue) {
        if (issue == null) {
            return;
        }
        String id = issue.getID();
        if (StringUtils.isEmpty(id)) {
            return;
        }
        GitHubIssue i = this.issueCache.get(id);
        if (i != null) {
            return;
        }
        this.issueCache.put(id, issue);
    }

    @CheckForNull
    public Issue getIssue(int id) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            IssueService issueService = new IssueService(client);
            return issueService.getIssue((IRepositoryIdProvider)repository, id);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get an issue of the id number. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            return null;
        }
    }

    public List<GitHubIssue> getIssues(Map<String, String> filter, boolean isRefresh) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return Collections.emptyList();
        }
        try {
            GitHubClient client = this.createGitHubClient();
            IssueService issueService = new IssueService(client);
            List issues = issueService.getIssues((IRepositoryIdProvider)repository, filter);
            ArrayList<GitHubIssue> gitHubIssues = new ArrayList<GitHubIssue>(issues.size());
            for (Issue issue : issues) {
                GitHubIssue createIssue = this.createIssue(issue, isRefresh);
                gitHubIssues.add(createIssue);
            }
            return gitHubIssues;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get issues. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            return Collections.emptyList();
        }
    }

    public List<GitHubIssue> getIssues(String ... ids) {
        ArrayList<GitHubIssue> issues = new ArrayList<GitHubIssue>();
        for (String id : ids) {
            GitHubIssue issue = this.getIssue(id);
            if (issue == null) continue;
            issues.add(issue);
        }
        return issues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private GitHubIssue getIssue(String id) {
        GitHubIssue issue;
        GitHubRepository gitHubRepository = this;
        synchronized (gitHubRepository) {
            issue = this.issueCache.get(id);
        }
        if (issue != null) {
            return issue;
        }
        GitHubClient client = this.createGitHubClient();
        IssueService issueService = new IssueService(client);
        try {
            Issue i = issueService.getIssue((IRepositoryIdProvider)this.getRepository(), id);
            if (i != null) {
                return this.createIssue(i, false);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get an issue.. {1}", new Object[]{this.getFullName(), ex.getMessage()});
        }
        return null;
    }

    @CheckForNull
    public synchronized PullRequest getPullRequest(int id, boolean force) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        PullRequest pullRequest = this.pullRequestCache.get(String.valueOf(id));
        if (pullRequest != null && !force) {
            return pullRequest;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            pullRequest = pullRequestService.getPullRequest((IRepositoryIdProvider)repository, id);
            if (pullRequest != null) {
                this.pullRequestCache.put(String.valueOf(id), pullRequest);
            }
            return pullRequest;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get the pull request of the id number({1}). {2}", new Object[]{this.getFullName(), id, ex.getMessage()});
            return null;
        }
    }

    public List<PullRequest> getPullRequests(String state) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            List pullRequests = pullRequestService.getPullRequests((IRepositoryIdProvider)repository, state);
            return pullRequests;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get pull requests. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            return Collections.emptyList();
        }
    }

    public List<CommitFile> getPullRequestsFiles(int id) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return Collections.emptyList();
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            return pullRequestService.getFiles((IRepositoryIdProvider)repository, id);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get pull request files. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            return Collections.emptyList();
        }
    }

    public List<RepositoryCommit> getCommits(int id) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return Collections.emptyList();
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            return pullRequestService.getCommits((IRepositoryIdProvider)repository, id);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t get commits for the id({1}). {2}", new Object[]{this.getFullName(), id, ex.getMessage()});
            return Collections.emptyList();
        }
    }

    @CheckForNull
    public MergeStatus merge(int id, String commitMessage) {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            return pullRequestService.merge((IRepositoryIdProvider)repository, id, commitMessage);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t merge. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            return null;
        }
    }

    @CheckForNull
    public PullRequest createPullRequest(int issueId, String head, String base) throws IOException {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            return pullRequestService.createPullRequest((IRepositoryIdProvider)repository, issueId, head, base);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can''t create a pull request. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            throw ex;
        }
    }

    @CheckForNull
    public PullRequest createPullRequest(PullRequest pullRequest) throws IOException {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            PullRequestService pullRequestService = new PullRequestService(client);
            return pullRequestService.createPullRequest((IRepositoryIdProvider)repository, pullRequest);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0}: Can''t create a pull request. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            throw ex;
        }
    }

    public RepositoryCommitCompare compare(String base, String head) throws IOException {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        try {
            GitHubClient client = this.createGitHubClient();
            CommitService commitService = new CommitService(client);
            return commitService.compare((IRepositoryIdProvider)repository, base, head);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} : Can't compare two commits. {1}", new Object[]{this.getFullName(), ex.getMessage()});
            throw ex;
        }
    }

    public synchronized void refresh(GitHubIssue issue) {
        if (issue == null || issue.isNew()) {
            return;
        }
        int id = Integer.parseInt(issue.getID());
        Issue refreshed = this.getIssue(id);
        if (refreshed == null) {
            return;
        }
        issue.setIssue(refreshed);
        if (GitHubIssuesUtils.isPullRequest(refreshed)) {
            this.pullRequestCache.remove(issue.getID());
        }
    }

    public List<GitHubIssue> searchIssues(SearchIssuesParams params, boolean isRefresh) {
        GitHubClient client = this.createGitHubClient();
        SearchService searchService = new SearchService(client);
        String repositoryName = this.getFullName();
        params = params.repo(repositoryName);
        try {
            List<Issue> searchIssues = searchService.searchIssues(params);
            ArrayList<GitHubIssue> issues = new ArrayList<GitHubIssue>(searchIssues.size());
            for (Issue searchIssue : searchIssues) {
                issues.add(this.createIssue(searchIssue, isRefresh));
            }
            return issues;
        }
        catch (IOException ex) {
            UiUtils.showErrorDialog(ex.getMessage());
            LOGGER.log(Level.WARNING, "{0} - {1}", new Object[]{repositoryName, ex.getMessage()});
            return Collections.emptyList();
        }
    }

    public Collection<GitHubIssue> simpleSearch(String keyword) {
        ArrayList<GitHubIssue> issues = new ArrayList<GitHubIssue>();
        if (keyword.matches("\\A\\d+\\z")) {
            issues.addAll(this.getIssues(keyword));
        }
        SearchIssuesParams params = new SearchIssuesParams();
        params.keyword(keyword);
        issues.addAll(this.searchIssues(params, false));
        return issues;
    }

    public List<Comment> getComments(int issueNumber) {
        GitHubClient client = this.createGitHubClient();
        IssueService issueService = new IssueService(client);
        Repository repository = this.getRepository();
        if (repository == null) {
            return Collections.emptyList();
        }
        try {
            return issueService.getComments((IRepositoryIdProvider)repository, issueNumber);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "{0} - {1}", new Object[]{this.getFullName(), ex.getMessage()});
            return Collections.emptyList();
        }
    }

    public GitHubQuery createQuery() {
        return new GitHubQuery(this);
    }

    public Collection<GitHubQuery> getQueries() {
        if (this.queries == null) {
            String[] queryNames;
            this.queries = new HashSet<GitHubQuery>();
            GitHubIssuesOptions options = GitHubIssuesOptions.getInstance();
            Map<GitHubDefaultQueries.Type, Boolean> defaultQueryOptions = options.getDefaultQueryOptions();
            block3: for (Map.Entry<GitHubDefaultQueries.Type, Boolean> entrySet : defaultQueryOptions.entrySet()) {
                GitHubDefaultQueries.Type type = entrySet.getKey();
                Boolean isEnabled = entrySet.getValue();
                if (!isEnabled.booleanValue()) continue;
                switch (type) {
                    case ASSIGNED_TO_ME: {
                        if (this.isCollaborator()) break;
                        continue block3;
                    }
                }
                this.addQuery(GitHubDefaultQueries.create(this, type));
            }
            for (String queryName : queryNames = GitHubIssuesConfig.getInstance().getQueryNames(this)) {
                String queryParams = GitHubIssuesConfig.getInstance().getQueryParams(this, queryName);
                if (StringUtils.isEmpty(queryParams)) continue;
                GitHubQuery gitHubQuery = new GitHubQuery(this, queryName, queryParams);
                gitHubQuery.setSaved(true);
                this.addQuery(gitHubQuery);
            }
        }
        return this.queries;
    }

    public void addQuery(GitHubQuery query) {
        this.getQueries().add(query);
    }

    public void removeQuery(GitHubQuery query) {
        if (!GitHubDefaultQueries.isDefaultQuery(query)) {
            this.removeQueryConfig(query);
        }
        this.getQueries().remove(query);
        this.fireQueryListChanged();
    }

    private void removeQueryConfig(GitHubQuery query) {
        GitHubIssuesConfig.getInstance().removeQuery(this, query);
    }

    public void saveQuery(GitHubQuery query) {
        String displayName = query.getDisplayName();
        if (StringUtils.isEmpty(displayName)) {
            return;
        }
        GitHubIssuesConfig.getInstance().setQueryParams(this, query);
        this.addQuery(query);
        this.fireQueryListChanged();
    }

    public void optionsChanged() {
        GitHubIssuesOptions options = GitHubIssuesOptions.getInstance();
        Map<GitHubDefaultQueries.Type, Boolean> defaultQueryOptions = options.getDefaultQueryOptions();
        for (Map.Entry<GitHubDefaultQueries.Type, Boolean> entrySet : defaultQueryOptions.entrySet()) {
            GitHubDefaultQueries.Type type = entrySet.getKey();
            Boolean isEnabled = entrySet.getValue();
            GitHubQuery query = GitHubDefaultQueries.create(this, type);
            this.setDefaultQuery(query, isEnabled);
        }
        this.fireQueryListChanged();
    }

    private void setDefaultQuery(GitHubQuery query, boolean isEnabled) {
        if (isEnabled) {
            if (!this.getQueries().contains(query)) {
                this.getQueries().add(query);
            }
        } else if (this.getQueries().contains(query)) {
            this.getQueries().remove(query);
        }
    }

    void removed() {
        GitHubIssuesConfig.getInstance().removeRepository(this);
        if (this.queries != null) {
            this.queries.clear();
        }
    }

    @CheckForNull
    public Label addLabel(Label label) {
        GitHubClient client = this.createGitHubClient();
        if (client == null || this.ghRepository == null) {
            return null;
        }
        LabelService service = new LabelService(client);
        try {
            return service.createLabel((IRepositoryIdProvider)this.ghRepository, label);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot add a label:{0} {1}", new Object[]{label.getName(), ex.getMessage()});
            return null;
        }
    }

    @CheckForNull
    public Milestone addMilestone(Milestone milestone) {
        GitHubClient client = this.createGitHubClient();
        if (client == null || this.ghRepository == null) {
            return null;
        }
        MilestoneService service = new MilestoneService(client);
        try {
            return service.createMilestone((IRepositoryIdProvider)this.ghRepository, milestone);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot add a milestone:{0} {1}", new Object[]{milestone.getTitle(), ex.getMessage()});
            return null;
        }
    }

    @CheckForNull
    public Repository getRepository() {
        if (this.ghRepository == null) {
            GitHubClient client = this.createGitHubClient();
            if (client == null) {
                return null;
            }
            try {
                RepositoryService service = new RepositoryService(client);
                this.ghRepository = service.getRepository(this.getRepositoryAuthor(), this.getRepositoryName());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Invalid repository : {0}", this.getFullName());
            }
        }
        return this.ghRepository;
    }

    public void setRepositoryInfo(GitHubRepositoryInfo githubRepositoryInfo) {
        String hostname = githubRepositoryInfo.getHostname();
        if (hostname.equals("api.github.com")) {
            hostname = "github.com";
        }
        String url = String.format("https://%s/%s/%s/issues/", hostname, githubRepositoryInfo.getRepositoryAuthor(), githubRepositoryInfo.getRepositoryName());
        this.repositoryInfo = this.createRepositoryInfo(githubRepositoryInfo, url, githubRepositoryInfo.getUserName(), null, null, null);
        this.setProperties(githubRepositoryInfo);
    }

    private void setProperties(GitHubRepositoryInfo githubRepositoryInfo) {
        if (this.repositoryInfo != null) {
            this.repositoryInfo.putValue(PROPERTY_HOSTNAME, githubRepositoryInfo.getHostname());
            this.repositoryInfo.putValue(PROPERTY_OAUTH_TOKEN, githubRepositoryInfo.getOAuthToken());
            this.repositoryInfo.putValue(PROPERTY_BOOLEAN_PROPERTY_FILE, String.valueOf(githubRepositoryInfo.isPropertyFile()));
            this.repositoryInfo.putValue(PROPERTY_REPOSITORY_AUTHOR, githubRepositoryInfo.getRepositoryAuthor());
            this.repositoryInfo.putValue(PROPERTY_REPOSITORY_NAME, githubRepositoryInfo.getRepositoryName());
        }
    }

    private RepositoryInfo createRepositoryInfo(GitHubRepositoryInfo githubRepositoryInfo, String url, String user, String httpUser, char[] password, char[] httpPassword) {
        String displayName = githubRepositoryInfo.getDisplayName();
        String id = this.repositoryInfo != null ? this.repositoryInfo.getID() : displayName + System.currentTimeMillis();
        RepositoryInfo info = new RepositoryInfo(id, "com.junichi11.netbeans.modules.github.issues", url, displayName, displayName, user, httpUser, password, httpPassword);
        return info;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void fireQueryListChanged() {
        this.propertyChangeSupport.firePropertyChange("bugtracking.repository.queries.changed", null, null);
    }

    private void fireUnsubmittedIssueChanged() {
        this.propertyChangeSupport.firePropertyChange("bugtracking.repository.unsubmittedIssues.changed", null, null);
    }

    public static List<Repository> getRepositories(String oauthToken, String hostname) {
        return GitHubRepository.getRepositories(oauthToken, false, hostname);
    }

    public static List<Repository> getRepositories(String oauthToken, boolean withParent, String hostname) {
        GitHubClient client = hostname == null || hostname.isEmpty() ? new GitHubClient().setOAuth2Token(oauthToken) : new GitHubClient(hostname).setOAuth2Token(oauthToken);
        RepositoryService repositoryService = new RepositoryService(client);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        try {
            List repos = repositoryService.getRepositories();
            if (!withParent) {
                return repos;
            }
            for (Repository repo : repos) {
                Repository forked;
                Repository parent;
                if (repo.isFork() && (parent = (forked = repositoryService.getRepository(repo.getOwner().getLogin(), repo.getName())).getParent()) != null) {
                    repositories.add(parent);
                }
                repositories.add(repo);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, ex.getMessage());
        }
        return repositories;
    }
}

