/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.repository;

import com.junichi11.netbeans.modules.github.issues.repository.Bundle;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepositoryInfo;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepositoryManager;
import com.junichi11.netbeans.modules.github.issues.repository.ui.GitHubRepositoryPanel;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.openide.util.HelpCtx;

public class GitHubRepositoryController
implements RepositoryController {
    private final GitHubRepository repository;
    private GitHubRepositoryPanel panel;
    private String errorMessage;

    public GitHubRepositoryController(GitHubRepository repository) {
        this.repository = repository;
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isValid() {
        this.validate();
        return this.errorMessage == null;
    }

    public void populate() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void applyChanges() {
        GitHubRepositoryPanel p = this.getPanel();
        GitHubRepositoryInfo gitHubRepositoryInfo = new GitHubRepositoryInfo().setHostname(p.getHostname()).setDisplayName(p.getDisplayName()).setUserName(p.getUserName()).setOAuthToken(p.getOAuthToken()).setPropertyFile(p.isPropertyFile()).setRepositoryAuthor(p.getRepositoryAuthor()).setRepositoryName(p.getRepositoryName());
        this.repository.setRepositoryInfo(gitHubRepositoryInfo);
        GitHubRepositoryManager.getInstance().add(this.repository);
    }

    public void cancelChanges() {
    }

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    private GitHubRepositoryPanel getPanel() {
        if (this.panel == null) {
            RepositoryInfo repositoryInfo = this.repository.getRepositoryInfo();
            this.panel = repositoryInfo != null ? new GitHubRepositoryPanel(this.repository) : new GitHubRepositoryPanel();
        }
        return this.panel;
    }

    private void validate() {
        String displayName;
        GitHubRepositoryPanel repositoryPanel = this.getPanel();
        if (!repositoryPanel.isPropertyFile()) {
            if (StringUtils.isEmpty(repositoryPanel.getOAuthToken())) {
                this.errorMessage = Bundle.GithubRepositoryController_message_empty_error(Bundle.GithubRepositoryController_label_oauthToken());
                return;
            }
            if (StringUtils.isEmpty(repositoryPanel.getUserName())) {
                this.errorMessage = Bundle.GithubRepositoryController_message_empty_error(Bundle.GithubRepositoryController_label_userName());
                return;
            }
        }
        if (StringUtils.isEmpty(displayName = repositoryPanel.getDisplayName())) {
            this.errorMessage = Bundle.GithubRepositoryController_message_empty_error(Bundle.GithubRepositoryController_label_displayName());
            return;
        }
        RepositoryManager manager = RepositoryManager.getInstance();
        Collection repositories = manager.getRepositories("com.junichi11.netbeans.modules.github.issues");
        String id = this.repository.getID();
        for (Repository r : repositories) {
            String repositoryName;
            if (id != null && id.equals(r.getId()) || !(repositoryName = r.getDisplayName()).equals(displayName)) continue;
            this.errorMessage = Bundle.GithubRepositoryController_message_displayName_alredy_exists_error();
            return;
        }
        if (StringUtils.isEmpty(repositoryPanel.getRepositoryAuthor())) {
            this.errorMessage = Bundle.GithubRepositoryController_message_empty_error(Bundle.GithubRepositoryController_label_repositoryAuthor());
            return;
        }
        if (StringUtils.isEmpty(repositoryPanel.getRepositoryName())) {
            this.errorMessage = Bundle.GithubRepositoryController_message_empty_error(Bundle.GithubRepositoryController_label_repositoryName());
            return;
        }
        if (!repositoryPanel.isConnectionSuccessful()) {
            this.errorMessage = Bundle.GithubRepositoryController_message_connection_error();
            return;
        }
        if (!repositoryPanel.isRepositoryValid()) {
            this.errorMessage = Bundle.GithubRepositoryController_message_repository_error();
            return;
        }
        if (!repositoryPanel.hasIssues()) {
            this.errorMessage = Bundle.GithubRepositoryController_message_has_issues_error();
            return;
        }
        if (!repositoryPanel.isUserNameValid()) {
            this.errorMessage = Bundle.GithubRepositoryController_message_user_name_error();
            return;
        }
        this.errorMessage = null;
    }
}

