/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.repository;

import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GitHubRepositoryManager {
    private static final GitHubRepositoryManager INSTANCE = new GitHubRepositoryManager();
    private static final Map<String, GitHubRepository> REPOSITORIES = Collections.synchronizedMap(new HashMap());

    private GitHubRepositoryManager() {
    }

    public static final GitHubRepositoryManager getInstance() {
        return INSTANCE;
    }

    public synchronized Collection<GitHubRepository> getRepositories() {
        return REPOSITORIES.values();
    }

    public synchronized GitHubRepository getRepository(String repositoryId) {
        return REPOSITORIES.get(repositoryId);
    }

    public synchronized void add(GitHubRepository repository) {
        if (repository == null) {
            return;
        }
        REPOSITORIES.put(repository.getID(), repository);
    }

    synchronized void remove(GitHubRepository repository) {
        if (repository == null) {
            return;
        }
        REPOSITORIES.remove(repository.getID());
    }
}

