/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.repository.ui;

import com.junichi11.netbeans.modules.github.issues.repository.ui.Bundle;
import java.awt.Component;
import java.awt.Dialog;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.egit.github.core.Repository;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class GitHubRepositoryListPanel
extends JPanel {
    private static final long serialVersionUID = -6030255526517952671L;
    private final DefaultComboBoxModel<Repository> repositoryComboBoxModel = new DefaultComboBoxModel();
    private JComboBox<Repository> repositoryComboBox;

    private GitHubRepositoryListPanel(List<Repository> repositories) {
        this.initComponents();
        this.init(repositories);
    }

    private void init(List<Repository> repositories) {
        this.repositoryComboBoxModel.removeAllElements();
        for (Repository repository : repositories) {
            this.repositoryComboBoxModel.addElement(repository);
        }
        this.repositoryComboBox.setRenderer(new RepositoryListCellRenderer(this.repositoryComboBox.getRenderer()));
        this.repositoryComboBox.setModel(this.repositoryComboBoxModel);
    }

    public static Repository showDialog(List<Repository> repositories) {
        GitHubRepositoryListPanel panel = new GitHubRepositoryListPanel(repositories);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, Bundle.GitHubRepositoryListPanel_title(), true, 2, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return panel.getSelectedRepository();
        }
        return null;
    }

    private Repository getSelectedRepository() {
        return (Repository)this.repositoryComboBox.getSelectedItem();
    }

    private void initComponents() {
        this.repositoryComboBox = new JComboBox();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.repositoryComboBox, 0, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.repositoryComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private static class RepositoryListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8530867911076509797L;
        private final ListCellRenderer renderer;

        public RepositoryListCellRenderer(ListCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = " ";
            if (value instanceof Repository) {
                Repository repository = (Repository)value;
                String loginName = repository.getOwner().getLogin();
                String repositoryName = repository.getName();
                StringBuilder sb = new StringBuilder();
                sb.append(loginName).append("/").append(repositoryName);
                if (repository.isFork()) {
                    sb.append("(fork)");
                }
                text = sb.toString();
            }
            return this.renderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }
}

