/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.repository.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import com.junichi11.netbeans.modules.github.issues.options.GitHubIssuesOptions;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.repository.ui.Bundle;
import com.junichi11.netbeans.modules.github.issues.repository.ui.GitHubRepositoryListPanel;
import com.junichi11.netbeans.modules.github.issues.utils.GitHubIssuesUtils;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.github.core.service.UserService;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GitHubRepositoryPanel
extends JPanel {
    private static final long serialVersionUID = -7859284981818425916L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean isConnectionSuccessful;
    private boolean isRepositoryValid;
    private boolean isUserNameValid;
    private boolean isDotGithubValid;
    private boolean hasIssues;
    private List<Repository> repositoryCache;
    private JButton addRepositoryButton;
    private JButton connectButton;
    private JLabel displayNameLabel;
    private JTextField displayNameTextField;
    private JLabel hostnameLabel;
    private JTextField hostnameTextField;
    private JLabel oauthTokenLabel;
    private JTextField oauthTokenTextField;
    private JCheckBox propertyFileCheckBox;
    private JTextField repositoryAuthorTextField;
    private JLabel repositoryLabel;
    private JTextField repositoryNameTextField;
    private JLabel repositorySeparationLabel;
    private JLabel userNameLabel;
    private JTextField userNameTextField;

    public GitHubRepositoryPanel() {
        this.initComponents();
        this.init();
        this.setHostname("api.github.com");
        try {
            String userName = GitHubIssuesUtils.getUserName();
            String oAuthToken = GitHubIssuesUtils.getOAuthToken();
            if (userName != null && oAuthToken != null) {
                this.setUserName(userName);
                this.setOAuthToken(oAuthToken);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GitHubRepositoryPanel(GitHubRepository repository) {
        this();
        if (repository != null) {
            RepositoryInfo repositoryInfo = repository.getRepositoryInfo();
            if (repositoryInfo != null) {
                this.setDisplayName(repositoryInfo.getDisplayName());
                this.setUserName(repositoryInfo.getUsername());
            }
            this.setHostname(repository.getHostname());
            this.setOAuthToken(repository.getOAuthToken());
            this.setRepositoryAuthor(repository.getRepositoryAuthor());
            this.setRepositoryName(repository.getRepositoryName());
        }
    }

    private void init() {
        DisplayNameDocumentListener displayNameDocumentListener = new DisplayNameDocumentListener();
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.displayNameTextField.getDocument().addDocumentListener(displayNameDocumentListener);
        this.userNameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.oauthTokenTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.repositoryAuthorTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.repositoryNameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.setUserAndOAuthEnabled(!this.isPropertyFile());
        this.propertyFileCheckBox.setVisible(false);
    }

    public String getHostname() {
        String hostname = this.hostnameTextField.getText().trim();
        if (hostname.isEmpty()) {
            return "api.github.com";
        }
        return hostname;
    }

    public String getDisplayName() {
        return this.displayNameTextField.getText().trim();
    }

    public String getUserName() {
        return this.userNameTextField.getText().trim();
    }

    public String getOAuthToken() {
        return this.oauthTokenTextField.getText().trim();
    }

    public boolean isPropertyFile() {
        return this.propertyFileCheckBox.isSelected();
    }

    public String getRepositoryAuthor() {
        return this.repositoryAuthorTextField.getText().trim();
    }

    public String getRepositoryName() {
        return this.repositoryNameTextField.getText().trim();
    }

    public boolean isConnectionSuccessful() {
        return this.isConnectionSuccessful;
    }

    public boolean isRepositoryValid() {
        return this.isRepositoryValid;
    }

    public boolean isUserNameValid() {
        return this.isUserNameValid;
    }

    public boolean isDotGithubValid() {
        return this.isDotGithubValid;
    }

    public boolean hasIssues() {
        return this.hasIssues;
    }

    private void setConnectButtonEnabled(boolean isEnabled) {
        this.connectButton.setEnabled(isEnabled);
    }

    private void setAddRepositoryButtonEnabled(boolean isEnabled) {
        this.addRepositoryButton.setEnabled(isEnabled);
    }

    private void setUserAndOAuthEnabled(boolean isEnabled) {
        this.userNameTextField.setEnabled(isEnabled);
        this.oauthTokenTextField.setEnabled(isEnabled);
    }

    private boolean isUserOrOAuthEmpty() {
        return StringUtils.isEmpty(this.getUserName()) || StringUtils.isEmpty(this.getOAuthToken());
    }

    private boolean isRepositoryEmpty() {
        return StringUtils.isEmpty(this.getRepositoryAuthor()) || StringUtils.isEmpty(this.getRepositoryName());
    }

    private void setHostname(String name) {
        this.hostnameTextField.setText(name);
    }

    private void setDisplayName(String name) {
        this.displayNameTextField.setText(name);
    }

    private void setUserName(String name) {
        this.userNameTextField.setText(name);
    }

    private void setOAuthToken(String oauthToken) {
        this.oauthTokenTextField.setText(oauthToken);
    }

    private void setRepositoryName(String name) {
        this.repositoryNameTextField.setText(name);
    }

    private void setRepositoryAuthor(String name) {
        this.repositoryAuthorTextField.setText(name);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        if (this.isPropertyFile()) {
            this.setConnectButtonEnabled(!this.isRepositoryEmpty());
        } else {
            this.setConnectButtonEnabled(!this.isUserOrOAuthEmpty() && !this.isRepositoryEmpty());
        }
        this.setAddRepositoryButtonEnabled(!StringUtils.isEmpty(this.getOAuthToken()));
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        block20: {
            this.setConnectButtonEnabled(false);
            this.isConnectionSuccessful = false;
            this.isRepositoryValid = false;
            this.hasIssues = true;
            this.isUserNameValid = true;
            String userName = this.getUserName();
            String oAuthToken = this.getOAuthToken();
            try {
                if (this.isPropertyFile()) {
                    File propertyFile;
                    block19: {
                        userName = null;
                        oAuthToken = null;
                        propertyFile = GitHubIssuesUtils.getDotGithub();
                        if (propertyFile.exists()) break block19;
                        UiUtils.showErrorDialog(Bundle.GitHubRepositoryPanel_message_github_file_exist_error());
                        return;
                    }
                    try {
                        Properties properties = GitHubIssuesUtils.getProperties(propertyFile);
                        userName = properties.getProperty("login", null);
                        oAuthToken = properties.getProperty("oauth", null);
                    }
                    catch (IOException ex) {
                        UiUtils.showErrorDialog(Bundle.GitHubRepositoryPanel_message_github_file_read_error());
                    }
                    if (StringUtils.isEmpty(userName) || StringUtils.isEmpty(oAuthToken)) {
                        UiUtils.showErrorDialog(Bundle.GitHubRepositoryPanel_message_userName_oauthToken_error());
                        return;
                    }
                }
                GitHubClient gitHubClient = new GitHubClient(this.getHostname()).setOAuth2Token(oAuthToken);
                UserService userService = new UserService(gitHubClient);
                try {
                    User user = userService.getUser();
                    String login = user.getLogin();
                    if (!login.equals(userName)) {
                        this.isUserNameValid = false;
                        return;
                    }
                }
                catch (IOException ex) {
                    UiUtils.showErrorDialog(Bundle.GitHubRepositoryPanel_message_userName_oauthToken_error());
                }
                if (gitHubClient == null) break block20;
                RepositoryService repositoryService = new RepositoryService(gitHubClient);
                try {
                    Repository repository = repositoryService.getRepository(this.getRepositoryAuthor(), this.getRepositoryName());
                    this.isRepositoryValid = true;
                    this.isConnectionSuccessful = true;
                    if (!repository.isHasIssues()) {
                        this.hasIssues = false;
                        return;
                    }
                }
                catch (IOException ex) {
                    this.isRepositoryValid = false;
                }
            }
            finally {
                this.fireChange();
            }
        }
        if (this.isConnectionSuccessful() && this.isRepositoryValid() && this.hasIssues() && this.isUserNameValid()) {
            UiUtils.showPlainDialog(Bundle.GitHubRepositoryPanel_message_connection_successful());
        }
    }

    private void initComponents() {
        this.connectButton = new JButton();
        this.userNameLabel = new JLabel();
        this.oauthTokenLabel = new JLabel();
        this.userNameTextField = new JTextField();
        this.oauthTokenTextField = new JTextField();
        this.displayNameLabel = new JLabel();
        this.displayNameTextField = new JTextField();
        this.propertyFileCheckBox = new JCheckBox();
        this.repositoryLabel = new JLabel();
        this.repositoryAuthorTextField = new JTextField();
        this.repositorySeparationLabel = new JLabel();
        this.repositoryNameTextField = new JTextField();
        this.addRepositoryButton = new JButton();
        this.hostnameLabel = new JLabel();
        this.hostnameTextField = new JTextField();
        Mnemonics.setLocalizedText((AbstractButton)this.connectButton, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.connectButton.text"));
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubRepositoryPanel.this.connectButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.userNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.oauthTokenLabel, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.oauthTokenLabel.text"));
        this.userNameTextField.setText(NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.userNameTextField.text"));
        this.oauthTokenTextField.setText(NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.oauthTokenTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.displayNameLabel.text"));
        this.displayNameTextField.setText(NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.displayNameTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertyFileCheckBox, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.propertyFileCheckBox.text"));
        this.propertyFileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubRepositoryPanel.this.propertyFileCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.repositoryLabel.text"));
        this.repositoryAuthorTextField.setText(NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.repositoryAuthorTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.repositorySeparationLabel, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.repositorySeparationLabel.text"));
        this.repositoryNameTextField.setText(NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.repositoryNameTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addRepositoryButton, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.addRepositoryButton.text"));
        this.addRepositoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GitHubRepositoryPanel.this.addRepositoryButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hostnameLabel, (String)NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.hostnameLabel.text"));
        this.hostnameTextField.setText(NbBundle.getMessage(GitHubRepositoryPanel.class, (String)"GitHubRepositoryPanel.hostnameTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.propertyFileCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 110, Short.MAX_VALUE).addComponent(this.connectButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.oauthTokenLabel).addComponent(this.displayNameLabel).addComponent(this.repositoryLabel).addComponent(this.userNameLabel).addComponent(this.hostnameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostnameTextField).addGroup(layout.createSequentialGroup().addComponent(this.repositoryAuthorTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repositorySeparationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repositoryNameTextField)).addComponent(this.userNameTextField).addComponent(this.displayNameTextField).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.oauthTokenTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addRepositoryButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostnameLabel).addComponent(this.hostnameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oauthTokenLabel).addComponent(this.oauthTokenTextField, -2, -1, -2).addComponent(this.addRepositoryButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLabel).addComponent(this.userNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayNameLabel).addComponent(this.displayNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryLabel).addComponent(this.repositoryAuthorTextField, -2, -1, -2).addComponent(this.repositorySeparationLabel).addComponent(this.repositoryNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.propertyFileCheckBox).addComponent(this.connectButton))));
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                GitHubRepositoryPanel.this.connect();
            }
        });
    }

    private void propertyFileCheckBoxActionPerformed(ActionEvent evt) {
        this.isConnectionSuccessful = false;
        this.setUserAndOAuthEnabled(!this.propertyFileCheckBox.isSelected());
        this.setConnectButtonEnabled(this.propertyFileCheckBox.isSelected());
        this.fireChange();
    }

    private void addRepositoryButtonActionPerformed(ActionEvent evt) {
        RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List repositories;
                String oAuthToken = GitHubRepositoryPanel.this.getOAuthToken();
                if (StringUtils.isEmpty(oAuthToken)) {
                    UiUtils.showErrorDialog(Bundle.GitHubRepositoryPanel_addRepositoryButtonAction_error_empty_token());
                    return;
                }
                GitHubRepositoryPanel.this.setAddRepositoryButtonEnabled(false);
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.GitHubRepositoryPanel_addRepositoryButtonAction_fetching_repositories());
                try {
                    handle.start();
                    repositories = GitHubRepositoryPanel.this.getRepositories(oAuthToken, GitHubRepositoryPanel.this.getHostname());
                }
                finally {
                    handle.finish();
                }
                if (repositories.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UiUtils.showErrorDialog(Bundle.GitHubRepositoryPanel_addRepositoryButtonAction_error_wrong_token());
                            GitHubRepositoryPanel.this.setAddRepositoryButtonEnabled(true);
                        }
                    });
                    return;
                }
                final Repository repository = GitHubRepositoryListPanel.showDialog(repositories);
                User user = GitHubCache.getUser(oAuthToken, GitHubRepositoryPanel.this.getHostname());
                if (user == null) {
                    return;
                }
                final String userName = user.getLogin();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (repository != null) {
                            String author = repository.getOwner().getLogin();
                            String repositoryName = repository.getName();
                            GitHubRepositoryPanel.this.setUserName(userName);
                            GitHubRepositoryPanel.this.setRepositoryAuthor(author);
                            GitHubRepositoryPanel.this.setRepositoryName(repositoryName);
                            if (StringUtils.isEmpty(GitHubRepositoryPanel.this.getDisplayName())) {
                                GitHubRepositoryPanel.this.setDisplayName(String.format("%s/%s", author, repositoryName));
                            }
                        }
                        GitHubRepositoryPanel.this.setAddRepositoryButtonEnabled(true);
                    }
                });
            }
        });
    }

    private List<Repository> getRepositories(String oAuthToken, String hostname) {
        boolean showParentRepository = GitHubIssuesOptions.getInstance().showParentRepository();
        if (this.repositoryCache == null) {
            this.repositoryCache = GitHubRepository.getRepositories(oAuthToken, showParentRepository, hostname);
        }
        return this.repositoryCache;
    }

    private class DisplayNameDocumentListener
    extends DefaultDocumentListener {
        private DisplayNameDocumentListener() {
        }

        @Override
        protected void processUpdate() {
            GitHubRepositoryPanel.this.fireChange();
        }
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        protected void processUpdate() {
            GitHubRepositoryPanel.this.isConnectionSuccessful = false;
            GitHubRepositoryPanel.this.fireChange();
        }
    }
}

