/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepositoryManager;
import com.junichi11.netbeans.modules.github.issues.ui.ColorIcon;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.User;

public class AttributesListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -7361150610203379058L;
    private final ListCellRenderer renderer;
    private final String repositoryId;

    public AttributesListCellRenderer(ListCellRenderer renderer) {
        this(renderer, null);
    }

    public AttributesListCellRenderer(ListCellRenderer renderer, String repositoryId) {
        this.renderer = renderer;
        this.repositoryId = repositoryId;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Object label;
        String text = null;
        Icon icon = null;
        if (value instanceof Milestone) {
            Milestone milestone = (Milestone)value;
            text = milestone.getTitle();
        } else if (value instanceof User) {
            GitHubRepository repository;
            User user = (User)value;
            text = user.getLogin();
            if (text != null && this.repositoryId != null && !this.repositoryId.isEmpty() && (repository = GitHubRepositoryManager.getInstance().getRepository(this.repositoryId)) != null) {
                GitHubCache cache = GitHubCache.create(repository);
                icon = cache.getUserIcon(user);
            }
        } else if (value instanceof Label) {
            label = (Label)value;
            text = label.getName();
            icon = new ColorIcon(String.format("#%s", label.getColor()));
        }
        if (text == null) {
            text = " ";
        }
        label = (JLabel)this.renderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        ((JLabel)label).setIcon(icon);
        return label;
    }
}

