/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

final class ColorIcon
implements Icon {
    private final int width;
    private final int height;
    private final String color;

    public ColorIcon(String color) {
        this(16, 16, color);
    }

    public ColorIcon(int width, int height, String color) {
        this.width = width;
        this.height = height;
        this.color = color;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        int h = component.getHeight();
        int defaultSize = h - y * 2;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.decode(this.color));
        if (defaultSize < this.height) {
            g2d.fillRect(x, y, this.width, this.height);
        } else {
            g2d.fillRect(x, y, defaultSize, defaultSize);
        }
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

