/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.egit.github.core.Issue;
import org.netbeans.api.annotations.common.CheckForNull;

public final class GitHubIssuesUtils {
    public static final String PROPERTY_USER_NAME = "login";
    public static final String PROPERTY_OAUTH_TOKEN = "oauth";
    private static final String DOT_GITHUB_NAME = ".github";

    private GitHubIssuesUtils() {
    }

    public static boolean isPullRequest(Issue issue) {
        return issue != null && issue.getPullRequest() != null;
    }

    public static File getDotGithub() {
        File homeDir = new File(System.getProperty("user.home"));
        return new File(homeDir, DOT_GITHUB_NAME);
    }

    public static Properties getProperties() throws IOException {
        return GitHubIssuesUtils.getProperties(null);
    }

    public static Properties getProperties(File propertyFile) throws IOException {
        if (propertyFile == null) {
            propertyFile = GitHubIssuesUtils.getDotGithub();
        }
        Properties properties = new Properties();
        if (!propertyFile.exists()) {
            return properties;
        }
        try (FileInputStream in = new FileInputStream(propertyFile);){
            properties.load(in);
        }
        return properties;
    }

    @CheckForNull
    public static String getUserName() throws IOException {
        Properties properties = GitHubIssuesUtils.getProperties();
        return properties.getProperty(PROPERTY_USER_NAME, null);
    }

    @CheckForNull
    public static String getOAuthToken() throws IOException {
        Properties properties = GitHubIssuesUtils.getProperties();
        return properties.getProperty(PROPERTY_OAUTH_TOKEN, null);
    }
}

