/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.utils;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final MutableDataSet OPTIONS = new MutableDataSet();
    private static final Parser PARSER = Parser.builder((DataHolder)OPTIONS).build();
    private static final HtmlRenderer RENDERER = HtmlRenderer.builder((DataHolder)OPTIONS).build();

    private StringUtils() {
    }

    public static String markdownToHtml(String text) {
        if (text == null) {
            return "";
        }
        Document document = PARSER.parse(text);
        return RENDERER.render((Node)document);
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static String join(List<String> tokens, String separator) {
        StringBuilder sb = new StringBuilder();
        if (tokens != null && separator != null) {
            for (String token : tokens) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(token);
            }
        }
        return sb.toString();
    }

    public static String toQuoteComment(String comment) {
        if (StringUtils.isEmpty(comment)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(comment, "\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            sb.append("> ").append(token).append("\n");
        }
        return sb.toString();
    }

    static {
        OPTIONS.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), StrikethroughExtension.create()));
    }
}

