package com.kabouterlabs.jodeint.codepack;
import java.util.Collections;
import java.util.Iterator;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.Callback;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
/**
 * Wrapper for library <b>codepack</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("codepack") 
@Runtime(CRuntime.class) 
public class CodepackLibrary {
	static {
		BridJ.register();
	}
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_itol_e implements IntValuedEnum<codepack_itol_e > {
		ALL_SCALAR(1),
		ATOL_ARRAY(2),
		RTOL_ARRAY(3),
		ALL_ARRAY(4);
		codepack_itol_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_itol_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_itol_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_itask_e implements IntValuedEnum<codepack_itask_e > {
		NORMAL(1),
		ONESTEP_ONLY(2),
		STOP_AT_FIRST_MESH(3),
		NORMAL_TCRIT(4),
		ONESTEP_TCRIT(5);
		codepack_itask_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_itask_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_itask_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_istate_in_e implements IntValuedEnum<codepack_istate_in_e > {
		FIRST_CALL(1),
		NEXT_CALL(2),
		NEXT_CALL_WITH_CHANGES(3);
		codepack_istate_in_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_istate_in_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_istate_in_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_istate_out_e implements IntValuedEnum<codepack_istate_out_e > {
		NOTHING_DONE(1),
		SUCCESS_DONE(2),
		ROOT_FOUND(3),
		MAX_STEPS_EXCEEDED(-1),
		TO_MUCH_ACCURACY(-2),
		ILLEGAL_INPUT(-3),
		ERROR_TEST_FAILURES(-4),
		CONVERGENCE_FAILURES(-5),
		ZERO_ERR_TOLERANCE(-6),
		TOO_SMALL_WORK_ARRAY(-7);
		codepack_istate_out_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_istate_out_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_istate_out_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_iopt_e implements IntValuedEnum<codepack_iopt_e > {
		NO_OPTIONAL_INPUTS(0),
		OPTIONAL_INPUTS(1);
		codepack_iopt_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_iopt_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_iopt_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_method_e implements IntValuedEnum<codepack_method_e > {
		ADAMS_BASIC(10),
		ADAMS_USER_FULL_JAC(11),
		ADAMS_INTERNAL_FULL_JAC(12),
		ADAMS_INTERNAL_DIAG_JAC(13),
		ADAMS_USER_BAND_JAC(14),
		ADAMS_INTERNAL_BAND_JAC(15),
		BDF_BASIC(20),
		BDF_USER_FULL_JAC(21),
		BDF_INTERNAL_FULL_JAC(22),
		BDF_INTERNAL_DIAG_JAC(23),
		BDF_USER_BAND_JAC(24),
		BDF_INTERNAL_BAND_JAC(25),
		BDF_USER_JAC_NO_IA_JA(121),
		BDF_INTERNAL_JAC_IA_JA(222);
		codepack_method_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_method_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_method_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_jac_type_e implements IntValuedEnum<codepack_jac_type_e > {
		USER_PROVIDED(1),
		INTERNAL(2),
		USER_PROVIDED_BANDED(4),
		INTERNAL_BANDED(5);
		codepack_jac_type_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_jac_type_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_jac_type_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i>
	 */
	public enum codepack_ode_err_e implements IntValuedEnum<codepack_ode_err_e > {
		UNCHANGED(2),
		SUCCESS(0),
		ERROR(-1),
		UNKNOWN_ERROR(-20);
		codepack_ode_err_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<codepack_ode_err_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<codepack_ode_err_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i> */
	public static abstract class codepack_ode_func extends Callback<codepack_ode_func > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t_, Pointer<Double > y, Pointer<Double > ydot) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t_), Pointer.getPeer(y), Pointer.getPeer(ydot));
		}
		public void apply(@Ptr long neq, @Ptr long t_, @Ptr long y, @Ptr long ydot) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t_, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ydot, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i> */
	public static abstract class codepack_jac_func_1 extends Callback<codepack_jac_func_1 > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t_, Pointer<Double > y, Pointer<Integer > ml, Pointer<Integer > mu, Pointer<Double > pd, Pointer<Integer > nrowpd) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t_), Pointer.getPeer(y), Pointer.getPeer(ml), Pointer.getPeer(mu), Pointer.getPeer(pd), Pointer.getPeer(nrowpd));
		}
		public void apply(@Ptr long neq, @Ptr long t_, @Ptr long y, @Ptr long ml, @Ptr long mu, @Ptr long pd, @Ptr long nrowpd) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t_, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ml, Integer.class), (Pointer)Pointer.pointerToAddress(mu, Integer.class), (Pointer)Pointer.pointerToAddress(pd, Double.class), (Pointer)Pointer.pointerToAddress(nrowpd, Integer.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i> */
	public static abstract class codepack_jac_func_2 extends Callback<codepack_jac_func_2 > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Integer > j, Pointer<Double > ian, Pointer<Double > jan, Pointer<Double > pdj) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(j), Pointer.getPeer(ian), Pointer.getPeer(jan), Pointer.getPeer(pdj));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long j, @Ptr long ian, @Ptr long jan, @Ptr long pdj) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(j, Integer.class), (Pointer)Pointer.pointerToAddress(ian, Double.class), (Pointer)Pointer.pointerToAddress(jan, Double.class), (Pointer)Pointer.pointerToAddress(pdj, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h</i> */
	public static abstract class codepack_g_func extends Callback<codepack_g_func > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t_, Pointer<Double > y, Pointer<Integer > ng, Pointer<Double > gout) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t_), Pointer.getPeer(y), Pointer.getPeer(ng), Pointer.getPeer(gout));
		}
		public void apply(@Ptr long neq, @Ptr long t_, @Ptr long y, @Ptr long ng, @Ptr long gout) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t_, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ng, Integer.class), (Pointer)Pointer.pointerToAddress(gout, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:96</i> */
	public static abstract class dlsode_f_callback extends Callback<dlsode_f_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Double > ydot) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ydot));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ydot) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ydot, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:111</i> */
	public static abstract class dlsode_jac_callback extends Callback<dlsode_jac_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Integer > ml, Pointer<Integer > mu, Pointer<Double > pd, Pointer<Integer > nrowpd) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ml), Pointer.getPeer(mu), Pointer.getPeer(pd), Pointer.getPeer(nrowpd));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ml, @Ptr long mu, @Ptr long pd, @Ptr long nrowpd) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ml, Integer.class), (Pointer)Pointer.pointerToAddress(mu, Integer.class), (Pointer)Pointer.pointerToAddress(pd, Double.class), (Pointer)Pointer.pointerToAddress(nrowpd, Integer.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:114</i> */
	public static abstract class dlsodes_f_callback extends Callback<dlsodes_f_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Double > ydot) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ydot));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ydot) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ydot, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:129</i> */
	public static abstract class dlsodes_jac_callback extends Callback<dlsodes_jac_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Integer > j, Pointer<Double > ian, Pointer<Double > jan, Pointer<Double > pdj) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(j), Pointer.getPeer(ian), Pointer.getPeer(jan), Pointer.getPeer(pdj));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long j, @Ptr long ian, @Ptr long jan, @Ptr long pdj) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(j, Integer.class), (Pointer)Pointer.pointerToAddress(ian, Double.class), (Pointer)Pointer.pointerToAddress(jan, Double.class), (Pointer)Pointer.pointerToAddress(pdj, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:132</i> */
	public static abstract class dlsoda_f_callback extends Callback<dlsoda_f_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Double > ydot) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ydot));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ydot) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ydot, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:147</i> */
	public static abstract class dlsoda_jac_callback extends Callback<dlsoda_jac_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Integer > ml, Pointer<Integer > mu, Pointer<Double > pd, Pointer<Integer > nrowpd) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ml), Pointer.getPeer(mu), Pointer.getPeer(pd), Pointer.getPeer(nrowpd));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ml, @Ptr long mu, @Ptr long pd, @Ptr long nrowpd) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ml, Integer.class), (Pointer)Pointer.pointerToAddress(mu, Integer.class), (Pointer)Pointer.pointerToAddress(pd, Double.class), (Pointer)Pointer.pointerToAddress(nrowpd, Integer.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:151</i> */
	public static abstract class dlsodar_f_callback extends Callback<dlsodar_f_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Double > ydot) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ydot));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ydot) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ydot, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:166</i> */
	public static abstract class dlsodar_jac_callback extends Callback<dlsodar_jac_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Integer > ml, Pointer<Integer > mu, Pointer<Double > pd, Pointer<Integer > nrowpd) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ml), Pointer.getPeer(mu), Pointer.getPeer(pd), Pointer.getPeer(nrowpd));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ml, @Ptr long mu, @Ptr long pd, @Ptr long nrowpd) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ml, Integer.class), (Pointer)Pointer.pointerToAddress(mu, Integer.class), (Pointer)Pointer.pointerToAddress(pd, Double.class), (Pointer)Pointer.pointerToAddress(nrowpd, Integer.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:166</i> */
	public static abstract class dlsodar_g_callback extends Callback<dlsodar_g_callback > {
		public void apply(Pointer<Integer > neq, Pointer<Double > t, Pointer<Double > y, Pointer<Integer > ng, Pointer<Double > gout) {
			apply(Pointer.getPeer(neq), Pointer.getPeer(t), Pointer.getPeer(y), Pointer.getPeer(ng), Pointer.getPeer(gout));
		}
		public void apply(@Ptr long neq, @Ptr long t, @Ptr long y, @Ptr long ng, @Ptr long gout) {
			apply((Pointer)Pointer.pointerToAddress(neq, Integer.class), (Pointer)Pointer.pointerToAddress(t, Double.class), (Pointer)Pointer.pointerToAddress(y, Double.class), (Pointer)Pointer.pointerToAddress(ng, Integer.class), (Pointer)Pointer.pointerToAddress(gout, Double.class));
		}
	};
	/**
	 * Original signature : <code>CODEPACK_ODE_RETVAL lsode_basic(double*, double*, codepack_ode_func, int, double, double, double, CODEPACK_METHOD_FLAG)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:86</i>
	 */
	public static IntValuedEnum<CodepackLibrary.codepack_ode_err_e > lsode_basic(Pointer<Double > stack, Pointer<Double > q, Pointer<CodepackLibrary.codepack_ode_func > f_func, int neq, double t0, double tf, double dt, IntValuedEnum<CodepackLibrary.codepack_method_e > mf) {
		return FlagSet.fromValue(lsode_basic(Pointer.getPeer(stack), Pointer.getPeer(q), Pointer.getPeer(f_func), neq, t0, tf, dt, (int)mf.value()), CodepackLibrary.codepack_ode_err_e.class);
	}
	protected native static int lsode_basic(@Ptr long stack, @Ptr long q, @Ptr long f_func, int neq, double t0, double tf, double dt, int mf);
	/**
	 * Original signature : <code>CODEPACK_ODE_RETVAL lsodes_basic(double*, double*, codepack_ode_func, int, double, double, double, CODEPACK_METHOD_FLAG)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:87</i>
	 */
	public static IntValuedEnum<CodepackLibrary.codepack_ode_err_e > lsodes_basic(Pointer<Double > stack, Pointer<Double > y, Pointer<CodepackLibrary.codepack_ode_func > f_func, int neq, double t0, double tf, double dt, IntValuedEnum<CodepackLibrary.codepack_method_e > mf) {
		return FlagSet.fromValue(lsodes_basic(Pointer.getPeer(stack), Pointer.getPeer(y), Pointer.getPeer(f_func), neq, t0, tf, dt, (int)mf.value()), CodepackLibrary.codepack_ode_err_e.class);
	}
	protected native static int lsodes_basic(@Ptr long stack, @Ptr long y, @Ptr long f_func, int neq, double t0, double tf, double dt, int mf);
	/**
	 * Original signature : <code>CODEPACK_ODE_RETVAL lsoda_basic(double*, double*, codepack_ode_func, int, double, double, double)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:88</i>
	 */
	public static IntValuedEnum<CodepackLibrary.codepack_ode_err_e > lsoda_basic(Pointer<Double > stack, Pointer<Double > q, Pointer<CodepackLibrary.codepack_ode_func > f_func, int neq, double t0, double tf, double dt) {
		return FlagSet.fromValue(lsoda_basic(Pointer.getPeer(stack), Pointer.getPeer(q), Pointer.getPeer(f_func), neq, t0, tf, dt), CodepackLibrary.codepack_ode_err_e.class);
	}
	protected native static int lsoda_basic(@Ptr long stack, @Ptr long q, @Ptr long f_func, int neq, double t0, double tf, double dt);
	/**
	 * Original signature : <code>CODEPACK_ODE_RETVAL lsodar_basic(double*, double*, codepack_ode_func, int, double, double, double)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:89</i>
	 */
	public static IntValuedEnum<CodepackLibrary.codepack_ode_err_e > lsodar_basic(Pointer<Double > stack, Pointer<Double > q, Pointer<CodepackLibrary.codepack_ode_func > f_func, int neq, double t0, double tf, double dt) {
		return FlagSet.fromValue(lsodar_basic(Pointer.getPeer(stack), Pointer.getPeer(q), Pointer.getPeer(f_func), neq, t0, tf, dt), CodepackLibrary.codepack_ode_err_e.class);
	}
	protected native static int lsodar_basic(@Ptr long stack, @Ptr long q, @Ptr long f_func, int neq, double t0, double tf, double dt);
	/**
	 * full fortran interface here<br>
	 * Original signature : <code>void dlsode(dlsode_f_callback*, const int*, double*, double*, const double*, const int*, const double*, const double*, const int*, int*, const int*, double*, const int*, int*, const int*, dlsode_jac_callback*, const int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:96</i>
	 */
	public static void dlsode(Pointer<CodepackLibrary.dlsode_f_callback > f, Pointer<Integer > neq, Pointer<Double > y, Pointer<Double > t, Pointer<Double > tout, Pointer<Integer > itol, Pointer<Double > rtol, Pointer<Double > atol, Pointer<Integer > itask, Pointer<Integer > istate, Pointer<Integer > iopt, Pointer<Double > rwork, Pointer<Integer > lrw, Pointer<Integer > iwork, Pointer<Integer > liw, Pointer<CodepackLibrary.dlsode_jac_callback > jac, Pointer<Integer > mf) {
		dlsode(Pointer.getPeer(f), Pointer.getPeer(neq), Pointer.getPeer(y), Pointer.getPeer(t), Pointer.getPeer(tout), Pointer.getPeer(itol), Pointer.getPeer(rtol), Pointer.getPeer(atol), Pointer.getPeer(itask), Pointer.getPeer(istate), Pointer.getPeer(iopt), Pointer.getPeer(rwork), Pointer.getPeer(lrw), Pointer.getPeer(iwork), Pointer.getPeer(liw), Pointer.getPeer(jac), Pointer.getPeer(mf));
	}
	protected native static void dlsode(@Ptr long f, @Ptr long neq, @Ptr long y, @Ptr long t, @Ptr long tout, @Ptr long itol, @Ptr long rtol, @Ptr long atol, @Ptr long itask, @Ptr long istate, @Ptr long iopt, @Ptr long rwork, @Ptr long lrw, @Ptr long iwork, @Ptr long liw, @Ptr long jac, @Ptr long mf);
	/**
	 * Original signature : <code>void dlsodes(dlsodes_f_callback*, const int*, double*, double*, const double*, const int*, const double*, const double*, const int*, int*, const int*, double*, const int*, int*, const int*, dlsodes_jac_callback*, const int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:114</i>
	 */
	public static void dlsodes(Pointer<CodepackLibrary.dlsodes_f_callback > f, Pointer<Integer > neq, Pointer<Double > y, Pointer<Double > t, Pointer<Double > tout, Pointer<Integer > itol, Pointer<Double > rtol, Pointer<Double > atol, Pointer<Integer > itask, Pointer<Integer > istate, Pointer<Integer > iopt, Pointer<Double > rwork, Pointer<Integer > lrw, Pointer<Integer > iwork, Pointer<Integer > liw, Pointer<CodepackLibrary.dlsodes_jac_callback > jac, Pointer<Integer > mf) {
		dlsodes(Pointer.getPeer(f), Pointer.getPeer(neq), Pointer.getPeer(y), Pointer.getPeer(t), Pointer.getPeer(tout), Pointer.getPeer(itol), Pointer.getPeer(rtol), Pointer.getPeer(atol), Pointer.getPeer(itask), Pointer.getPeer(istate), Pointer.getPeer(iopt), Pointer.getPeer(rwork), Pointer.getPeer(lrw), Pointer.getPeer(iwork), Pointer.getPeer(liw), Pointer.getPeer(jac), Pointer.getPeer(mf));
	}
	protected native static void dlsodes(@Ptr long f, @Ptr long neq, @Ptr long y, @Ptr long t, @Ptr long tout, @Ptr long itol, @Ptr long rtol, @Ptr long atol, @Ptr long itask, @Ptr long istate, @Ptr long iopt, @Ptr long rwork, @Ptr long lrw, @Ptr long iwork, @Ptr long liw, @Ptr long jac, @Ptr long mf);
	/**
	 * Original signature : <code>void dlsoda(dlsoda_f_callback*, const int*, double*, double*, const double*, const int*, const double*, const double*, const int*, int*, const int*, double*, const int*, int*, const int*, dlsoda_jac_callback*, const int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:132</i>
	 */
	public static void dlsoda(Pointer<CodepackLibrary.dlsoda_f_callback > f, Pointer<Integer > neq, Pointer<Double > y, Pointer<Double > t, Pointer<Double > tout, Pointer<Integer > itol, Pointer<Double > rtol, Pointer<Double > atol, Pointer<Integer > itask, Pointer<Integer > istate, Pointer<Integer > iopt, Pointer<Double > rwork, Pointer<Integer > lrw, Pointer<Integer > iwork, Pointer<Integer > liw, Pointer<CodepackLibrary.dlsoda_jac_callback > jac, Pointer<Integer > jt) {
		dlsoda(Pointer.getPeer(f), Pointer.getPeer(neq), Pointer.getPeer(y), Pointer.getPeer(t), Pointer.getPeer(tout), Pointer.getPeer(itol), Pointer.getPeer(rtol), Pointer.getPeer(atol), Pointer.getPeer(itask), Pointer.getPeer(istate), Pointer.getPeer(iopt), Pointer.getPeer(rwork), Pointer.getPeer(lrw), Pointer.getPeer(iwork), Pointer.getPeer(liw), Pointer.getPeer(jac), Pointer.getPeer(jt));
	}
	protected native static void dlsoda(@Ptr long f, @Ptr long neq, @Ptr long y, @Ptr long t, @Ptr long tout, @Ptr long itol, @Ptr long rtol, @Ptr long atol, @Ptr long itask, @Ptr long istate, @Ptr long iopt, @Ptr long rwork, @Ptr long lrw, @Ptr long iwork, @Ptr long liw, @Ptr long jac, @Ptr long jt);
	/**
	 * Original signature : <code>void dlsodar(dlsodar_f_callback*, const int*, double*, double*, const double*, const int*, const double*, const double*, const int*, int*, const int*, double*, const int*, int*, const int*, dlsodar_jac_callback*, const int*, dlsodar_g_callback*, const int*, int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/codepack/include/codepack.h:151</i>
	 */
	public static void dlsodar(Pointer<CodepackLibrary.dlsodar_f_callback > f, Pointer<Integer > neq, Pointer<Double > y, Pointer<Double > t, Pointer<Double > tout, Pointer<Integer > itol, Pointer<Double > rtol, Pointer<Double > atol, Pointer<Integer > itask, Pointer<Integer > istate, Pointer<Integer > iopt, Pointer<Double > rwork, Pointer<Integer > lrw, Pointer<Integer > iwork, Pointer<Integer > liw, Pointer<CodepackLibrary.dlsodar_jac_callback > jac, Pointer<Integer > jt, Pointer<CodepackLibrary.dlsodar_g_callback > g, Pointer<Integer > ng, Pointer<Integer > jroot) {
		dlsodar(Pointer.getPeer(f), Pointer.getPeer(neq), Pointer.getPeer(y), Pointer.getPeer(t), Pointer.getPeer(tout), Pointer.getPeer(itol), Pointer.getPeer(rtol), Pointer.getPeer(atol), Pointer.getPeer(itask), Pointer.getPeer(istate), Pointer.getPeer(iopt), Pointer.getPeer(rwork), Pointer.getPeer(lrw), Pointer.getPeer(iwork), Pointer.getPeer(liw), Pointer.getPeer(jac), Pointer.getPeer(jt), Pointer.getPeer(g), Pointer.getPeer(ng), Pointer.getPeer(jroot));
	}
	protected native static void dlsodar(@Ptr long f, @Ptr long neq, @Ptr long y, @Ptr long t, @Ptr long tout, @Ptr long itol, @Ptr long rtol, @Ptr long atol, @Ptr long itask, @Ptr long istate, @Ptr long iopt, @Ptr long rwork, @Ptr long lrw, @Ptr long iwork, @Ptr long liw, @Ptr long jac, @Ptr long jt, @Ptr long g, @Ptr long ng, @Ptr long jroot);
}
