/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery;

import com.fasterxml.jackson.databind.JsonNode;
import com.kcthota.JSONQuery.AbstractQueryHelpers;
import com.kcthota.JSONQuery.exceptions.MissingNodeException;
import com.kcthota.JSONQuery.expressions.AndExpression;
import com.kcthota.JSONQuery.expressions.ComparisonExpression;
import com.kcthota.JSONQuery.expressions.EqExpression;
import com.kcthota.JSONQuery.expressions.Expression;
import com.kcthota.JSONQuery.expressions.GeExpression;
import com.kcthota.JSONQuery.expressions.GtExpression;
import com.kcthota.JSONQuery.expressions.IsNullExpression;
import com.kcthota.JSONQuery.expressions.LeExpression;
import com.kcthota.JSONQuery.expressions.LtExpression;
import com.kcthota.JSONQuery.expressions.MultiExpression;
import com.kcthota.JSONQuery.expressions.NeExpression;
import com.kcthota.JSONQuery.expressions.NotExpression;
import com.kcthota.JSONQuery.expressions.OrExpression;
import java.util.List;

public abstract class AbstractQuery
extends AbstractQueryHelpers {
    protected JsonNode node;

    public AbstractQuery(JsonNode node) {
        this.node = node;
    }

    public abstract boolean is(Expression var1);

    public abstract JsonNode value(String var1);

    public abstract boolean isExist(String var1);

    protected boolean is(Expression expr, Boolean currentResult) {
        if (currentResult != null && !currentResult.booleanValue()) {
            return false;
        }
        try {
            if (expr instanceof ComparisonExpression) {
                ComparisonExpression castedExpr = (ComparisonExpression)expr;
                if (castedExpr instanceof EqExpression || castedExpr instanceof IsNullExpression) {
                    return this.getValue(this.node, castedExpr.property()).equals((Object)castedExpr.value());
                }
                if (expr instanceof NeExpression) {
                    return !this.getValue(this.node, castedExpr.property()).equals((Object)castedExpr.value());
                }
                if (expr instanceof GtExpression) {
                    JsonNode propValue = this.getValue(this.node, castedExpr.property());
                    return this.doGt(castedExpr, propValue);
                }
                if (expr instanceof LtExpression) {
                    JsonNode propValue = this.getValue(this.node, castedExpr.property());
                    return this.doLt(castedExpr, propValue);
                }
                if (expr instanceof GeExpression) {
                    JsonNode propValue = this.getValue(this.node, castedExpr.property());
                    return this.doGe(castedExpr, propValue);
                }
                if (expr instanceof LeExpression) {
                    JsonNode propValue = this.getValue(this.node, castedExpr.property());
                    return this.doLe(castedExpr, propValue);
                }
            } else if (expr instanceof MultiExpression) {
                MultiExpression castedExpr = (MultiExpression)expr;
                List<Expression> expressions = castedExpr.getExpressions();
                if (castedExpr instanceof AndExpression) {
                    for (Expression curExpr : expressions) {
                        currentResult = this.is(curExpr, currentResult);
                        if (currentResult.booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
                if (castedExpr instanceof OrExpression) {
                    for (Expression curExpr : expressions) {
                        currentResult = this.is(curExpr, currentResult);
                        if (currentResult.booleanValue()) {
                            return true;
                        }
                        currentResult = null;
                    }
                    return false;
                }
            } else if (expr instanceof NotExpression) {
                NotExpression castedExpr = (NotExpression)expr;
                return !this.is(castedExpr.getExpression(), null);
            }
        }
        catch (MissingNodeException e) {
            return false;
        }
        return false;
    }

    protected JsonNode getValue(JsonNode node, String property) {
        if (node == null) {
            throw new MissingNodeException(property + " is missing");
        }
        JsonNode value = null;
        int index = this.getNextIndex(property, 0);
        if (index < 0) {
            value = node.path(this.formatPropertyName(property));
            if (value.isMissingNode()) {
                throw new MissingNodeException(property + " is missing");
            }
            return value;
        }
        String propertyName = property.substring(0, property.indexOf(46));
        return this.getValue(node.get(propertyName), property.substring(index + 1));
    }

    protected int getNextIndex(String property, int startIndex) {
        int index = property.indexOf(46, startIndex);
        if (index > 0 && property.charAt(index - 1) == '\\') {
            return this.getNextIndex(this.formatPropertyName(property), index);
        }
        return index;
    }

    protected String formatPropertyName(String property) {
        return property.replace("\\.", ".");
    }
}

