/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.ComparisonExpression;

public abstract class AbstractQueryHelpers {
    protected boolean doGt(ComparisonExpression castedExpr, JsonNode propValue) {
        if (castedExpr.value().isNumber() && propValue.isNumber() && castedExpr.value().numberType() == propValue.numberType()) {
            Number nodeValue = propValue.numberValue();
            Number passedValue = castedExpr.value().numberValue();
            if (castedExpr.value().numberType() == JsonParser.NumberType.INT) {
                return (Integer)nodeValue > (Integer)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.LONG) {
                return (Long)nodeValue > (Long)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.FLOAT) {
                return ((Float)nodeValue).floatValue() > ((Float)passedValue).floatValue();
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.DOUBLE) {
                return (Double)nodeValue > (Double)passedValue;
            }
            throw new UnsupportedExprException("Gt supports only INT, LONG, DOUBLE, FLOAT values");
        }
        throw new UnsupportedExprException("Gt supports only numeric values of same type for comparison");
    }

    protected boolean doLt(ComparisonExpression castedExpr, JsonNode propValue) {
        if (castedExpr.value().isNumber() && propValue.isNumber() && castedExpr.value().numberType() == propValue.numberType()) {
            Number nodeValue = propValue.numberValue();
            Number passedValue = castedExpr.value().numberValue();
            if (castedExpr.value().numberType() == JsonParser.NumberType.INT) {
                return (Integer)nodeValue < (Integer)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.LONG) {
                return (Long)nodeValue < (Long)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.FLOAT) {
                return ((Float)nodeValue).floatValue() < ((Float)passedValue).floatValue();
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.DOUBLE) {
                return (Double)nodeValue < (Double)passedValue;
            }
            throw new UnsupportedExprException("Lt supports only INT, LONG, DOUBLE, FLOAT values");
        }
        throw new UnsupportedExprException("Lt supports only numeric values of same type for comparison");
    }

    protected boolean doGe(ComparisonExpression castedExpr, JsonNode propValue) {
        if (castedExpr.value().isNumber() && propValue.isNumber() && castedExpr.value().numberType() == propValue.numberType()) {
            Number nodeValue = propValue.numberValue();
            Number passedValue = castedExpr.value().numberValue();
            if (castedExpr.value().numberType() == JsonParser.NumberType.INT) {
                return (Integer)nodeValue >= (Integer)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.LONG) {
                return (Long)nodeValue >= (Long)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.FLOAT) {
                return ((Float)nodeValue).floatValue() >= ((Float)passedValue).floatValue();
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.DOUBLE) {
                return (Double)nodeValue >= (Double)passedValue;
            }
            throw new UnsupportedExprException("Ge supports only INT, LONG, DOUBLE, FLOAT values");
        }
        throw new UnsupportedExprException("Ge supports only numeric values of same type for comparison");
    }

    protected boolean doLe(ComparisonExpression castedExpr, JsonNode propValue) {
        if (castedExpr.value().isNumber() && propValue.isNumber() && castedExpr.value().numberType() == propValue.numberType()) {
            Number nodeValue = propValue.numberValue();
            Number passedValue = castedExpr.value().numberValue();
            if (castedExpr.value().numberType() == JsonParser.NumberType.INT) {
                return (Integer)nodeValue <= (Integer)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.LONG) {
                return (Long)nodeValue <= (Long)passedValue;
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.FLOAT) {
                return ((Float)nodeValue).floatValue() <= ((Float)passedValue).floatValue();
            }
            if (castedExpr.value().numberType() == JsonParser.NumberType.DOUBLE) {
                return (Double)nodeValue <= (Double)passedValue;
            }
            throw new UnsupportedExprException("Le supports only INT, LONG, DOUBLE, FLOAT values");
        }
        throw new UnsupportedExprException("Le supports only numeric values of same type for comparison");
    }
}

