/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.kcthota.JSONQuery.AbstractQuery;
import com.kcthota.JSONQuery.exceptions.MissingNodeException;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.ComparisonExpression;
import com.kcthota.JSONQuery.expressions.IntegerValueExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;
import java.util.Iterator;

public class Query
extends AbstractQuery {
    private Integer top;
    private Integer skip;

    public Query(JsonNode node) {
        super(node);
    }

    public Query top(Integer value) {
        this.top = value;
        return this;
    }

    public Query skip(Integer value) {
        this.skip = value;
        return this;
    }

    @Override
    public boolean is(ComparisonExpression expr) {
        try {
            if (expr != null) {
                return expr.evaluate(this.node);
            }
        }
        catch (MissingNodeException e) {
            return false;
        }
        return false;
    }

    @Override
    public JsonNode value(String property) {
        return this.value(new ValueExpression(property));
    }

    public JsonNode value(ValueExpression expression) {
        return expression.evaluate(this.node);
    }

    public int value(IntegerValueExpression expression) {
        return expression.evaluate(this.node).intValue();
    }

    @Override
    public boolean isExist(String property) {
        try {
            new ValueExpression(property).evaluate(this.node);
        }
        catch (MissingNodeException e) {
            return false;
        }
        return true;
    }

    public ArrayNode filter(ComparisonExpression expression) {
        ArrayNode result = new ObjectMapper().createArrayNode();
        if (this.node.isArray()) {
            Iterator iterator = this.node.iterator();
            int validObjectsCount = 0;
            int topCount = 0;
            while (iterator.hasNext()) {
                JsonNode curNode = (JsonNode)iterator.next();
                if (expression != null && (expression == null || !new Query(curNode).is(expression)) || this.skip != null && this.skip > 0 && this.skip >= ++validObjectsCount) continue;
                if (this.top == null || topCount < this.top) {
                    result.add(curNode);
                    ++topCount;
                    continue;
                }
                break;
            }
        } else {
            throw new UnsupportedExprException("Filters are only supported on ArrayNode objects");
        }
        return result;
    }

    public ArrayNode filter(String property, ComparisonExpression expression) {
        JsonNode propValueNode = this.value(property);
        return Query.q(propValueNode).top(this.getTop()).skip(this.getSkip()).filter(expression);
    }

    public static Query q(JsonNode node) {
        return new Query(node);
    }

    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public void setSkip(Integer skip) {
        this.skip = skip;
    }
}

