/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.kcthota.JSONQuery.expressions.AndExpression;
import com.kcthota.JSONQuery.expressions.AppendToValueExpression;
import com.kcthota.JSONQuery.expressions.ComparisonExpression;
import com.kcthota.JSONQuery.expressions.EndsWithExpression;
import com.kcthota.JSONQuery.expressions.EqExpression;
import com.kcthota.JSONQuery.expressions.GeExpression;
import com.kcthota.JSONQuery.expressions.GtExpression;
import com.kcthota.JSONQuery.expressions.IndexofValueExpression;
import com.kcthota.JSONQuery.expressions.IntegerValueExpression;
import com.kcthota.JSONQuery.expressions.IsNullExpression;
import com.kcthota.JSONQuery.expressions.LeExpression;
import com.kcthota.JSONQuery.expressions.LengthValueExpression;
import com.kcthota.JSONQuery.expressions.LtExpression;
import com.kcthota.JSONQuery.expressions.NeExpression;
import com.kcthota.JSONQuery.expressions.NotExpression;
import com.kcthota.JSONQuery.expressions.OrExpression;
import com.kcthota.JSONQuery.expressions.PrependToValueExpression;
import com.kcthota.JSONQuery.expressions.ReplaceValueExpression;
import com.kcthota.JSONQuery.expressions.StartsWithExpression;
import com.kcthota.JSONQuery.expressions.SubstringOfExpression;
import com.kcthota.JSONQuery.expressions.SubstringValueExpression;
import com.kcthota.JSONQuery.expressions.ToLowerValueExpression;
import com.kcthota.JSONQuery.expressions.ToUpperValueExpression;
import com.kcthota.JSONQuery.expressions.TrimValueExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;

public class Expr {
    public static EqExpression eq(String property, String value) {
        return Expr.eq(Expr.val(property), (JsonNode)TextNode.valueOf((String)value));
    }

    public static EqExpression eq(String property, Integer value) {
        return Expr.eq(Expr.val(property), (JsonNode)IntNode.valueOf((int)value));
    }

    public static EqExpression eq(String property, Long value) {
        return Expr.eq(Expr.val(property), (JsonNode)LongNode.valueOf((long)value));
    }

    public static EqExpression eq(String property, boolean value) {
        return Expr.eq(Expr.val(property), (JsonNode)BooleanNode.valueOf((boolean)value));
    }

    public static EqExpression eq(String property, JsonNode value) {
        return Expr.eq(Expr.val(property), value);
    }

    public static EqExpression eq(ValueExpression expression, String value) {
        return Expr.eq(expression, (JsonNode)TextNode.valueOf((String)value));
    }

    public static EqExpression eq(ValueExpression expression, JsonNode value) {
        return new EqExpression(expression, value);
    }

    public static NeExpression ne(String property, String value) {
        return Expr.ne(Expr.val(property), (JsonNode)TextNode.valueOf((String)value));
    }

    public static NeExpression ne(String property, Integer value) {
        return Expr.ne(Expr.val(property), (JsonNode)IntNode.valueOf((int)value));
    }

    public static NeExpression ne(String property, Long value) {
        return Expr.ne(Expr.val(property), (JsonNode)LongNode.valueOf((long)value));
    }

    public static NeExpression ne(String property, boolean value) {
        return Expr.ne(Expr.val(property), (JsonNode)BooleanNode.valueOf((boolean)value));
    }

    public static NeExpression ne(String property, JsonNode value) {
        return Expr.ne(Expr.val(property), value);
    }

    public static NeExpression ne(ValueExpression expression, String value) {
        return Expr.ne(expression, (JsonNode)TextNode.valueOf((String)value));
    }

    public static NeExpression ne(ValueExpression expression, JsonNode value) {
        return new NeExpression(expression, value);
    }

    public static GtExpression gt(String property, Integer value) {
        return new GtExpression(Expr.val(property), (JsonNode)IntNode.valueOf((int)value));
    }

    public static GtExpression gt(String property, Long value) {
        return new GtExpression(Expr.val(property), (JsonNode)LongNode.valueOf((long)value));
    }

    public static GtExpression gt(String property, Float value) {
        return new GtExpression(Expr.val(property), (JsonNode)FloatNode.valueOf((float)value.floatValue()));
    }

    public static GtExpression gt(String property, Double value) {
        return new GtExpression(Expr.val(property), (JsonNode)DoubleNode.valueOf((double)value));
    }

    public static LtExpression lt(String property, Integer value) {
        return new LtExpression(Expr.val(property), (JsonNode)IntNode.valueOf((int)value));
    }

    public static LtExpression lt(String property, Long value) {
        return new LtExpression(Expr.val(property), (JsonNode)LongNode.valueOf((long)value));
    }

    public static LtExpression lt(String property, Float value) {
        return new LtExpression(Expr.val(property), (JsonNode)FloatNode.valueOf((float)value.floatValue()));
    }

    public static LtExpression lt(String property, Double value) {
        return new LtExpression(Expr.val(property), (JsonNode)DoubleNode.valueOf((double)value));
    }

    public static GeExpression ge(String property, Integer value) {
        return new GeExpression(Expr.val(property), (JsonNode)IntNode.valueOf((int)value));
    }

    public static GeExpression ge(String property, Long value) {
        return new GeExpression(Expr.val(property), (JsonNode)LongNode.valueOf((long)value));
    }

    public static GeExpression ge(String property, Float value) {
        return new GeExpression(Expr.val(property), (JsonNode)FloatNode.valueOf((float)value.floatValue()));
    }

    public static GeExpression ge(String property, Double value) {
        return new GeExpression(Expr.val(property), (JsonNode)DoubleNode.valueOf((double)value));
    }

    public static LeExpression le(String property, Integer value) {
        return new LeExpression(Expr.val(property), (JsonNode)IntNode.valueOf((int)value));
    }

    public static LeExpression le(String property, Long value) {
        return new LeExpression(Expr.val(property), (JsonNode)LongNode.valueOf((long)value));
    }

    public static LeExpression le(String property, Float value) {
        return new LeExpression(Expr.val(property), (JsonNode)FloatNode.valueOf((float)value.floatValue()));
    }

    public static LeExpression le(String property, Double value) {
        return new LeExpression(Expr.val(property), (JsonNode)DoubleNode.valueOf((double)value));
    }

    public static AndExpression and(ComparisonExpression ... expressions) {
        return new AndExpression(expressions);
    }

    public static OrExpression or(ComparisonExpression ... expressions) {
        return new OrExpression(expressions);
    }

    public static IsNullExpression Null(String property) {
        return new IsNullExpression(Expr.val(property));
    }

    public static NotExpression not(ComparisonExpression expr) {
        return new NotExpression(expr);
    }

    public static SubstringOfExpression substringof(String property, String value) {
        return Expr.substringof(Expr.val(property), value);
    }

    public static SubstringOfExpression substringof(ValueExpression expression, String value) {
        return new SubstringOfExpression(expression, (JsonNode)TextNode.valueOf((String)value));
    }

    public static StartsWithExpression startsWith(String property, String value) {
        return Expr.startsWith(Expr.val(property), value);
    }

    public static StartsWithExpression startsWith(ValueExpression expression, String value) {
        return new StartsWithExpression(expression, (JsonNode)TextNode.valueOf((String)value));
    }

    public static EndsWithExpression endsWith(String property, String value) {
        return Expr.endsWith(Expr.val(property), value);
    }

    public static EndsWithExpression endsWith(ValueExpression expression, String value) {
        return new EndsWithExpression(expression, (JsonNode)TextNode.valueOf((String)value));
    }

    public static ValueExpression val(String property) {
        return new ValueExpression(property);
    }

    public static ValueExpression val(ValueExpression valExpression, String property) {
        return new ValueExpression(property, valExpression);
    }

    public static AppendToValueExpression appendTo(String property, String appendText) {
        return new AppendToValueExpression(property, appendText);
    }

    public static AppendToValueExpression appendTo(ValueExpression valExpression, String property, String appendText) {
        return new AppendToValueExpression(property, appendText, valExpression);
    }

    public static AppendToValueExpression appendTo(ValueExpression valExpression, String appendText) {
        return new AppendToValueExpression(null, appendText, valExpression);
    }

    public static PrependToValueExpression prependTo(String property, String prependText) {
        return new PrependToValueExpression(property, prependText);
    }

    public static PrependToValueExpression prependTo(ValueExpression valExpression, String property, String prependText) {
        return new PrependToValueExpression(property, prependText, valExpression);
    }

    public static PrependToValueExpression prependTo(ValueExpression valExpression, String prependText) {
        return new PrependToValueExpression(null, prependText, valExpression);
    }

    public static TrimValueExpression trim(String property) {
        return new TrimValueExpression(property);
    }

    public static TrimValueExpression trim(ValueExpression valExpression, String property) {
        return new TrimValueExpression(property, valExpression);
    }

    public static TrimValueExpression trim(ValueExpression valExpression) {
        return new TrimValueExpression(null, valExpression);
    }

    public static ToUpperValueExpression upper(String property) {
        return new ToUpperValueExpression(property);
    }

    public static ToUpperValueExpression upper(ValueExpression valExpression, String property) {
        return new ToUpperValueExpression(property, valExpression);
    }

    public static ToUpperValueExpression upper(ValueExpression valExpression) {
        return new ToUpperValueExpression(null, valExpression);
    }

    public static ToLowerValueExpression lower(String property) {
        return new ToLowerValueExpression(property);
    }

    public static ToLowerValueExpression lower(ValueExpression valExpression, String property) {
        return new ToLowerValueExpression(property, valExpression);
    }

    public static ToLowerValueExpression lower(ValueExpression valExpression) {
        return new ToLowerValueExpression(null, valExpression);
    }

    public static ReplaceValueExpression replace(String property, String target, String replacement) {
        return new ReplaceValueExpression(property, target, replacement);
    }

    public static ReplaceValueExpression replace(ValueExpression valExpression, String property, String target, String replacement) {
        return new ReplaceValueExpression(property, target, replacement, valExpression);
    }

    public static ReplaceValueExpression replace(ValueExpression valExpression, String target, String replacement) {
        return new ReplaceValueExpression(null, target, replacement, valExpression);
    }

    public static SubstringValueExpression substring(String property, int startIndex) {
        return new SubstringValueExpression(property, startIndex, null);
    }

    public static SubstringValueExpression substring(String property, int startIndex, int length) {
        return new SubstringValueExpression(property, startIndex, length);
    }

    public static SubstringValueExpression substring(ValueExpression valExpression, String property, int startIndex) {
        return new SubstringValueExpression(property, startIndex, null, valExpression);
    }

    public static SubstringValueExpression substring(ValueExpression valExpression, String property, int startIndex, int length) {
        return new SubstringValueExpression(property, startIndex, length, valExpression);
    }

    public static SubstringValueExpression substring(ValueExpression valExpression, int startIndex) {
        return new SubstringValueExpression(null, startIndex, null, valExpression);
    }

    public static SubstringValueExpression substring(ValueExpression valExpression, int startIndex, int length) {
        return new SubstringValueExpression(null, startIndex, length, valExpression);
    }

    public static IntegerValueExpression length(String property) {
        return new LengthValueExpression(property);
    }

    public static IntegerValueExpression length(ValueExpression valExpression, String property) {
        return new LengthValueExpression(property, valExpression);
    }

    public static IntegerValueExpression indexof(String property, String str) {
        return new IndexofValueExpression(property, str);
    }

    public static IntegerValueExpression indexof(ValueExpression valExpression, String property, String str) {
        return new IndexofValueExpression(property, str, valExpression);
    }
}

