/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.SimpleComparisonExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;

public class GtExpression
extends SimpleComparisonExpression {
    public GtExpression(ValueExpression expression, JsonNode value) {
        super(expression, value);
    }

    @Override
    public boolean evaluate(JsonNode node) {
        return this.doGt(this.expression().evaluate(node), this.value());
    }

    protected boolean doGt(JsonNode propertyNode, JsonNode passedNode) {
        if (propertyNode.isNumber() && passedNode.isNumber() && propertyNode.numberType() == passedNode.numberType()) {
            Number propertyValue = propertyNode.numberValue();
            Number passedValue = passedNode.numberValue();
            if (propertyNode.numberType() == JsonParser.NumberType.INT) {
                return (Integer)propertyValue > (Integer)passedValue;
            }
            if (propertyNode.numberType() == JsonParser.NumberType.LONG) {
                return (Long)propertyValue > (Long)passedValue;
            }
            if (propertyNode.numberType() == JsonParser.NumberType.FLOAT) {
                return ((Float)propertyValue).floatValue() > ((Float)passedValue).floatValue();
            }
            if (propertyNode.numberType() == JsonParser.NumberType.DOUBLE) {
                return (Double)propertyValue > (Double)passedValue;
            }
            throw new UnsupportedExprException("Gt supports only INT, LONG, DOUBLE, FLOAT values");
        }
        throw new UnsupportedExprException("Gt supports only numeric values of same type for comparison");
    }
}

