/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.StringValueExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;

public class PrependToValueExpression
extends StringValueExpression {
    private String prependText = "";

    public PrependToValueExpression(String property, String prependText) {
        super(property);
        if (prependText != null) {
            this.prependText = prependText;
        }
    }

    public PrependToValueExpression(String property, String prependText, ValueExpression innerExpression) {
        super(property, innerExpression);
        if (prependText != null) {
            this.prependText = prependText;
        }
    }

    @Override
    public JsonNode evaluate(JsonNode node) {
        JsonNode valueNode = super.evaluate(node);
        if (valueNode == null || !valueNode.isTextual()) {
            throw new UnsupportedExprException("Property value is not a string");
        }
        return TextNode.valueOf((String)(this.prependText + valueNode.textValue()));
    }
}

