/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.StringValueExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;

public class ReplaceValueExpression
extends StringValueExpression {
    private String target = "";
    private String replacement = "";

    public ReplaceValueExpression(String property, String target, String replacement) {
        super(property);
        if (target != null) {
            this.target = target;
        }
        if (replacement != null) {
            this.replacement = replacement;
        }
    }

    public ReplaceValueExpression(String property, String target, String replacement, ValueExpression innerExpression) {
        super(property, innerExpression);
        if (target != null) {
            this.target = target;
        }
        if (replacement != null) {
            this.replacement = replacement;
        }
    }

    @Override
    public JsonNode evaluate(JsonNode node) {
        JsonNode valueNode = super.evaluate(node);
        if (valueNode == null || !valueNode.isTextual()) {
            throw new UnsupportedExprException("Property value is not a string");
        }
        return TextNode.valueOf((String)valueNode.textValue().replace(this.target, this.replacement));
    }
}

