/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.StringValueExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;

public class SubstringValueExpression
extends StringValueExpression {
    private Integer startIndex = 0;
    private Integer length = null;

    public SubstringValueExpression(String property, Integer startIndex, Integer length) {
        super(property);
        if (startIndex != null) {
            this.startIndex = startIndex;
        }
        if (length != null) {
            this.length = length;
        }
    }

    public SubstringValueExpression(String property, Integer startIndex, Integer length, ValueExpression innerExpression) {
        super(property, innerExpression);
        if (startIndex != null) {
            this.startIndex = startIndex;
        }
        if (length != null) {
            this.length = length;
        }
    }

    @Override
    public JsonNode evaluate(JsonNode node) {
        JsonNode valueNode = super.evaluate(node);
        if (valueNode == null || !valueNode.isTextual()) {
            throw new UnsupportedExprException("Property value is not a string");
        }
        String value = valueNode.textValue();
        if (this.length == null || this.length != null && this.length > value.length()) {
            this.length = value.length();
        }
        return TextNode.valueOf((String)value.substring(this.startIndex, this.length));
    }
}

