/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.kcthota.JSONQuery.exceptions.UnsupportedExprException;
import com.kcthota.JSONQuery.expressions.StringValueExpression;
import com.kcthota.JSONQuery.expressions.ValueExpression;

public class TrimValueExpression
extends StringValueExpression {
    public TrimValueExpression(String property) {
        super(property);
    }

    public TrimValueExpression(String property, ValueExpression innerExpression) {
        super(property, innerExpression);
    }

    @Override
    public JsonNode evaluate(JsonNode node) {
        JsonNode valueNode = super.evaluate(node);
        if (valueNode == null || !valueNode.isTextual()) {
            throw new UnsupportedExprException("Property value is not a string");
        }
        return TextNode.valueOf((String)valueNode.textValue().trim());
    }
}

