/*
 * Decompiled with CFR 0.152.
 */
package com.kcthota.JSONQuery.expressions;

import com.fasterxml.jackson.databind.JsonNode;
import com.kcthota.JSONQuery.exceptions.MissingNodeException;
import com.kcthota.JSONQuery.expressions.Expression;

public class ValueExpression
implements Expression {
    String property;
    ValueExpression innerExpression = null;

    public ValueExpression(String property, ValueExpression innerExpression) {
        this.property = property;
        this.innerExpression = innerExpression;
    }

    public ValueExpression(String property) {
        this.property = property;
    }

    public JsonNode evaluate(JsonNode node) {
        if (this.innerExpression == null) {
            return this.getValue(node, this.property);
        }
        return this.getValue(this.innerExpression.evaluate(node), this.property);
    }

    protected JsonNode getValue(JsonNode node, String property) {
        if (node == null) {
            throw new MissingNodeException(property + " is missing");
        }
        if (property == null) {
            return node;
        }
        JsonNode value = node.at(this.formatPropertyName(property));
        if (value.isMissingNode()) {
            throw new MissingNodeException(property + " is missing");
        }
        return value;
    }

    protected String formatPropertyName(String property) {
        if (!property.startsWith("/")) {
            return "/" + property;
        }
        return property;
    }
}

