/*
 * Decompiled with CFR 0.152.
 */
import com.kotlinnlp.dependencytree.DependencyTree;
import com.kotlinnlp.syntaxdecoder.transitionsystem.ActionsGenerator;
import com.kotlinnlp.syntaxdecoder.transitionsystem.Transition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.TransitionSystem;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.Oracle;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.OracleFactory;
import com.kotlinnlp.syntaxdecoder.transitionsystem.state.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B?\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ9\u0010\u0010\u001a\u00120\u0011R\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0012\u001a\u00028\u00002\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LTransitionSystemCoverage;", "StateType", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/State;", "TransitionType", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition;", "", "transitionSystem", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/TransitionSystem;", "oracleFactory", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/OracleFactory;", "errorExploring", "", "verbose", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/TransitionSystem;Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/OracleFactory;ZZ)V", "actionsGenerator", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/ActionsGenerator$Unlabeled;", "getBestAction", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Action;", "state", "oracle", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/State;Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;)Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Action;", "run", "", "sentence", "LSentence;", "syntaxdecoder"})
public final class TransitionSystemCoverage<StateType extends State<StateType>, TransitionType extends Transition<TransitionType, StateType>> {
    private final ActionsGenerator.Unlabeled<StateType, TransitionType> actionsGenerator;
    private final TransitionSystem<StateType, TransitionType> transitionSystem;
    private final OracleFactory<StateType, TransitionType> oracleFactory;
    private final boolean errorExploring;
    private final boolean verbose;

    public final void run(@NotNull Sentence sentence) {
        boolean bl;
        String string;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        DependencyTree dependencyTree = sentence.getDependencyTree();
        if (dependencyTree == null) {
            Intrinsics.throwNpe();
        }
        Oracle oracle = this.oracleFactory.invoke(dependencyTree);
        boolean bl3 = bl2 = !this.errorExploring || Intrinsics.areEqual((Object)((Object)oracle.getType()), (Object)((Object)Oracle.Type.DYNAMIC));
        if (!bl2) {
            String string2 = "error-exploring not supported by " + (Object)((Object)oracle.getType()) + " oracle.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        StateType state = this.transitionSystem.getInitialState(sentence.getTokens(), sentence.getTokens().size());
        while (!((State)state).isTerminal()) {
            if (this.verbose) {
                System.out.println(state);
            }
            Transition.Action bestAction = this.getBestAction(state, oracle);
            if (this.verbose) {
                string = "apply: " + bestAction.getTransition();
                System.out.println((Object)string);
            }
            oracle.apply(bestAction.getTransition());
            Transition.Action.apply$default(bestAction, false, 1, null);
        }
        if (!this.errorExploring && !(bl = ((State)state).getDependencyTree().matchHeads(sentence.getDependencyTree().getHeads()))) {
            string = "Found:\n" + ((State)state).getDependencyTree() + "\n\nExpected:\n" + sentence.getDependencyTree();
            System.out.println((Object)string);
            Unit unit = Unit.INSTANCE;
            throw (Throwable)new IllegalArgumentException(unit.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Transition.Action getBestAction(StateType state, Oracle<StateType, TransitionType> oracle) {
        Transition.Action action;
        boolean $receiver$iv2;
        Transition.Action it;
        Object element$iv2;
        List<Transition.Action> actions;
        block8: {
            boolean bl;
            actions = this.actionsGenerator.generateFrom(this.transitionSystem.generateTransitions(state));
            Iterable $receiver$iv2 = actions;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $receiver$iv2) {
                    it = (Transition.Action)element$iv2;
                    if (!(((Transition)it.getTransition()).isAllowed() && oracle.hasZeroCost(it))) continue;
                    bl = true;
                    break block8;
                }
                bl = $receiver$iv2 = false;
            }
        }
        if (!$receiver$iv2) {
            element$iv2 = "there should always be a 0 cost action";
            throw (Throwable)new IllegalArgumentException(element$iv2.toString());
        }
        if (this.errorExploring) {
            void $receiver$iv$iv;
            Iterable $receiver$iv3 = actions;
            element$iv2 = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Transition.Action it2 = (Transition.Action)element$iv$iv;
                if (!((Transition)it2.getTransition()).isAllowed()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allowedActions = (List)destination$iv$iv;
            action = (Transition.Action)allowedActions.get((int)Math.round(Math.random() * (double)CollectionsKt.getLastIndex((List)allowedActions)));
        } else {
            block9: {
                Iterable $receiver$iv4 = actions;
                for (Object element$iv2 : $receiver$iv4) {
                    it = (Transition.Action)element$iv2;
                    if (!(((Transition)it.getTransition()).isAllowed() && oracle.isCorrect(it))) continue;
                    break block9;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            action = (Transition.Action)element$iv2;
        }
        return action;
    }

    public TransitionSystemCoverage(@NotNull TransitionSystem<StateType, TransitionType> transitionSystem, @NotNull OracleFactory<StateType, TransitionType> oracleFactory, boolean errorExploring, boolean verbose) {
        Intrinsics.checkParameterIsNotNull(transitionSystem, (String)"transitionSystem");
        Intrinsics.checkParameterIsNotNull(oracleFactory, (String)"oracleFactory");
        this.transitionSystem = transitionSystem;
        this.oracleFactory = oracleFactory;
        this.errorExploring = errorExploring;
        this.verbose = verbose;
        this.actionsGenerator = new ActionsGenerator.Unlabeled();
    }

    public /* synthetic */ TransitionSystemCoverage(TransitionSystem transitionSystem, OracleFactory oracleFactory, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(transitionSystem, oracleFactory, bl, bl2);
    }
}

