/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcdistance.transitions;

import com.kotlinnlp.syntaxdecoder.syntax.SyntacticDependency;
import com.kotlinnlp.syntaxdecoder.transitionsystem.Transition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcdistance.ArcDistanceTransition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.state.templates.StackBufferState;
import com.kotlinnlp.syntaxdecoder.utils.ExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcdistance/transitions/ArcRight;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcdistance/ArcDistanceTransition;", "Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;", "refState", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/templates/StackBufferState;", "degree", "", "id", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/templates/StackBufferState;II)V", "getDegree", "()I", "dependentId", "getDependentId", "()Ljava/lang/Integer;", "governorId", "getGovernorId", "isAllowed", "", "()Z", "priority", "getPriority", "stackSize", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Type;", "perform", "", "state", "toString", "", "syntaxdecoder"})
public final class ArcRight
extends ArcDistanceTransition
implements SyntacticDependency {
    @NotNull
    private final Transition.Type type;
    private final int priority = 3;
    private final int stackSize;
    private final int degree;

    @Override
    @NotNull
    public Transition.Type getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Integer getGovernorId() {
        Integer n = ((StackBufferState)this.getRefState()).getStack().get(this.stackSize - 1 - this.degree);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"this.refState.stack[this\u2026ckSize - 1 - this.degree]");
        return n;
    }

    @Override
    @NotNull
    public Integer getDependentId() {
        return (Integer)CollectionsKt.first((List)((StackBufferState)this.getRefState()).getBuffer());
    }

    @Override
    public boolean isAllowed() {
        Collection collection = ((StackBufferState)this.getRefState()).getBuffer();
        return !collection.isEmpty() && this.stackSize > this.degree;
    }

    @Override
    protected void perform(@NotNull StackBufferState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ExtensionsKt.removeFirst(state.getBuffer());
        int n = this.stackSize - 1 - this.degree;
        state.getBuffer().addAll(0, (Collection<Integer>)ExtensionsKt.extractAndRemove(state.getStack(), new IntRange(n, CollectionsKt.getLastIndex((List)((StackBufferState)this.getRefState()).getStack()))));
    }

    @NotNull
    public String toString() {
        return "arc-right(" + this.degree + ')';
    }

    public final int getDegree() {
        return this.degree;
    }

    public ArcRight(@NotNull StackBufferState refState, int degree, int id) {
        Intrinsics.checkParameterIsNotNull((Object)refState, (String)"refState");
        super(refState, id);
        this.degree = degree;
        this.type = Transition.Type.ARC_RIGHT;
        this.priority = 3;
        this.stackSize = ((StackBufferState)this.getRefState()).getStack().size();
    }
}

