/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine;

import com.kotlinnlp.dependencytree.DependencyTree;
import com.kotlinnlp.syntaxdecoder.syntax.SyntacticDependency;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine.ArcEagerSpineState;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine.ArcEagerSpineTransition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine.transitions.ArcLeft;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine.transitions.ArcRight;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine.transitions.Root;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arceagerspine.transitions.Shift;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.Oracle;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.OracleFactory;
import com.kotlinnlp.syntaxdecoder.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\f\u0010\u0017\u001a\u00020\t*\u00020\u0018H\u0002J\f\u0010\u0017\u001a\u00020\t*\u00020\u0019H\u0002J\f\u0010\u0017\u001a\u00020\t*\u00020\u001aH\u0002J\f\u0010\u0017\u001a\u00020\t*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0013*\u00020\u0018H\u0002J\f\u0010\u001c\u001a\u00020\u0013*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u0013*\u00020\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u0013*\u00020\u001bH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/ArcEagerSpineOracle;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/ArcEagerSpineState;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/ArcEagerSpineTransition;", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "(Lcom/kotlinnlp/dependencytree/DependencyTree;)V", "reachableDependents", "", "", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "isDependentReachable", "", "Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;", "(Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;)Z", "apply", "", "transition", "copy", "cost", "calculateCost", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/transitions/ArcLeft;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/transitions/ArcRight;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/transitions/Root;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/transitions/Shift;", "removeUnreachableDependents", "Factory", "syntaxdecoder"})
public final class ArcEagerSpineOracle
extends Oracle<ArcEagerSpineState, ArcEagerSpineTransition> {
    @NotNull
    private final Oracle.Type type;
    private Set<Integer> reachableDependents;
    public static final Factory Factory = new Factory(null);

    @Override
    @NotNull
    public Oracle.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Oracle<ArcEagerSpineState, ArcEagerSpineTransition> copy() {
        ArcEagerSpineOracle clone = new ArcEagerSpineOracle(this.getGoldDependencyTree());
        clone.setLoss(this.getLoss());
        clone.reachableDependents.clear();
        clone.reachableDependents.addAll((Collection<Integer>)this.reachableDependents);
        return clone;
    }

    @Override
    public int cost(@NotNull ArcEagerSpineTransition transition) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        ArcEagerSpineTransition arcEagerSpineTransition = transition;
        if (arcEagerSpineTransition instanceof ArcLeft) {
            n = this.calculateCost((ArcLeft)transition);
        } else if (arcEagerSpineTransition instanceof ArcRight) {
            n = this.calculateCost((ArcRight)transition);
        } else if (arcEagerSpineTransition instanceof Shift) {
            n = this.calculateCost((Shift)transition);
        } else if (arcEagerSpineTransition instanceof Root) {
            n = this.calculateCost((Root)transition);
        } else {
            throw (Throwable)new RuntimeException("Transition not in list.");
        }
        return n;
    }

    @Override
    public void apply(@NotNull ArcEagerSpineTransition transition) {
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        ArcEagerSpineOracle arcEagerSpineOracle = this;
        arcEagerSpineOracle.setLoss(arcEagerSpineOracle.getLoss() + this.cost(transition));
        ArcEagerSpineTransition arcEagerSpineTransition = transition;
        if (arcEagerSpineTransition instanceof ArcLeft) {
            this.removeUnreachableDependents((ArcLeft)transition);
        } else if (arcEagerSpineTransition instanceof ArcRight) {
            this.removeUnreachableDependents((ArcRight)transition);
        } else if (arcEagerSpineTransition instanceof Shift) {
            this.removeUnreachableDependents((Shift)transition);
        } else if (arcEagerSpineTransition instanceof Root) {
            this.removeUnreachableDependents((Root)transition);
        } else {
            throw (Throwable)new RuntimeException("Transition not in list.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateCost(@NotNull ArcLeft $receiver) {
        int n;
        void $receiver$iv;
        int cost = 0;
        if (this.isDependentReachable($receiver) && !this.isArcCorrect($receiver)) {
            ++cost;
        }
        Iterable iterable = (Iterable)CollectionsKt.last((List)((ArcEagerSpineState)$receiver.getRefState()).getStack());
        int n2 = cost;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            int n3 = ((Number)element$iv).intValue();
            n = sum$iv;
            int n4 = CollectionsKt.intersect((Iterable)this.reachableDependents, (Iterable)this.getGoldDependencyTree().getRightDependents()[it]).size();
            sum$iv = n + n4;
        }
        n = sum$iv;
        cost = n2 + n;
        return cost;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateCost(@NotNull ArcRight $receiver) {
        int n;
        int cost = 0;
        if (this.isDependentReachable($receiver) && !this.isArcCorrect($receiver)) {
            ++cost;
        }
        int n2 = cost += CollectionsKt.intersect((Iterable)this.reachableDependents, (Iterable)this.getGoldDependencyTree().getLeftDependents()[$receiver.getDependentId()]).size();
        List list = ExtensionsKt.subListFrom((ArrayList)CollectionsKt.last((List)((ArcEagerSpineState)$receiver.getRefState()).getStack()), $receiver.getGovernorSpineIndex() + 1);
        if (list != null) {
            int n3;
            void $receiver$iv;
            Iterable iterable = list;
            int n4 = n2;
            int sum$iv = 0;
            for (Object element$iv : $receiver$iv) {
                void it;
                int n5 = ((Number)element$iv).intValue();
                n3 = sum$iv;
                int n6 = CollectionsKt.intersect((Iterable)this.reachableDependents, (Iterable)this.getGoldDependencyTree().getRightDependents()[it]).size();
                sum$iv = n3 + n6;
            }
            n3 = sum$iv;
            n2 = n4;
            n = n3;
        } else {
            n = 0;
        }
        cost = n2 + n;
        return cost;
    }

    private final int calculateCost(@NotNull Shift $receiver) {
        int cost = 0;
        int b0 = ((Number)CollectionsKt.first((List)((ArcEagerSpineState)$receiver.getRefState()).getBuffer())).intValue();
        if (this.reachableDependents.contains(b0) && this.getGoldDependencyTree().getHeads()[b0] != null) {
            Integer n = this.getGoldDependencyTree().getHeads()[b0];
            if (n == null) {
                Intrinsics.throwNpe();
            }
            if (n < b0) {
                ++cost;
            }
        }
        return cost += CollectionsKt.intersect((Iterable)this.reachableDependents, (Iterable)this.getGoldDependencyTree().getLeftDependents()[b0]).size();
    }

    private final int calculateCost(@NotNull Root $receiver) {
        return this.reachableDependents.size() > 1 ? 1 : 0;
    }

    private final void removeUnreachableDependents(@NotNull ArcLeft $receiver) {
        this.reachableDependents.remove($receiver.getDependentId());
        Iterable $receiver$iv = (Iterable)CollectionsKt.last((List)((ArcEagerSpineState)$receiver.getRefState()).getStack());
        for (Object element$iv : $receiver$iv) {
            int it = ((Number)element$iv).intValue();
            this.reachableDependents.removeAll(this.getGoldDependencyTree().getRightDependents()[it]);
        }
    }

    private final void removeUnreachableDependents(@NotNull ArcRight $receiver) {
        this.reachableDependents.remove($receiver.getDependentId());
        this.reachableDependents.removeAll(this.getGoldDependencyTree().getLeftDependents()[$receiver.getDependentId()]);
        List list = ExtensionsKt.subListFrom((ArrayList)CollectionsKt.last((List)((ArcEagerSpineState)$receiver.getRefState()).getStack()), $receiver.getGovernorSpineIndex() + 1);
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                int it = ((Number)element$iv).intValue();
                this.reachableDependents.removeAll(this.getGoldDependencyTree().getRightDependents()[it]);
            }
        }
    }

    private final void removeUnreachableDependents(@NotNull Shift $receiver) {
        int b0 = ((Number)CollectionsKt.first((List)((ArcEagerSpineState)$receiver.getRefState()).getBuffer())).intValue();
        if (this.getGoldDependencyTree().getHeads()[b0] != null) {
            Integer n = this.getGoldDependencyTree().getHeads()[b0];
            if (n == null) {
                Intrinsics.throwNpe();
            }
            if (n < b0) {
                this.reachableDependents.remove(b0);
            }
        }
        this.reachableDependents.removeAll(this.getGoldDependencyTree().getLeftDependents()[b0]);
    }

    private final void removeUnreachableDependents(@NotNull Root $receiver) {
        this.reachableDependents.remove($receiver.getDependentId());
    }

    private final boolean isDependentReachable(@NotNull SyntacticDependency $receiver) {
        return CollectionsKt.contains((Iterable)this.reachableDependents, (Object)$receiver.getDependentId());
    }

    public ArcEagerSpineOracle(@NotNull DependencyTree goldDependencyTree) {
        Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
        super(goldDependencyTree);
        this.type = Oracle.Type.DYNAMIC;
        this.reachableDependents = CollectionsKt.toMutableSet((Iterable)((Iterable)this.getGoldDependencyTree().getElements()));
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a8\u0006\t"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/ArcEagerSpineOracle$Factory;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/OracleFactory;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/ArcEagerSpineState;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arceagerspine/ArcEagerSpineTransition;", "()V", "invoke", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "syntaxdecoder"})
    public static final class Factory
    implements OracleFactory<ArcEagerSpineState, ArcEagerSpineTransition> {
        @Override
        @NotNull
        public Oracle<ArcEagerSpineState, ArcEagerSpineTransition> invoke(@NotNull DependencyTree goldDependencyTree) {
            Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
            return new ArcEagerSpineOracle(goldDependencyTree);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

