/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine;

import com.kotlinnlp.dependencytree.DependencyTree;
import com.kotlinnlp.syntaxdecoder.syntax.SyntacticDependency;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.ArcSpineState;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.ArcSpineTransition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.transitions.ArcLeft;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.transitions.ArcRight;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.transitions.Root;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.transitions.Shift;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.DependentsCounter;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.Oracle;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.OracleFactory;
import com.kotlinnlp.syntaxdecoder.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0018H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0019H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u001aH\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u001bH\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineOracle;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineState;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineTransition;", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "(Lcom/kotlinnlp/dependencytree/DependencyTree;)V", "dependentsCounter", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/DependentsCounter;", "getDependentsCounter", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/DependentsCounter;", "setDependentsCounter", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/DependentsCounter;)V", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "apply", "", "transition", "copy", "cost", "", "calculateCost", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/transitions/ArcLeft;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/transitions/ArcRight;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/transitions/Root;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/transitions/Shift;", "Factory", "syntaxdecoder"})
public class ArcSpineOracle
extends Oracle<ArcSpineState, ArcSpineTransition> {
    @NotNull
    private final Oracle.Type type;
    @NotNull
    private DependentsCounter dependentsCounter;
    public static final Factory Factory = new Factory(null);

    @Override
    @NotNull
    public Oracle.Type getType() {
        return this.type;
    }

    @NotNull
    protected final DependentsCounter getDependentsCounter() {
        return this.dependentsCounter;
    }

    protected final void setDependentsCounter(@NotNull DependentsCounter dependentsCounter) {
        Intrinsics.checkParameterIsNotNull((Object)dependentsCounter, (String)"<set-?>");
        this.dependentsCounter = dependentsCounter;
    }

    @Override
    @NotNull
    public Oracle<ArcSpineState, ArcSpineTransition> copy() {
        ArcSpineOracle clone = new ArcSpineOracle(this.getGoldDependencyTree());
        clone.setLoss(this.getLoss());
        clone.dependentsCounter = this.dependentsCounter.clone();
        return clone;
    }

    @Override
    public int cost(@NotNull ArcSpineTransition transition) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        ArcSpineTransition arcSpineTransition = transition;
        if (arcSpineTransition instanceof ArcLeft) {
            n = this.calculateCost((ArcLeft)transition);
        } else if (arcSpineTransition instanceof ArcRight) {
            n = this.calculateCost((ArcRight)transition);
        } else if (arcSpineTransition instanceof Shift) {
            n = this.calculateCost((Shift)transition);
        } else if (arcSpineTransition instanceof Root) {
            n = this.calculateCost((Root)transition);
        } else {
            throw (Throwable)new RuntimeException("Transition not in list.");
        }
        return n;
    }

    @Override
    public void apply(@NotNull ArcSpineTransition transition) {
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        if (transition instanceof SyntacticDependency && ((SyntacticDependency)((Object)transition)).getGovernorId() != null) {
            Integer n = ((SyntacticDependency)((Object)transition)).getGovernorId();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.dependentsCounter.decrease(n);
        }
    }

    private final int calculateCost(@NotNull ArcLeft $receiver) {
        return this.isArcCorrect($receiver) ? 0 : 1;
    }

    private final int calculateCost(@NotNull ArcRight $receiver) {
        return this.isArcCorrect($receiver) ? 0 : 1;
    }

    private final int calculateCost(@NotNull Root $receiver) {
        return this.getGoldDependencyTree().getHeads()[$receiver.getDependentId()] == null ? 0 : 1;
    }

    protected int calculateCost(@NotNull Shift $receiver) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (((ArcSpineState)$receiver.getRefState()).getStack().size() <= 1) {
            n = 0;
        } else {
            Integer s0h = this.getGoldDependencyTree().getHeads()[((ArcSpineState.StackElement)CollectionsKt.last((List)((ArcSpineState)$receiver.getRefState()).getStack())).getRoot()];
            Integer s1h = this.getGoldDependencyTree().getHeads()[ExtensionsKt.secondToLast(((ArcSpineState)$receiver.getRefState()).getStack()).getRoot()];
            ArrayList<Integer> s0ls = ((ArcSpineState.StackElement)CollectionsKt.last((List)((ArcSpineState)$receiver.getRefState()).getStack())).getLeftSpine();
            ArrayList<Integer> s1rs = ExtensionsKt.secondToLast(((ArcSpineState)$receiver.getRefState()).getStack()).getRightSpine();
            n = CollectionsKt.contains((Iterable)s0ls, (Object)s1h) || CollectionsKt.contains((Iterable)s1rs, (Object)s0h) ? 1 : 0;
        }
        return n;
    }

    public ArcSpineOracle(@NotNull DependencyTree goldDependencyTree) {
        Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
        super(goldDependencyTree);
        this.type = Oracle.Type.STATIC;
        this.dependentsCounter = DependentsCounter.Companion.invoke(this.getGoldDependencyTree());
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a8\u0006\t"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineOracle$Factory;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/OracleFactory;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineState;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineTransition;", "()V", "invoke", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "syntaxdecoder"})
    public static final class Factory
    implements OracleFactory<ArcSpineState, ArcSpineTransition> {
        @Override
        @NotNull
        public Oracle<ArcSpineState, ArcSpineTransition> invoke(@NotNull DependencyTree goldDependencyTree) {
            Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
            return new ArcSpineOracle(goldDependencyTree);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

