/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.transitions;

import com.kotlinnlp.syntaxdecoder.syntax.SyntacticDependency;
import com.kotlinnlp.syntaxdecoder.transitionsystem.Transition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.ArcSpineState;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcspine.ArcSpineTransition;
import com.kotlinnlp.syntaxdecoder.utils.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/transitions/ArcLeft;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineTransition;", "Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;", "refState", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineState;", "governorSpineIndex", "", "id", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcspine/ArcSpineState;II)V", "dependentId", "getDependentId", "()Ljava/lang/Integer;", "governorId", "getGovernorId", "getGovernorSpineIndex", "()I", "isAllowed", "", "()Z", "priority", "getPriority", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Type;", "perform", "", "state", "toString", "", "syntaxdecoder"})
public final class ArcLeft
extends ArcSpineTransition
implements SyntacticDependency {
    @NotNull
    private final Transition.Type type;
    private final int priority = 2;
    private final int governorSpineIndex;

    @Override
    @NotNull
    public Transition.Type getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Integer getGovernorId() {
        Integer n = ((ArcSpineState.StackElement)CollectionsKt.last((List)((ArcSpineState)this.getRefState()).getStack())).getLeftSpine().get(this.governorSpineIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"this.refState.stack.last\u2026[this.governorSpineIndex]");
        return n;
    }

    @Override
    @NotNull
    public Integer getDependentId() {
        return ExtensionsKt.secondToLast(((ArcSpineState)this.getRefState()).getStack()).getRoot();
    }

    @Override
    public boolean isAllowed() {
        return ((ArcSpineState)this.getRefState()).getStack().size() > 1 && ((ArcSpineState.StackElement)CollectionsKt.last((List)((ArcSpineState)this.getRefState()).getStack())).getLeftSpine().size() >= this.governorSpineIndex;
    }

    @Override
    protected void perform(@NotNull ArcSpineState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        ArcSpineState.StackElement s0 = ExtensionsKt.pop(state.getStack());
        ArcSpineState.StackElement s1 = ExtensionsKt.pop(state.getStack());
        state.getStack().add(s0.addToLeftSpine(this.governorSpineIndex, s1.getLeftSpine()));
    }

    @NotNull
    public String toString() {
        return "arc-left(" + this.governorSpineIndex + ')';
    }

    public final int getGovernorSpineIndex() {
        return this.governorSpineIndex;
    }

    public ArcLeft(@NotNull ArcSpineState refState, int governorSpineIndex, int id) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)refState, (String)"refState");
        super(refState, id);
        this.governorSpineIndex = governorSpineIndex;
        this.type = Transition.Type.ARC_LEFT;
        this.priority = 2;
        boolean bl2 = bl = this.governorSpineIndex >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

