/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcswift.transitions;

import com.kotlinnlp.dependencytree.DependencyTree;
import com.kotlinnlp.syntaxdecoder.syntax.SyntacticDependency;
import com.kotlinnlp.syntaxdecoder.transitionsystem.Transition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.arcswift.ArcSwiftTransition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.state.templates.StackBufferState;
import com.kotlinnlp.syntaxdecoder.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0014\u0010\u0015\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcswift/transitions/ArcRight;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/arcswift/ArcSwiftTransition;", "Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;", "refState", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/templates/StackBufferState;", "governorStackIndex", "", "id", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/templates/StackBufferState;II)V", "attachedElementsUntilK", "", "getAttachedElementsUntilK", "()Z", "dependentId", "getDependentId", "()Ljava/lang/Integer;", "governorId", "getGovernorId", "getGovernorStackIndex", "()I", "isAllowed", "priority", "getPriority", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Type;", "perform", "", "state", "toString", "", "syntaxdecoder"})
public final class ArcRight
extends ArcSwiftTransition
implements SyntacticDependency {
    @NotNull
    private final Transition.Type type;
    private final int priority = 2;
    private final int governorStackIndex;

    @Override
    @NotNull
    public Transition.Type getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public Integer getGovernorId() {
        Integer n = ((StackBufferState)this.getRefState()).getStack().get(this.governorStackIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"this.refState.stack[this.governorStackIndex]");
        return n;
    }

    @Override
    @NotNull
    public Integer getDependentId() {
        return (Integer)CollectionsKt.first((List)((StackBufferState)this.getRefState()).getBuffer());
    }

    @Override
    public boolean isAllowed() {
        Collection collection = ((StackBufferState)this.getRefState()).getBuffer();
        return !collection.isEmpty() && this.governorStackIndex <= CollectionsKt.getLastIndex((List)((StackBufferState)this.getRefState()).getStack()) && (this.governorStackIndex == 0 || this.getAttachedElementsUntilK());
    }

    private final boolean getAttachedElementsUntilK() {
        boolean bl;
        block3: {
            Iterable $receiver$iv = ((StackBufferState)this.getRefState()).getStack().subList(0, this.governorStackIndex - 1);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Integer it = (Integer)element$iv;
                    DependencyTree dependencyTree = ((StackBufferState)this.getRefState()).getDependencyTree();
                    Integer n = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                    if (dependencyTree.isAssigned(n.intValue())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected void perform(@NotNull StackBufferState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        int n = this.governorStackIndex;
        state.setStack(new ArrayList<Integer>(CollectionsKt.slice((List)state.getStack(), (IntRange)new IntRange(n, CollectionsKt.getLastIndex((List)state.getStack())))));
        state.getStack().add(0, ExtensionsKt.removeFirst(state.getBuffer()));
    }

    @NotNull
    public String toString() {
        return "arc-right(" + this.governorStackIndex + ')';
    }

    public final int getGovernorStackIndex() {
        return this.governorStackIndex;
    }

    public ArcRight(@NotNull StackBufferState refState, int governorStackIndex, int id) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)refState, (String)"refState");
        super(refState, id);
        this.governorStackIndex = governorStackIndex;
        this.type = Transition.Type.ARC_RIGHT;
        this.priority = 2;
        boolean bl2 = bl = this.governorStackIndex >= 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

