/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.models.easyfirst;

import com.kotlinnlp.dependencytree.DependencyTree;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.easyfirst.EasyFirstTransition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.easyfirst.transitions.ArcLeft;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.easyfirst.transitions.ArcRight;
import com.kotlinnlp.syntaxdecoder.transitionsystem.models.easyfirst.transitions.Root;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.DependentsCounter;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.Oracle;
import com.kotlinnlp.syntaxdecoder.transitionsystem.oracle.OracleFactory;
import com.kotlinnlp.syntaxdecoder.transitionsystem.state.templates.PendingListState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0014H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0015H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0016H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/EasyFirstOracle;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/templates/PendingListState;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/EasyFirstTransition;", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "(Lcom/kotlinnlp/dependencytree/DependencyTree;)V", "dependentsCounter", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/DependentsCounter;", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "apply", "", "transition", "copy", "cost", "", "calculateCost", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/transitions/ArcLeft;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/transitions/ArcRight;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/transitions/Root;", "Factory", "syntaxdecoder"})
public final class EasyFirstOracle
extends Oracle<PendingListState, EasyFirstTransition> {
    @NotNull
    private final Oracle.Type type;
    private DependentsCounter dependentsCounter;
    public static final Factory Factory = new Factory(null);

    @Override
    @NotNull
    public Oracle.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Oracle<PendingListState, EasyFirstTransition> copy() {
        EasyFirstOracle clone = new EasyFirstOracle(this.getGoldDependencyTree());
        clone.setLoss(this.getLoss());
        clone.dependentsCounter = this.dependentsCounter.clone();
        return clone;
    }

    @Override
    public int cost(@NotNull EasyFirstTransition transition) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        EasyFirstTransition easyFirstTransition = transition;
        if (easyFirstTransition instanceof ArcLeft) {
            n = this.calculateCost((ArcLeft)transition);
        } else if (easyFirstTransition instanceof ArcRight) {
            n = this.calculateCost((ArcRight)transition);
        } else if (easyFirstTransition instanceof Root) {
            n = this.calculateCost((Root)transition);
        } else {
            throw (Throwable)new RuntimeException("Transition not in list.");
        }
        return n;
    }

    @Override
    public void apply(@NotNull EasyFirstTransition transition) {
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        if (transition.getGovernorId() != null) {
            Integer n = transition.getGovernorId();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.dependentsCounter.decrease(n);
        }
    }

    private final int calculateCost(@NotNull ArcLeft $receiver) {
        return this.isArcCorrect($receiver) && this.dependentsCounter.isResolved($receiver.getDependentId()) ? 0 : 1;
    }

    private final int calculateCost(@NotNull ArcRight $receiver) {
        return this.isArcCorrect($receiver) && this.dependentsCounter.isResolved($receiver.getDependentId()) ? 0 : 1;
    }

    private final int calculateCost(@NotNull Root $receiver) {
        return this.getGoldDependencyTree().getHeads()[$receiver.getDependentId()] == null ? 0 : 1;
    }

    public EasyFirstOracle(@NotNull DependencyTree goldDependencyTree) {
        Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
        super(goldDependencyTree);
        this.type = Oracle.Type.STATIC;
        this.dependentsCounter = DependentsCounter.Companion.invoke(this.getGoldDependencyTree());
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002\u00a8\u0006\t"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/EasyFirstOracle$Factory;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/OracleFactory;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/templates/PendingListState;", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/models/easyfirst/EasyFirstTransition;", "()V", "invoke", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "syntaxdecoder"})
    public static final class Factory
    implements OracleFactory<PendingListState, EasyFirstTransition> {
        @Override
        @NotNull
        public Oracle<PendingListState, EasyFirstTransition> invoke(@NotNull DependencyTree goldDependencyTree) {
            Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
            return new EasyFirstOracle(goldDependencyTree);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

