/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.transitionsystem.oracle;

import com.kotlinnlp.dependencytree.DependencyTree;
import com.kotlinnlp.dependencytree.Deprel;
import com.kotlinnlp.dependencytree.POSTag;
import com.kotlinnlp.syntaxdecoder.syntax.DependencyRelation;
import com.kotlinnlp.syntaxdecoder.syntax.SyntacticDependency;
import com.kotlinnlp.syntaxdecoder.transitionsystem.Transition;
import com.kotlinnlp.syntaxdecoder.transitionsystem.state.State;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u00010B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H&J\u0015\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0013\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010&J\u001e\u0010%\u001a\u00020\u00162\u0016\u0010'\u001a\u00120(R\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0004J\u001d\u0010\u0015\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010&J\u001e\u0010,\u001a\u00020\u00162\u0016\u0010'\u001a\u00120(R\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0004J\f\u0010,\u001a\u00020\u0016*\u00020-H\u0002J\f\u0010.\u001a\u00020\u0016*\u00020-H\u0002J\f\u0010/\u001a\u00020\u0016*\u00020-H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018\u00a8\u00061"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle;", "StateType", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/state/State;", "TransitionType", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition;", "", "goldDependencyTree", "Lcom/kotlinnlp/dependencytree/DependencyTree;", "(Lcom/kotlinnlp/dependencytree/DependencyTree;)V", "getGoldDependencyTree", "()Lcom/kotlinnlp/dependencytree/DependencyTree;", "loss", "", "getLoss", "()I", "setLoss", "(I)V", "type", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "getType", "()Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "isArcCorrect", "", "Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;", "(Lcom/kotlinnlp/syntaxdecoder/syntax/SyntacticDependency;)Z", "apply", "", "transition", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition;)V", "copy", "cost", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition;)I", "getGoldDeprel", "Lcom/kotlinnlp/dependencytree/Deprel;", "dependent", "getGoldPosTag", "Lcom/kotlinnlp/dependencytree/POSTag;", "hasZeroCost", "(Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition;)Z", "action", "Lcom/kotlinnlp/syntaxdecoder/transitionsystem/Transition$Action;", "dependentId", "governorId", "(ILjava/lang/Integer;)Z", "isCorrect", "Lcom/kotlinnlp/syntaxdecoder/syntax/DependencyRelation;", "isDeprelCorrect", "isPosTagCorrect", "Type", "syntaxdecoder"})
public abstract class Oracle<StateType extends State<StateType>, TransitionType extends Transition<TransitionType, StateType>> {
    private int loss;
    @NotNull
    private final DependencyTree goldDependencyTree;

    @NotNull
    public abstract Type getType();

    public final int getLoss() {
        return this.loss;
    }

    public final void setLoss(int n) {
        this.loss = n;
    }

    public abstract int cost(@NotNull TransitionType var1);

    public abstract void apply(@NotNull TransitionType var1);

    @NotNull
    public abstract Oracle<StateType, TransitionType> copy();

    public final boolean hasZeroCost(@NotNull TransitionType transition) {
        Intrinsics.checkParameterIsNotNull(transition, (String)"transition");
        return this.cost(transition) == 0;
    }

    public final boolean hasZeroCost(@NotNull Transition.Action action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        return this.hasZeroCost(action.getTransition());
    }

    public final boolean isCorrect(@NotNull TransitionType transition) {
        Intrinsics.checkParameterIsNotNull(transition, (String)"transition");
        return this.hasZeroCost(transition) && (!(transition instanceof SyntacticDependency) || this.isArcCorrect((SyntacticDependency)transition));
    }

    public final boolean isCorrect(@NotNull Transition.Action action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        return ((Transition)action.getTransition()).isAllowed() && this.isCorrect(action.getTransition()) && (!(action instanceof DependencyRelation) || this.isCorrect((DependencyRelation)((Object)action)));
    }

    public final boolean isArcCorrect(int dependentId, @Nullable Integer governorId) {
        return Intrinsics.areEqual((Object)this.goldDependencyTree.getHeads()[dependentId], (Object)governorId);
    }

    public final boolean isArcCorrect(@NotNull SyntacticDependency $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Integer n = $receiver.getDependentId();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return this.isArcCorrect(n, $receiver.getGovernorId());
    }

    private final boolean isCorrect(@NotNull DependencyRelation $receiver) {
        return this.isDeprelCorrect($receiver) && this.isPosTagCorrect($receiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDeprelCorrect(@NotNull DependencyRelation $receiver) {
        if ($receiver.getDeprel() == null) return true;
        Deprel deprel = $receiver.getDeprel();
        Integer n = $receiver.getDependentId();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        if (!Intrinsics.areEqual((Object)deprel, (Object)this.getGoldDeprel(n))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPosTagCorrect(@NotNull DependencyRelation $receiver) {
        if ($receiver.getPosTag() == null) return true;
        POSTag pOSTag = $receiver.getPosTag();
        Integer n = $receiver.getDependentId();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        if (!Intrinsics.areEqual((Object)pOSTag, (Object)this.getGoldPosTag(n))) return false;
        return true;
    }

    private final Deprel getGoldDeprel(int dependent) {
        return this.goldDependencyTree.getDeprels()[dependent];
    }

    private final POSTag getGoldPosTag(int dependent) {
        return this.goldDependencyTree.getPosTags()[dependent];
    }

    @NotNull
    public final DependencyTree getGoldDependencyTree() {
        return this.goldDependencyTree;
    }

    public Oracle(@NotNull DependencyTree goldDependencyTree) {
        Intrinsics.checkParameterIsNotNull((Object)goldDependencyTree, (String)"goldDependencyTree");
        this.goldDependencyTree = goldDependencyTree;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/kotlinnlp/syntaxdecoder/transitionsystem/oracle/Oracle$Type;", "", "(Ljava/lang/String;I)V", "STATIC", "NON_DETERMINISTIC", "DYNAMIC", "syntaxdecoder"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STATIC;
        public static final /* enum */ Type NON_DETERMINISTIC;
        public static final /* enum */ Type DYNAMIC;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = STATIC = new Type();
            typeArray[1] = NON_DETERMINISTIC = new Type();
            typeArray[2] = DYNAMIC = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

