/*
 * Decompiled with CFR 0.152.
 */
package com.kotlinnlp.syntaxdecoder.utils;

import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H$J\u000b\u0010\u0018\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0013\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00028\u0000X\u0084.\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u00028\u0001X\u0084.\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/kotlinnlp/syntaxdecoder/utils/DaemonThread;", "InputType", "", "OutputType", "Ljava/lang/Thread;", "debug", "", "(Z)V", "inputValue", "getInputValue", "()Ljava/lang/Object;", "setInputValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "outputValue", "getOutputValue", "setOutputValue", "processSem", "Ljava/util/concurrent/Semaphore;", "readSem", "writeSem", "process", "", "processInput", "read", "run", "write", "value", "syntaxdecoder"})
public abstract class DaemonThread<InputType, OutputType>
extends Thread {
    private final Semaphore readSem;
    private final Semaphore writeSem;
    private final Semaphore processSem;
    @NotNull
    protected InputType inputValue;
    @NotNull
    protected OutputType outputValue;
    private final boolean debug;

    @NotNull
    protected final InputType getInputValue() {
        InputType InputType = this.inputValue;
        if (InputType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputValue");
        }
        return InputType;
    }

    protected final void setInputValue(@NotNull InputType InputType) {
        Intrinsics.checkParameterIsNotNull(InputType, (String)"<set-?>");
        this.inputValue = InputType;
    }

    @NotNull
    protected final OutputType getOutputValue() {
        OutputType OutputType = this.outputValue;
        if (OutputType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputValue");
        }
        return OutputType;
    }

    protected final void setOutputValue(@NotNull OutputType OutputType) {
        Intrinsics.checkParameterIsNotNull(OutputType, (String)"<set-?>");
        this.outputValue = OutputType;
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.process();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    @NotNull
    public final OutputType read() {
        if (this.debug) {
            String string = "" + this.getId() + ": Waiting for reading output";
            System.out.println((Object)string);
        }
        this.readSem.acquire();
        OutputType OutputType = this.outputValue;
        if (OutputType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputValue");
        }
        OutputType ret = OutputType;
        if (this.debug) {
            String string = "" + this.getId() + ": Output read, release input writing";
            System.out.println((Object)string);
        }
        this.writeSem.release();
        return ret;
    }

    public final void write(@NotNull InputType value) {
        String string;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        if (this.debug) {
            string = "" + this.getId() + ": Waiting for writing input";
            System.out.println((Object)string);
        }
        this.writeSem.acquire();
        this.inputValue = value;
        if (this.debug) {
            string = "" + this.getId() + ": Input written, release processing";
            System.out.println((Object)string);
        }
        this.processSem.release();
    }

    private final void process() {
        String string;
        if (this.debug) {
            string = "" + this.getId() + ": Waiting for processing";
            System.out.println((Object)string);
        }
        this.processSem.acquire();
        this.processInput();
        if (this.debug) {
            string = "" + this.getId() + ": Data processed, release output reading";
            System.out.println((Object)string);
        }
        this.readSem.release();
    }

    protected abstract void processInput();

    public DaemonThread(boolean debug) {
        this.debug = debug;
        this.readSem = new Semaphore(1);
        this.writeSem = new Semaphore(1);
        this.processSem = new Semaphore(1);
        this.readSem.acquire();
        this.processSem.acquire();
    }

    public /* synthetic */ DaemonThread(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public DaemonThread() {
        this(false, 1, null);
    }
}

