/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.function.Predicate;

public class PredicateHandler
implements HttpHandler {
    private final HttpHandler T;
    private final HttpHandler F;
    private final Predicate<HttpExchange> predicate;

    public PredicateHandler(HttpHandler trueHandler, HttpHandler falseHandler, Predicate<HttpExchange> predicate) {
        this.T = trueHandler;
        this.F = falseHandler;
        this.predicate = predicate;
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        (this.predicate.test(exchange) ? this.T : this.F).handle(exchange);
    }

    public String toString() {
        return "PredicateHandler{(true) handler=" + this.T.toString() + ", (false) handler=" + this.F.toString() + ", predicate=" + this.predicate.toString() + "}";
    }
}

