/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import java.util.regex.Pattern;

public abstract class ContextUtil {
    private static final Pattern forwardSlashRegex = Pattern.compile("/{2,}|\\\\+");
    private static final Pattern stripSlashRegex = Pattern.compile("^\\s*/*|/*\\s*$");

    public static String getContext(String context, boolean leadingSlash, boolean trailingSlash) {
        String linSlash = forwardSlashRegex.matcher(context).replaceAll("/");
        String strippedSlash = stripSlashRegex.matcher(linSlash).replaceAll("");
        return strippedSlash.length() == 0 ? (leadingSlash || trailingSlash ? "/" : "") : (leadingSlash ? "/" : "") + strippedSlash + (trailingSlash ? "/" : "");
    }

    public static String joinContexts(boolean leadingSlash, boolean trailingSlash, String ... contexts) {
        StringBuilder OUT = new StringBuilder();
        for (String context : contexts) {
            OUT.append(ContextUtil.getContext(context, true, false));
        }
        return ContextUtil.getContext(OUT.toString(), leadingSlash, trailingSlash);
    }
}

