/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.HttpSession;
import com.kttdevelopment.simplehttpserver.HttpSessionHandler;
import com.kttdevelopment.simplehttpserver.handler.ConnectionThrottler;
import com.sun.net.httpserver.HttpExchange;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerSessionThrottler
extends ConnectionThrottler {
    private final HttpSessionHandler sessionHandler;
    private final Map<HttpSession, AtomicInteger> connections = new ConcurrentHashMap<HttpSession, AtomicInteger>();
    private final AtomicInteger uConn = new AtomicInteger(0);
    private final AtomicInteger uConnMax = new AtomicInteger(-1);

    public ServerSessionThrottler(HttpSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public ServerSessionThrottler(HttpSessionHandler sessionHandler, int maxConnections) {
        this.sessionHandler = sessionHandler;
        this.uConnMax.set(maxConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean addConnection(HttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        int maxConn = this.getMaxConnections(session, exchange);
        if (!this.connections.containsKey(session)) {
            this.connections.put(session, new AtomicInteger(0));
        }
        AtomicInteger conn = this.connections.get(session);
        boolean exempt = this.canIgnoreConnectionLimit(session, exchange);
        if (maxConn < 0) {
            if (!exempt) {
                ServerSessionThrottler serverSessionThrottler = this;
                synchronized (serverSessionThrottler) {
                    int uMax = this.uConnMax.get();
                    if (uMax < 0 || this.uConn.get() < uMax) {
                        conn.incrementAndGet();
                        this.uConn.incrementAndGet();
                        return true;
                    }
                    return false;
                }
            }
            conn.incrementAndGet();
            return true;
        }
        if (!exempt) {
            ServerSessionThrottler serverSessionThrottler = this;
            synchronized (serverSessionThrottler) {
                int umax = this.uConnMax.get();
                if (conn.get() < maxConn && (umax < 0 || this.uConn.get() < umax)) {
                    conn.incrementAndGet();
                    this.uConn.incrementAndGet();
                    return true;
                }
                return false;
            }
        }
        AtomicBoolean added = new AtomicBoolean(false);
        conn.updateAndGet(operand -> {
            if (operand < maxConn) {
                added.set(true);
            }
            return operand < maxConn ? operand + 1 : operand;
        });
        return added.get();
    }

    @Override
    final void deleteConnection(HttpExchange exchange) {
        HttpSession session = this.sessionHandler.getSession(exchange);
        if (this.connections.containsKey(session)) {
            this.connections.get(session).decrementAndGet();
            if (!this.canIgnoreConnectionLimit(session, exchange)) {
                this.uConn.decrementAndGet();
            }
        }
    }

    @Override
    public final int getMaxConnections(HttpExchange exchange) {
        return this.getMaxConnections(this.sessionHandler.getSession(exchange), exchange);
    }

    public int getMaxConnections(HttpSession session, HttpExchange exchange) {
        return -1;
    }

    public boolean canIgnoreConnectionLimit(HttpSession session, HttpExchange exchange) {
        return false;
    }

    public final synchronized void setMaxServerConnections(int connections) {
        this.uConnMax.set(connections);
    }

    public final synchronized int getMaxServerConnections() {
        return this.uConnMax.get();
    }

    public String toString() {
        return "ServerSessionThrottler{sessionHandler=" + this.sessionHandler + ", connections=" + this.connections.toString() + ", userConnections=" + this.uConn + ", userConnectionsMax=" + this.uConnMax + "}";
    }
}

