/*
 * Decompiled with CFR 0.152.
 */
package com.kursaha.engagedatadrive.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.kursaha.Credentials;
import com.kursaha.common.ErrorMessageDto;
import com.kursaha.engagedatadrive.client.EngageDataDriveClient;
import com.kursaha.engagedatadrive.client.EngageDataDriveService;
import com.kursaha.engagedatadrive.dto.CustomerDto;
import com.kursaha.engagedatadrive.dto.CustomerPartialUpdateDto;
import com.kursaha.engagedatadrive.dto.EventFlowRequestDto;
import com.kursaha.engagedatadrive.dto.SdkPingResponse;
import com.kursaha.engagedatadrive.dto.SignalFcmNotificationPayload;
import com.kursaha.engagedatadrive.dto.SignalInteraktWhatsappPayload;
import com.kursaha.engagedatadrive.dto.SignalMailPayload;
import com.kursaha.engagedatadrive.dto.SignalMessagePayload;
import com.kursaha.engagedatadrive.dto.StartEventPayload;
import java.io.IOException;
import java.io.Reader;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class EngageDataDriveClientImpl
implements EngageDataDriveClient {
    private static final int MAX_BATCH_SIZE = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(EngageDataDriveClientImpl.class);
    private final String apiKey;
    private final EngageDataDriveService service;
    private final Gson gson;
    private final Object syncObj = new Object();
    private final ConcurrentLinkedQueue<EventFlowRequestDto.SignalPayload> signalHolder;
    private volatile boolean processingMessages;

    public EngageDataDriveClientImpl(Credentials credentials, Gson gson, String baseUrl, OkHttpClient okHttpClient) {
        this.apiKey = credentials.getApiKey();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        this.service = (EngageDataDriveService)retrofit.create(EngageDataDriveService.class);
        this.gson = gson;
        this.signalHolder = new ConcurrentLinkedQueue();
        Thread consumerThread = new Thread(() -> {
            while (true) {
                Object signals;
                if (!this.signalHolder.isEmpty()) {
                    this.processingMessages = true;
                    signals = new LinkedList();
                    int i = 0;
                    while (!this.signalHolder.isEmpty() && ++i < 500) {
                        EventFlowRequestDto.SignalPayload signal = this.signalHolder.poll();
                        if (signal == null) continue;
                        signals.add(signal);
                    }
                    if (signals.size() <= 0) continue;
                    this.sendEventFlow((List<EventFlowRequestDto.SignalPayload>)signals);
                    continue;
                }
                this.processingMessages = false;
                try {
                    signals = this.syncObj;
                    synchronized (signals) {
                        this.syncObj.wait(3000L);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.info("got interrupt in wait");
                    continue;
                }
                break;
            }
        });
        consumerThread.start();
    }

    private void signalInternal(String stepNodeId, String emitterId, Map<String, Object> extraFields, JsonObject data, UUID identifier, Map<String, Map<String, Instant>> dynamicSleepNode) {
        if ((emitterId = emitterId.trim()).split(" ").length > 1) {
            throw new RuntimeException("emitter id should not have any space");
        }
        for (Map.Entry<String, Object> extra : extraFields.entrySet()) {
            if (extra.getValue() instanceof String) {
                data.addProperty(extra.getKey(), (String)extra.getValue());
                continue;
            }
            if (extra.getValue() instanceof Number) {
                data.addProperty(extra.getKey(), (Number)extra.getValue());
                continue;
            }
            if (extra.getValue() instanceof Boolean) {
                data.addProperty(extra.getKey(), (Boolean)extra.getValue());
                continue;
            }
            LOGGER.error("extra-field {} datatype not supported", extra);
        }
        dynamicSleepNode.forEach((sleepNodeId, time) -> {
            JsonObject jsonObject = new JsonObject();
            time.forEach((key, value) -> jsonObject.addProperty(key, value.toString()));
            data.add(sleepNodeId, (JsonElement)jsonObject);
        });
        EventFlowRequestDto.SignalPayload signalPayload = new EventFlowRequestDto.SignalPayload(emitterId, stepNodeId, data, identifier.toString());
        this.sendEventFlow(signalPayload);
    }

    @Override
    public void signal(UUID eventflowIdentifier, String stepNodeId, String emitterId) {
        EventFlowRequestDto.SignalPayload signalPayload = new EventFlowRequestDto.SignalPayload(emitterId, stepNodeId, null, eventflowIdentifier.toString());
        this.sendEventFlow(signalPayload);
    }

    @Override
    public void signal(UUID identifier, String stepNodeId, String emitterId, StartEventPayload payload) {
        JsonObject data = new JsonObject();
        if (payload.getEmail() == null || payload.getEmail().isBlank()) {
            data.addProperty("email", payload.getEmail());
        }
        if (payload.getPhoneNumber() == null || payload.getPhoneNumber().isBlank()) {
            data.addProperty("phone_number", payload.getPhoneNumber());
        }
        this.signalInternal(stepNodeId, emitterId, payload.getExtraFields(), data, identifier, payload.getDynamicSleepNode());
    }

    @Override
    public void signal(UUID identifier, String stepNodeId, String emitterId, SignalMessagePayload payload) {
        JsonObject data = new JsonObject();
        if (payload.getPhoneNumber() == null || payload.getPhoneNumber().isBlank()) {
            throw new RuntimeException("phone number is missing");
        }
        data.addProperty("phone_number", payload.getPhoneNumber());
        this.signalInternal(stepNodeId, emitterId, payload.getExtraFields(), data, identifier, payload.getDynamicSleepNode());
    }

    @Override
    public void signal(UUID identifier, String stepNodeId, String emitterId, SignalFcmNotificationPayload payload) {
        JsonObject data = payload.getAsJsonObject();
        this.signalInternal(stepNodeId, emitterId, payload.getExtraFields(), data, identifier, payload.getDynamicSleepNode());
    }

    @Override
    public void signal(UUID identifier, String stepNodeId, String emitterId, SignalInteraktWhatsappPayload payload) {
        JsonObject data = new JsonObject();
        if (payload.getPhoneNumber() == null || payload.getPhoneNumber().isBlank()) {
            throw new RuntimeException("Phone Number is missing");
        }
        if (payload.getCountryCode() == null || payload.getCountryCode().isBlank()) {
            throw new RuntimeException("Country code is missing");
        }
        data.addProperty("countryCode", payload.getCountryCode());
        data.addProperty("phoneNumber", payload.getPhoneNumber());
        if (payload.getBodyValues() != null) {
            data.add("bodyValues", (JsonElement)new JsonParser().parse(this.gson.toJson(payload.getBodyValues())).getAsJsonArray());
        }
        if (payload.getHeaderValues() != null) {
            data.add("headerValues", (JsonElement)new JsonParser().parse(this.gson.toJson(payload.getHeaderValues())).getAsJsonArray());
        }
        this.signalInternal(stepNodeId, emitterId, payload.getExtraFields(), data, identifier, payload.getDynamicSleepNode());
    }

    @Override
    public void signal(UUID identifier, String stepNodeId, String emitterId, SignalMailPayload payload) {
        JsonObject data = new JsonObject();
        if (payload.getEmail() == null || payload.getEmail().isBlank()) {
            throw new RuntimeException("email is missing");
        }
        data.addProperty("email", payload.getEmail());
        this.signalInternal(stepNodeId, emitterId, payload.getExtraFields(), data, identifier, payload.getDynamicSleepNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventFlow(EventFlowRequestDto.SignalPayload signals) {
        this.signalHolder.add(signals);
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.notify();
        }
    }

    private void sendEventFlow(List<EventFlowRequestDto.SignalPayload> signals) {
        LOGGER.info("Sending signal for {}", (Object)signals.size());
        UUID requestIdentifier = UUID.randomUUID();
        EventFlowRequestDto requestDto = new EventFlowRequestDto(requestIdentifier.toString(), signals);
        Call<Void> repos = this.selectApi(requestDto);
        repos.enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (!response.isSuccessful()) {
                    String responseAsString = null;
                    try {
                        int ch;
                        StringBuilder sb = new StringBuilder();
                        while ((ch = response.errorBody().charStream().read()) != -1) {
                            sb.append((char)ch);
                        }
                        responseAsString = sb.toString();
                        ErrorMessageDto errorResponse = (ErrorMessageDto)EngageDataDriveClientImpl.this.gson.fromJson(responseAsString, ErrorMessageDto.class);
                        LOGGER.error("Failed to execute request {}", (Object)errorResponse);
                    }
                    catch (JsonSyntaxException jse) {
                        if (responseAsString != null) {
                            LOGGER.error("Failed to execute request {}", responseAsString);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to execute request {}", (Object)ex.getMessage());
                    }
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
                LOGGER.error("Failed to execute request {}", (Object)t.getMessage());
            }
        });
    }

    private Call<Void> selectApi(EventFlowRequestDto eventFlowRequestDto) {
        return this.service.sendEventByIdentifier("Bearer " + this.apiKey, eventFlowRequestDto);
    }

    @Override
    public boolean hasSignals() {
        return !this.signalHolder.isEmpty() || this.processingMessages;
    }

    @Override
    public boolean isConnectedAndAuthenticated() throws IOException {
        return Objects.equals(Objects.requireNonNull((SdkPingResponse)this.service.ping("Bearer " + this.apiKey).execute().body()).getResponse(), "pong");
    }

    @Override
    public void sendCustomerData(String customerId, CustomerDto customerDto) throws IOException {
        if (customerId == null || customerId.isBlank()) {
            throw new IllegalArgumentException("Customer id can't be null or blank");
        }
        if (!customerDto.getEmail().matches("^[A-Za-z0-9+_.-]+@(.+)$")) {
            throw new IllegalArgumentException("Given format of email is incorrect.");
        }
        if (customerDto.getDob() != null && this.isValidIso8601DateTime(customerDto.getDob())) {
            throw new IllegalArgumentException("Not an valid ISO-8601 date format");
        }
        CustomerPartialUpdateDto dto = new CustomerPartialUpdateDto(customerId, customerDto);
        Call<Void> repos = this.service.sendCustomerData("Bearer " + this.apiKey, dto);
        Response response = repos.execute();
        if (!response.isSuccessful()) {
            try {
                ResponseBody responseBody = response.errorBody();
                if (responseBody == null) {
                    throw new IOException("Error Response body is null");
                }
                Reader reader = responseBody.charStream();
                ErrorMessageDto errorMessageDto = (ErrorMessageDto)this.gson.fromJson(reader, ErrorMessageDto.class);
                LOGGER.error("failed to execute request : {}", (Object)errorMessageDto);
                throw new IOException("Failed to execute request. " + errorMessageDto);
            }
            catch (JsonIOException | JsonSyntaxException je) {
                throw new RuntimeException(je);
            }
        }
    }

    private boolean isValidIso8601DateTime(String dateTimeString) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        try {
            formatter.parse(dateTimeString);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }
}

