/*
 * Decompiled with CFR 0.152.
 */
package com.kursaha.engagedatadrive.dto;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public abstract class EventPayload {
    private final Map<String, Object> extraFields = new HashMap<String, Object>();
    private final Map<String, Map<String, Instant>> dynamicSleepNode = new HashMap<String, Map<String, Instant>>();

    EventPayload() {
    }

    public void addProperty(String key, String value) {
        this.extraFields.put(key, value);
    }

    public void addProperty(String key, Number value) {
        this.extraFields.put(key, value);
    }

    public void addProperty(String key, Boolean value) {
        this.extraFields.put(key, value);
    }

    public void addBeforeEventDateTime(String sleepNodeId, Instant beforeTime) {
        HashMap<String, Instant> before = new HashMap<String, Instant>();
        before.put("beforeEventDateTime", beforeTime);
        this.dynamicSleepNode.put(sleepNodeId, before);
    }

    public void addAfterEventDateTime(String sleepNodeId, Instant afterTime) {
        HashMap<String, Instant> after = new HashMap<String, Instant>();
        after.put("afterEventDateTime", afterTime);
        this.dynamicSleepNode.put(sleepNodeId, after);
    }

    public Map<String, Object> getExtraFields() {
        return this.extraFields;
    }

    public Map<String, Map<String, Instant>> getDynamicSleepNode() {
        return this.dynamicSleepNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventPayload)) {
            return false;
        }
        EventPayload other = (EventPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$extraFields = this.getExtraFields();
        Map<String, Object> other$extraFields = other.getExtraFields();
        if (this$extraFields == null ? other$extraFields != null : !((Object)this$extraFields).equals(other$extraFields)) {
            return false;
        }
        Map<String, Map<String, Instant>> this$dynamicSleepNode = this.getDynamicSleepNode();
        Map<String, Map<String, Instant>> other$dynamicSleepNode = other.getDynamicSleepNode();
        return !(this$dynamicSleepNode == null ? other$dynamicSleepNode != null : !((Object)this$dynamicSleepNode).equals(other$dynamicSleepNode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $extraFields = this.getExtraFields();
        result = result * 59 + ($extraFields == null ? 43 : ((Object)$extraFields).hashCode());
        Map<String, Map<String, Instant>> $dynamicSleepNode = this.getDynamicSleepNode();
        result = result * 59 + ($dynamicSleepNode == null ? 43 : ((Object)$dynamicSleepNode).hashCode());
        return result;
    }

    public String toString() {
        return "EventPayload(extraFields=" + this.getExtraFields() + ", dynamicSleepNode=" + this.getDynamicSleepNode() + ")";
    }
}

