/*
 * Decompiled with CFR 0.152.
 */
package com.kursaha.engagedatadrive.dto;

import com.google.gson.JsonObject;
import com.kursaha.engagedatadrive.dto.EventPayload;
import com.kursaha.engagedatadrive.dto.enumeration.FcmTokenType;
import lombok.NonNull;

public class SignalFcmNotificationPayload
extends EventPayload {
    @NonNull
    private final String token;
    @NonNull
    private final FcmTokenType fcmTokenType;
    private final JsonObject data;

    public SignalFcmNotificationPayload(@NonNull String token, @NonNull FcmTokenType fcmTokenType) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (fcmTokenType == null) {
            throw new NullPointerException("fcmTokenType is marked non-null but is null");
        }
        this.token = token;
        this.fcmTokenType = fcmTokenType;
        this.data = new JsonObject();
    }

    public JsonObject getAsJsonObject() {
        switch (this.fcmTokenType) {
            case WEB_TOKEN: {
                this.data.addProperty("web_token", this.token);
                break;
            }
            case ANDROID_TOKEN: {
                this.data.addProperty("android_token", this.token);
                break;
            }
            case APNS_TOKEN: {
                this.data.addProperty("apns_token", this.token);
                break;
            }
            default: {
                throw new RuntimeException("fcm token type " + this.fcmTokenType + " not supported");
            }
        }
        return this.data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignalFcmNotificationPayload)) {
            return false;
        }
        SignalFcmNotificationPayload other = (SignalFcmNotificationPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$token = this.token;
        String other$token = other.token;
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        FcmTokenType this$fcmTokenType = this.fcmTokenType;
        FcmTokenType other$fcmTokenType = other.fcmTokenType;
        if (this$fcmTokenType == null ? other$fcmTokenType != null : !((Object)((Object)this$fcmTokenType)).equals((Object)other$fcmTokenType)) {
            return false;
        }
        JsonObject this$data = this.data;
        JsonObject other$data = other.data;
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SignalFcmNotificationPayload;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        FcmTokenType $fcmTokenType = this.fcmTokenType;
        result = result * 59 + ($fcmTokenType == null ? 43 : ((Object)((Object)$fcmTokenType)).hashCode());
        JsonObject $data = this.data;
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

