/*
 * Decompiled with CFR 0.152.
 */
package com.kursaha.mailkeets.client;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.kursaha.Credentials;
import com.kursaha.common.ErrorMessageDto;
import com.kursaha.common.MailkeetsException;
import com.kursaha.mailkeets.client.MailkeetsClient;
import com.kursaha.mailkeets.client.MailkeetsService;
import com.kursaha.mailkeets.dto.MailRequestDto;
import com.kursaha.mailkeets.dto.MailResponseDto;
import com.kursaha.mailkeets.dto.VerifiedDomainNameResponseDto;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MailkeetsClientImpl
implements MailkeetsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MailkeetsClientImpl.class.getName());
    private final String apiKey;
    private final MailkeetsService service;
    private final Gson gson;

    public MailkeetsClientImpl(Credentials credentials, Gson gson, String baseUrl, OkHttpClient okHttpClient) {
        this.apiKey = credentials.getApiKey();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (MailkeetsService)retrofit.create(MailkeetsService.class);
        this.gson = gson;
    }

    @Override
    public String send(String subject, String to, String from, String fromName, String contentType, String body, String unsubscribedList) throws MailkeetsException, IOException {
        UUID requestIdentifier = UUID.randomUUID();
        MailRequestDto requestDto = new MailRequestDto(fromName, from, to, subject, contentType, body, requestIdentifier, unsubscribedList);
        return this.sendMail(requestDto);
    }

    @Override
    public String sendMail(MailRequestDto requestDto) throws MailkeetsException, IOException {
        Call<MailResponseDto> repos = this.service.sendMail(requestDto, "Bearer " + this.apiKey);
        Response response = repos.execute();
        if (!response.isSuccessful()) {
            try {
                ErrorMessageDto errorMessageDto = (ErrorMessageDto)this.gson.fromJson(response.errorBody().charStream(), ErrorMessageDto.class);
                LOGGER.error("failed to execute request : {}", (Object)errorMessageDto);
                throw new MailkeetsException(errorMessageDto);
            }
            catch (JsonIOException | JsonSyntaxException je) {
                throw new RuntimeException(je);
            }
        }
        return requestDto.getRequestIdentifier().toString();
    }

    @Override
    public List<VerifiedDomainNameResponseDto> getVerifiedDomains() throws Exception {
        ErrorMessageDto errorResponse = new ErrorMessageDto();
        try {
            Call<List<VerifiedDomainNameResponseDto>> repos = this.service.getVerifiedDomains("Bearer " + this.apiKey);
            Response response = repos.execute();
            if (!response.isSuccessful()) {
                int ch;
                String responseAsString = null;
                StringBuilder sb = new StringBuilder();
                while ((ch = response.errorBody().charStream().read()) != -1) {
                    sb.append((char)ch);
                }
                responseAsString = sb.toString();
                errorResponse = (ErrorMessageDto)this.gson.fromJson(responseAsString, ErrorMessageDto.class);
                LOGGER.error("failed to execute request : {}", (Object)errorResponse);
            }
            return (List)response.body();
        }
        catch (Exception e) {
            LOGGER.error("failed to execute request : {}", (Object)errorResponse);
            throw e;
        }
    }
}

